/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.validation.BasicArtifactProcessor;
import org.jboss.as.patching.validation.PatchHistoryValidations;
import org.jboss.as.patching.validation.PatchingArtifact;
import org.jboss.as.patching.validation.PatchingArtifactStateHandler;
import org.jboss.as.patching.validation.PatchingArtifacts;
import org.jboss.as.patching.validation.PatchingValidationErrorHandler;

public interface PatchHistoryIterator {
    public boolean hasNext();

    public String peek();

    public String next();

    public String next(PatchingValidationErrorHandler var1);

    public static final class Builder {
        private final InstalledIdentity identity;
        private final PatchHistoryValidations.PatchingArtifactStateHandlers handlers = new PatchHistoryValidations.PatchingArtifactStateHandlers();
        private PatchingValidationErrorHandler errorHandler = PatchingValidationErrorHandler.DEFAULT;

        public static Builder create(InstalledIdentity identity) {
            return new Builder(identity);
        }

        private Builder(InstalledIdentity identity) {
            this.identity = identity;
        }

        public void setErrorHandler(PatchingValidationErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        public <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> void addStateHandler(PatchingArtifact<P, S> artifact, PatchingArtifactStateHandler<S> handler) {
            this.handlers.put(artifact, handler);
        }

        public PatchHistoryIterator iterator() {
            final ArrayList<String> patches = new ArrayList<String>(this.identity.getAllInstalledPatches());
            Collections.reverse(patches);
            final int size = patches.size();
            final BasicArtifactProcessor processor = new BasicArtifactProcessor(this.identity, this.errorHandler, this.handlers);
            PatchHistoryIterator iterator = new PatchHistoryIterator(){
                int idx = 0;

                @Override
                public boolean hasNext() {
                    return this.idx != size;
                }

                @Override
                public String peek() {
                    int i = this.idx + 1;
                    if (i >= size) {
                        throw new NoSuchElementException();
                    }
                    return (String)patches.get(this.idx);
                }

                @Override
                public String next() {
                    return this.next(errorHandler);
                }

                @Override
                public String next(PatchingValidationErrorHandler context) {
                    int i = this.idx;
                    if (i >= size) {
                        throw new NoSuchElementException();
                    }
                    this.idx = i + 1;
                    String patch = (String)patches.get(i);
                    int nextIdx = i + 1;
                    String nextPatch = null;
                    if (nextIdx < size) {
                        nextPatch = (String)patches.get(nextIdx);
                    }
                    PatchingArtifacts.PatchID patchID = new PatchingArtifacts.PatchID(patch, nextPatch);
                    processor.processRoot(PatchingArtifacts.HISTORY_RECORD, patchID, context);
                    return patch;
                }
            };
            return iterator;
        }
    }
}

