/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleArrayJdbcType;
import org.hibernate.dialect.OracleNestedTableJdbcType;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleNestedTableJdbcTypeConstructor
implements JdbcTypeConstructor {
    @Override
    public JdbcType resolveType(TypeConfiguration typeConfiguration, Dialect dialect, BasicType<?> elementType, ColumnTypeInformation columnTypeInformation) {
        String typeName = columnTypeInformation.getTypeName();
        if (typeName == null || typeName.isBlank()) {
            typeName = OracleArrayJdbcType.getTypeName(elementType.getJavaTypeDescriptor(), dialect);
        }
        return new OracleNestedTableJdbcType(elementType.getJdbcType(), typeName);
    }

    @Override
    public JdbcType resolveType(TypeConfiguration typeConfiguration, Dialect dialect, JdbcType elementType, ColumnTypeInformation columnTypeInformation) {
        return new OracleNestedTableJdbcType(elementType, columnTypeInformation.getTypeName());
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 4000;
    }
}

