/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityEntryExtraState;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractReassociateEventListener;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.id.Assigned;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public abstract class AbstractSaveEventListener<C>
extends AbstractReassociateEventListener
implements CallbackRegistryConsumer {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AbstractSaveEventListener.class);
    private CallbackRegistry callbackRegistry;

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    protected Object saveWithRequestedId(Object entity, Object requestedId, String entityName, C context, EventSource source) {
        EntityPersister persister = source.getEntityPersister(entityName, entity);
        return this.performSave(entity, requestedId, persister, false, context, source, false);
    }

    protected Object saveWithGeneratedId(Object entity, String entityName, C context, EventSource source, boolean requiresImmediateIdAccess) {
        Object generatedId;
        EntityPersister persister = source.getEntityPersister(entityName, entity);
        Generator generator = persister.getGenerator();
        boolean generatedOnExecution = generator.generatedOnExecution();
        if (generatedOnExecution) {
            generatedId = null;
        } else if (generator instanceof Assigned) {
            generatedId = null;
        } else {
            generatedId = AbstractSaveEventListener.generateId(entity, source, (BeforeExecutionGenerator)generator, persister);
            if (generatedId == IdentifierGeneratorHelper.SHORT_CIRCUIT_INDICATOR) {
                return source.getIdentifier(entity);
            }
            persister.setIdentifier(entity, generatedId, source);
        }
        boolean delayIdentityInserts = !source.isTransactionInProgress() && !requiresImmediateIdAccess && generatedOnExecution;
        return this.performSave(entity, generatedId, persister, generatedOnExecution, context, source, delayIdentityInserts);
    }

    private static Object generateId(Object entity, EventSource source, BeforeExecutionGenerator generator, EntityPersister persister) {
        Object id = generator.generate(source, entity, null, EventType.INSERT);
        if (id == null) {
            throw new IdentifierGenerationException("Null id generated for entity '" + persister.getEntityName() + "'");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Generated identifier: %s, using strategy: %s", persister.getIdentifierType().toLoggableString(id, (SessionFactoryImplementor)source.getFactory()), generator.getClass().getName());
        }
        return id;
    }

    protected Object performSave(Object entity, Object id, EntityPersister persister, boolean useIdentityColumn, C context, EventSource source, boolean delayIdentityInserts) {
        EntityKey key;
        this.callbackRegistry.preCreate(entity);
        ManagedTypeHelper.processIfSelfDirtinessTracker(entity, SelfDirtinessTracker::$$_hibernate_clearDirtyAttributes);
        if (persister.getGenerator() instanceof Assigned && (id = persister.getIdentifier(entity, source)) == null) {
            throw new IdentifierGenerationException("Identifier of entity '" + persister.getEntityName() + "' must be manually assigned before calling 'persist()'");
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Saving {0}", MessageHelper.infoString(persister, id, (SessionFactoryImplementor)source.getFactory()));
        }
        EntityKey entityKey = key = useIdentityColumn ? null : AbstractSaveEventListener.entityKey(id, persister, source);
        if (this.invokeSaveLifecycle(entity, persister, source)) {
            return id;
        }
        return this.performSaveOrReplicate(entity, key, persister, useIdentityColumn, context, source, delayIdentityInserts);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EntityKey entityKey(Object id, EntityPersister persister, EventSource source) {
        EntityKey key = source.generateEntityKey(id, persister);
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        Object old = persistenceContext.getEntity(key);
        if (old != null) {
            if (persistenceContext.getEntry(old).getStatus() != Status.DELETED) throw new NonUniqueObjectException(id, persister.getEntityName());
            source.forceFlush(persistenceContext.getEntry(old));
            return key;
        } else {
            if (!persistenceContext.containsDeletedUnloadedEntityKey(key)) return key;
            source.forceFlush(key);
        }
        return key;
    }

    protected boolean invokeSaveLifecycle(Object entity, EntityPersister persister, EventSource source) {
        if (persister.implementsLifecycle()) {
            LOG.debug("Calling onSave()");
            if (((Lifecycle)entity).onSave(source)) {
                LOG.debug("Insertion vetoed by onSave()");
                return true;
            }
        }
        return false;
    }

    protected Object performSaveOrReplicate(Object entity, EntityKey key, EntityPersister persister, boolean useIdentityColumn, C context, EventSource source, boolean delayIdentityInserts) {
        EntityEntryExtraState extraState;
        Object id = key == null ? null : key.getIdentifier();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry original = persistenceContext.addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false);
        this.cascadeBeforeSave(source, persister, entity, context);
        AbstractEntityInsertAction insert = this.addInsertAction(this.cloneAndSubstituteValues(entity, persister, context, source, id), id, entity, persister, useIdentityColumn, source, delayIdentityInserts);
        this.cascadeAfterSave(source, persister, entity, context);
        Object finalId = AbstractSaveEventListener.handleGeneratedId(useIdentityColumn, id, insert);
        EntityEntry newEntry = persistenceContext.getEntry(entity);
        if (newEntry != original && (extraState = newEntry.getExtraState(EntityEntryExtraState.class)) == null) {
            newEntry.addExtraState(original.getExtraState(EntityEntryExtraState.class));
        }
        return finalId;
    }

    private static Object handleGeneratedId(boolean useIdentityColumn, Object id, AbstractEntityInsertAction insert) {
        if (useIdentityColumn && insert.isEarlyInsert()) {
            if (insert instanceof EntityIdentityInsertAction) {
                Object generatedId = ((EntityIdentityInsertAction)insert).getGeneratedId();
                insert.handleNaturalIdPostSaveNotifications(generatedId);
                return generatedId;
            }
            throw new IllegalStateException("Insert should be using an identity column, but action is of unexpected type: " + insert.getClass().getName());
        }
        return id;
    }

    private Object[] cloneAndSubstituteValues(Object entity, EntityPersister persister, C context, EventSource source, Object id) {
        Object[] values = persister.getPropertyValuesToInsert(entity, this.getMergeMap(context), source);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.substituteValuesIfNecessary(entity, id, values, persister, source);
        if (persister.hasCollections()) {
            boolean bl = substitute = this.visitCollectionsBeforeSave(entity, id, values, types, source) || substitute;
        }
        if (substitute) {
            persister.setValues(entity, values);
        }
        TypeHelper.deepCopy(values, types, persister.getPropertyUpdateability(), values, source);
        return values;
    }

    private AbstractEntityInsertAction addInsertAction(Object[] values, Object id, Object entity, EntityPersister persister, boolean useIdentityColumn, EventSource source, boolean delayIdentityInserts) {
        if (useIdentityColumn) {
            EntityIdentityInsertAction insert = new EntityIdentityInsertAction(values, entity, persister, this.isVersionIncrementDisabled(), source, delayIdentityInserts);
            source.getActionQueue().addAction(insert);
            return insert;
        }
        EntityInsertAction insert = new EntityInsertAction(id, values, entity, Versioning.getVersion(values, persister), persister, this.isVersionIncrementDisabled(), source);
        source.getActionQueue().addAction(insert);
        return insert;
    }

    protected Map<Object, Object> getMergeMap(C anything) {
        return null;
    }

    protected boolean isVersionIncrementDisabled() {
        return false;
    }

    protected boolean visitCollectionsBeforeSave(Object entity, Object id, Object[] values, Type[] types, EventSource source) {
        WrapVisitor visitor = new WrapVisitor(entity, id, source);
        visitor.processEntityPropertyValues(values, types);
        return visitor.isSubstitutionRequired();
    }

    protected boolean substituteValuesIfNecessary(Object entity, Object id, Object[] values, EntityPersister persister, SessionImplementor source) {
        boolean substitute = source.getInterceptor().onSave(entity, id, values, persister.getPropertyNames(), persister.getPropertyTypes());
        if (persister.isVersioned()) {
            substitute = Versioning.seedVersion(entity, values, persister, (SharedSessionContractImplementor)source) || substitute;
        }
        return substitute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, C context) {
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        persistenceContext.incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.BEFORE_INSERT_AFTER_DELETE, source, persister, entity, context);
        }
        finally {
            persistenceContext.decrementCascadeLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, C context) {
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        persistenceContext.incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.AFTER_INSERT_BEFORE_DELETE, source, persister, entity, context);
        }
        finally {
            persistenceContext.decrementCascadeLevel();
        }
    }

    protected abstract CascadingAction<C> getCascadeAction();
}

