/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class ArrayDdlTypeImpl
extends DdlTypeImpl {
    public ArrayDdlTypeImpl(Dialect dialect) {
        super(2003, "array", dialect);
    }

    @Override
    public String getTypeName(Size columnSize, Type type, DdlTypeRegistry ddlTypeRegistry) {
        BasicPluralType pluralType = (BasicPluralType)type;
        BasicPluralJavaType javaTypeDescriptor = (BasicPluralJavaType)((Object)pluralType.getJavaTypeDescriptor());
        BasicType elementType = pluralType.getElementType();
        String arrayElementTypeName = ddlTypeRegistry.getTypeName(elementType.getJdbcType().getDdlTypeCode(), this.dialect.getSizeStrategy().resolveSize(elementType.getJdbcMapping().getJdbcType(), elementType.getJavaTypeDescriptor(), columnSize.getPrecision(), columnSize.getScale(), columnSize.getLength()), elementType);
        return this.dialect.getArrayTypeName(javaTypeDescriptor.getElementJavaType().getJavaTypeClass().getSimpleName(), arrayElementTypeName, columnSize.getArrayLength());
    }
}

