/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import java.util.function.Function;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.wildfly.extension.picketlink.common.model.AbstractResourceDefinition;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.validator.ModelValidationStepHandler;
import org.wildfly.extension.picketlink.idm.IDMExtension;
import org.wildfly.extension.picketlink.idm.model.DefaultAddStepHandler;
import org.wildfly.extension.picketlink.idm.model.DefaultRemoveStepHandler;
import org.wildfly.extension.picketlink.idm.model.IDMConfigWriteAttributeHandler;

public abstract class AbstractIDMResourceDefinition
extends AbstractResourceDefinition {
    private final ModelValidationStepHandler[] modelValidators;
    private final Function<PathAddress, PathAddress> partitionAddressProvider;

    protected AbstractIDMResourceDefinition(ModelElement modelElement, Function<PathAddress, PathAddress> partitionAddressProvider, SimpleAttributeDefinition ... attributes) {
        this(modelElement, null, partitionAddressProvider, attributes);
    }

    protected AbstractIDMResourceDefinition(ModelElement modelElement, ModelValidationStepHandler[] modelValidators, Function<PathAddress, PathAddress> partitionAddressProvider, SimpleAttributeDefinition ... attributes) {
        super(modelElement, (OperationStepHandler)new DefaultAddStepHandler(modelValidators, partitionAddressProvider, (AttributeDefinition[])attributes), (OperationStepHandler)new DefaultRemoveStepHandler(partitionAddressProvider), IDMExtension.getResourceDescriptionResolver(modelElement.getName()), attributes);
        this.modelValidators = modelValidators;
        this.partitionAddressProvider = partitionAddressProvider;
    }

    @Override
    protected OperationStepHandler createAttributeWriterHandler() {
        return new IDMConfigWriteAttributeHandler(this.modelValidators, this.partitionAddressProvider, this.getAttributes().toArray(new AttributeDefinition[0]));
    }
}

