/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.runtime;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.security.MethodLookupAction;
import org.jboss.weld.security.SetAccessibleAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static void ensureAccessible(AccessibleObject accessibleObject) {
        if (accessibleObject != null && !accessibleObject.isAccessible()) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(SetAccessibleAction.of(accessibleObject));
            } else {
                accessibleObject.setAccessible(true);
            }
        }
    }

    static Method lookupMethod(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(new MethodLookupAction(javaClass, methodName, parameterTypes));
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)e.getCause();
                }
                throw new WeldException(e.getCause());
            }
        }
        return MethodLookupAction.lookupMethod(javaClass, methodName, parameterTypes);
    }
}

