/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.logger;

import java.util.Arrays;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolLogger;
import org.slf4j.Logger;

public class ActiveMQAMQPProtocolLogger_impl
implements ActiveMQAMQPProtocolLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQAMQPProtocolLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void cantRemovingScheduledTask() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ111000: Scheduled task can't be removed from scheduledPool.");
        }
    }

    @Override
    public void retryConnectionFailed(String name, String hostAndPort, int currentRetry) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ111001: \n*******************************************************************************************************************************\nCould not re-establish AMQP Server Connection {} on {} after {} retries\n*******************************************************************************************************************************\n", new Object[]{name, hostAndPort, currentRetry});
        }
    }

    @Override
    public void retryConnection(String name, String hostAndPort, int currentRetry, int maxRetry) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ111002: \n*******************************************************************************************************************************\nRetrying Server AMQP Connection {} on {} retry {} of {}\n*******************************************************************************************************************************\n", new Object[]{name, hostAndPort, currentRetry, maxRetry});
        }
    }

    @Override
    public void successReconnect(String name, String hostAndPort, int currentRetry) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ111003: \n*******************************************************************************************************************************\nConnected on Server AMQP Connection {} on {} after {} retries\n*******************************************************************************************************************************\n", new Object[]{name, hostAndPort, currentRetry});
        }
    }

    @Override
    public void incompatibleAddressFullMessagePolicy(String oldAddress, String oldPolicy, String newAddress, String newPolicy) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ111004: AddressFullPolicy clash on an anonymous producer between destinations {}(addressFullPolicy={}) and {}(addressFullPolicy={}). This could lead to semantic inconsistencies on your clients. Notice you could have other instances of this scenario however this message will only be logged once. log.debug output would show all instances of this event.", new Object[]{oldAddress, oldPolicy, newAddress, newPolicy});
        }
    }

    @Override
    public void messageConversionFailed(Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ111005: Failed to convert message. Sending it to Dead Letter Address.", t);
        }
    }

    @Override
    public void unableToSendMessageToDLA(MessageReference ref, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ111006: Unable to send message {} to Dead Letter Address.", (Object)ref, (Object)t);
        }
    }
}

