/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableRealmIdentityIterator;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.credential.Credential;

public class FileSystemRealmUtil {
    public static void cloneIdentitiesToNewRealm(FileSystemSecurityRealm oldRealm, FileSystemSecurityRealm newRealm) throws RealmUnavailableException {
        Assert.checkNotNullParam("Old FileSystem Realm", oldRealm);
        Assert.checkNotNullParam("New FileSystem Realm", newRealm);
        ModifiableRealmIdentityIterator realmIterator = oldRealm.getRealmIdentityIterator();
        while (realmIterator.hasNext()) {
            ModifiableRealmIdentity oldIdentity = (ModifiableRealmIdentity)realmIterator.next();
            List<Credential> credentials = ((FileSystemSecurityRealm.Identity)oldIdentity).loadCredentials();
            Attributes attributes = oldIdentity.getAttributes();
            ModifiableRealmIdentity newIdentity = newRealm.getRealmIdentityForUpdate(new NamePrincipal(oldIdentity.getRealmIdentityPrincipal().getName()));
            newIdentity.create();
            newIdentity.setCredentials(credentials);
            newIdentity.setAttributes(attributes);
            newIdentity.dispose();
        }
        realmIterator.close();
    }
}

