/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan;

import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.util.concurrent.BlockingManager;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.CacheConfiguration;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.InfinispanCacheProperties;
import org.wildfly.clustering.ee.infinispan.tx.InfinispanBatcher;

public interface InfinispanConfiguration
extends CacheConfiguration {
    public <K, V> Cache<K, V> getCache();

    default public CacheProperties getCacheProperties() {
        return new InfinispanCacheProperties(this.getCache().getCacheConfiguration());
    }

    default public <K, V> Cache<K, V> getReadForUpdateCache() {
        return this.getCacheProperties().isLockOnRead() ? this.getCache().getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK) : this.getCache();
    }

    default public <K, V> Cache<K, V> getTryLockCache() {
        return this.getCacheProperties().isLockOnWrite() ? this.getCache().getAdvancedCache().withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}) : this.getCache();
    }

    default public <K, V> Cache<K, V> getTryReadForUpdateCache() {
        return this.getCacheProperties().isLockOnRead() ? this.getCache().getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}) : this.getCache();
    }

    default public <K, V> Cache<K, V> getWriteOnlyCache() {
        return this.getCache().getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
    }

    default public <K, V> Cache<K, V> getSilentWriteCache() {
        return this.getCache().getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_LISTENER_NOTIFICATION});
    }

    default public Batcher<TransactionBatch> getBatcher() {
        return new InfinispanBatcher(this.getCache());
    }

    default public BlockingManager getBlockingManager() {
        return (BlockingManager)this.getCache().getCacheManager().getGlobalComponentRegistry().getComponent(BlockingManager.class);
    }
}

