/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.Services;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossThreadFactory;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.executor.AbstractExecutorServices;
import org.jboss.weld.manager.api.ExecutorServices;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldExecutorServices
extends AbstractExecutorServices
implements Service {
    public static final int DEFAULT_BOUND = Runtime.getRuntime().availableProcessors() + 1;
    public static final ServiceName SERVICE_NAME = Services.JBOSS_AS.append(new String[]{"weld", "executor"});
    private static final String THREAD_NAME_PATTERN = "Weld Thread Pool -- %t";
    private final int bound;
    private final Consumer<ExecutorServices> executorServicesConsumer;
    private ExecutorService executor;

    public WeldExecutorServices() {
        this(null, DEFAULT_BOUND);
    }

    public WeldExecutorServices(Consumer<ExecutorServices> executorServicesConsumer, int bound) {
        this.executorServicesConsumer = executorServicesConsumer;
        this.bound = bound;
    }

    public void start(StartContext context) throws StartException {
        JBossThreadFactory factory = new JBossThreadFactory(null, Boolean.FALSE, null, THREAD_NAME_PATTERN, null, null);
        this.executor = new WeldExecutor(this.bound, arg_0 -> this.lambda$start$0((ThreadFactory)factory, arg_0));
        if (this.executorServicesConsumer != null) {
            this.executorServicesConsumer.accept((ExecutorServices)this);
        }
    }

    public void stop(StopContext context) {
        if (this.executorServicesConsumer != null) {
            this.executorServicesConsumer.accept(null);
        }
        if (this.executor != null) {
            context.asynchronous();
            new Thread(() -> {
                super.shutdown();
                this.executor = null;
                context.complete();
            }).start();
        }
    }

    protected synchronized int getThreadPoolSize() {
        return this.bound;
    }

    public synchronized ExecutorService getTaskExecutor() {
        return this.executor;
    }

    public void cleanup() {
    }

    private /* synthetic */ Thread lambda$start$0(ThreadFactory factory, Runnable runnable) {
        final Thread thread = factory.newThread(runnable);
        if (WildFlySecurityManager.isChecking()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    thread.setContextClassLoader(null);
                    return null;
                }
            });
        } else {
            thread.setContextClassLoader(null);
        }
        return thread;
    }

    static class WeldTaskWrapper
    implements Runnable {
        private final Runnable runnable;
        private final NamespaceContextSelector currentSelector;

        public WeldTaskWrapper(Runnable runnable, NamespaceContextSelector currentSelector) {
            this.runnable = runnable;
            this.currentSelector = currentSelector;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }

    static class WeldExecutor
    extends ThreadPoolExecutor {
        WeldExecutor(int nThreads, ThreadFactory threadFactory) {
            super(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            if (r instanceof WeldTaskWrapper) {
                NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)((WeldTaskWrapper)r).currentSelector);
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (r instanceof WeldTaskWrapper) {
                NamespaceContextSelector.popCurrentSelector();
            }
        }

        @Override
        public void execute(Runnable command) {
            if (Container.instance().getState() == ContainerState.INITIALIZED) {
                WeldTaskWrapper task = new WeldTaskWrapper(command, NamespaceContextSelector.getCurrentSelector());
                super.execute(task);
            } else {
                super.execute(command);
            }
        }
    }
}

