/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.BootContext;
import org.jboss.as.controller.BootErrorCollector;
import org.jboss.as.controller.CapabilityRegistry;
import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.ModelControllerClientFactoryImpl;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.ModelControllerServiceInitialization;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextImpl;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.TemporaryModuleLayer;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.ManagementSecurityIdentitySupplier;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.registry.CapabilityScope;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistration;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.client.impl.AdditionalBootCliScriptInvoker;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.notification.NotificationHandlerRegistry;
import org.jboss.as.controller.notification.NotificationSupport;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.persistence.ConfigurationExtension;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NotificationHandlerRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.filter.PathFilter;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class AbstractControllerService
implements Service<ModelController> {
    public static final String BOOT_STACK_SIZE_PROPERTY = "jboss.boot.thread.stack.size";
    public static final int DEFAULT_BOOT_STACK_SIZE = 0x200000;
    protected static final RuntimeCapability<Void> CLIENT_FACTORY_CAPABILITY = RuntimeCapability.Builder.of("org.wildfly.management.model-controller-client-factory", ModelControllerClientFactory.class).build();
    protected static final RuntimeCapability<Void> NOTIFICATION_REGISTRY_CAPABILITY = RuntimeCapability.Builder.of("org.wildfly.management.notification-handler-registry", NotificationHandlerRegistry.class).build();
    public static final RuntimeCapability<Void> PATH_MANAGER_CAPABILITY = RuntimeCapability.Builder.of(PathManager.SERVICE_DESCRIPTOR).build();
    public static final RuntimeCapability<Void> EXECUTOR_CAPABILITY = RuntimeCapability.Builder.of("org.wildfly.management.executor", ExecutorService.class).build();
    protected static final RuntimeCapability<Void> PROCESS_STATE_NOTIFIER_CAPABILITY = RuntimeCapability.Builder.of("org.wildfly.management.process-state-notifier", ProcessStateNotifier.class).build();
    private static final OperationDefinition INIT_CONTROLLER_OP = new SimpleOperationDefinitionBuilder("boottime-controller-initializer-step", null).setPrivateEntry().build();
    protected final ProcessType processType;
    protected final Stability stability;
    protected final DelegatingConfigurableAuthorizer authorizer;
    protected final ManagementSecurityIdentitySupplier securityIdentitySupplier;
    private final RunningModeControl runningModeControl;
    private final ResourceDefinition rootResourceDefinition;
    private final ControlledProcessState processState;
    private final OperationStepHandler prepareStep;
    private final Supplier<ExecutorService> executorService;
    private final Supplier<ControllerInstabilityListener> instabilityListener;
    private final ExpressionResolver expressionResolver;
    private volatile ModelControllerImpl controller;
    private ConfigurationPersister configurationPersister;
    private final ManagedAuditLogger auditLogger;
    private final BootErrorCollector bootErrorCollector;
    private final CapabilityRegistry capabilityRegistry;
    private final ConfigurationExtension configExtension;
    private volatile ModelControllerClientFactory clientFactory;

    private static int getBootStackSize() {
        String prop = WildFlySecurityManager.getPropertyPrivileged((String)BOOT_STACK_SIZE_PROPERTY, null);
        if (prop == null) {
            return 0x200000;
        }
        int base = 1;
        String multiple = prop;
        int lastIdx = prop.length() - 1;
        if (lastIdx > 0) {
            char last = prop.charAt(lastIdx);
            if ('k' == last || 'K' == last) {
                multiple = prop.substring(0, lastIdx);
                base = 1024;
            } else if ('m' == last || 'M' == last) {
                multiple = prop.substring(0, lastIdx);
                base = 0x100000;
            }
        }
        try {
            return Integer.parseInt(multiple) * base;
        }
        catch (NumberFormatException e) {
            ControllerLogger.ROOT_LOGGER.invalidSystemPropertyValue(prop, BOOT_STACK_SIZE_PROPERTY, 0x200000);
            return 0x200000;
        }
    }

    @Deprecated
    protected AbstractControllerService(ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, ResourceDefinition rootResourceDefinition, OperationStepHandler prepareStep, ExpressionResolver expressionResolver, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer, ManagementSecurityIdentitySupplier securityIdentitySupplier, CapabilityRegistry capabilityRegistry) {
        this(null, null, processType, Stability.DEFAULT, runningModeControl, configurationPersister, processState, rootResourceDefinition, null, prepareStep, expressionResolver, auditLogger, authorizer, securityIdentitySupplier, capabilityRegistry, null);
    }

    @Deprecated
    protected AbstractControllerService(Supplier<ExecutorService> executorService, Supplier<ControllerInstabilityListener> instabilityListener, ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, ResourceDefinition rootResourceDefinition, OperationStepHandler prepareStep, ExpressionResolver expressionResolver, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer, ManagementSecurityIdentitySupplier securityIdentitySupplier, CapabilityRegistry capabilityRegistry, ConfigurationExtension configExtension) {
        this(executorService, instabilityListener, processType, Stability.DEFAULT, runningModeControl, configurationPersister, processState, rootResourceDefinition, null, prepareStep, expressionResolver, auditLogger, authorizer, securityIdentitySupplier, capabilityRegistry, configExtension);
    }

    protected AbstractControllerService(Supplier<ExecutorService> executorService, Supplier<ControllerInstabilityListener> instabilityListener, ProcessType processType, Stability stability, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, ResourceDefinition rootResourceDefinition, OperationStepHandler prepareStep, ExpressionResolver expressionResolver, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer, ManagementSecurityIdentitySupplier securityIdentitySupplier, CapabilityRegistry capabilityRegistry, ConfigurationExtension configExtension) {
        this(executorService, instabilityListener, processType, stability, runningModeControl, configurationPersister, processState, rootResourceDefinition, null, prepareStep, expressionResolver, auditLogger, authorizer, securityIdentitySupplier, capabilityRegistry, configExtension);
    }

    private AbstractControllerService(Supplier<ExecutorService> executorService, Supplier<ControllerInstabilityListener> instabilityListener, ProcessType processType, Stability stability, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, ResourceDefinition rootResourceDefinition, DescriptionProvider rootDescriptionProvider, OperationStepHandler prepareStep, ExpressionResolver expressionResolver, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer, ManagementSecurityIdentitySupplier securityIdentitySupplier, CapabilityRegistry capabilityRegistry, ConfigurationExtension configExtension) {
        assert (rootDescriptionProvider == null) : "description provider cannot be used anymore";
        assert (rootResourceDefinition != null) : "Null root resource definition";
        assert (expressionResolver != null) : "Null expressionResolver";
        assert (auditLogger != null) : "Null auditLogger";
        assert (authorizer != null) : "Null authorizer";
        assert (securityIdentitySupplier != null) : "Null securityIdentitySupplier";
        assert (capabilityRegistry != null) : "Null capabilityRegistry";
        this.executorService = executorService;
        this.instabilityListener = instabilityListener;
        this.processType = processType;
        this.stability = stability;
        this.runningModeControl = runningModeControl;
        this.configurationPersister = configurationPersister;
        this.rootResourceDefinition = rootResourceDefinition;
        this.processState = processState;
        this.prepareStep = prepareStep;
        this.expressionResolver = expressionResolver;
        this.auditLogger = auditLogger;
        this.authorizer = authorizer;
        this.securityIdentitySupplier = securityIdentitySupplier;
        this.bootErrorCollector = new BootErrorCollector();
        this.capabilityRegistry = capabilityRegistry.createShadowCopy();
        this.configExtension = configExtension;
    }

    public void start(StartContext context) throws StartException {
        assert (this.capabilityRegistry.getPossibleCapabilities().isEmpty()) : "registry is not empty";
        if (this.configurationPersister == null) {
            throw ControllerLogger.ROOT_LOGGER.persisterNotInjected();
        }
        ServiceController serviceController = context.getController();
        final ServiceContainer container = serviceController.getServiceContainer();
        final ServiceTarget target = context.getChildTarget();
        ExecutorService executorService = this.executorService != null ? this.executorService.get() : null;
        NotificationSupport notificationSupport = NotificationSupport.Factory.create(executorService);
        WritableAuthorizerConfiguration authorizerConfig = this.authorizer.getWritableAuthorizerConfiguration();
        authorizerConfig.reset();
        ManagementResourceRegistration rootResourceRegistration = ManagementResourceRegistration.Factory.forProcessType(this.processType, this.stability).createRegistration(this.rootResourceDefinition, authorizerConfig, this.capabilityRegistry);
        ModelControllerImpl controller = new ModelControllerImpl((ServiceRegistry)container, target, rootResourceRegistration, new ContainerStateMonitor(container), this.configurationPersister, this.processType, this.runningModeControl, this.prepareStep, this.processState, executorService, this.expressionResolver, this.authorizer, this.securityIdentitySupplier, this.auditLogger, notificationSupport, this.bootErrorCollector, this.createExtraValidationStepHandler(), this.capabilityRegistry, this.getPartialModelIndicator(), this.instabilityListener != null ? this.instabilityListener.get() : null);
        this.initModel(controller.getManagementModel(), controller.getModelControllerResource());
        this.clientFactory = new ModelControllerClientFactoryImpl(controller, this.securityIdentitySupplier);
        if (this.isExposingClientServicesAllowed()) {
            this.capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(CLIENT_FACTORY_CAPABILITY, CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
            this.capabilityRegistry.registerCapability(new RuntimeCapabilityRegistration(NOTIFICATION_REGISTRY_CAPABILITY, CapabilityScope.GLOBAL, new RegistrationPoint(PathAddress.EMPTY_ADDRESS, null)));
            rootResourceRegistration.registerCapability(CLIENT_FACTORY_CAPABILITY);
            rootResourceRegistration.registerCapability(NOTIFICATION_REGISTRY_CAPABILITY);
            ServiceName clientFactorySN = CLIENT_FACTORY_CAPABILITY.getCapabilityServiceName();
            ServiceBuilder clientFactorySB = target.addService(clientFactorySN);
            clientFactorySB.setInstance(new SimpleService<ModelControllerClientFactory>(clientFactorySB.provides(new ServiceName[]{clientFactorySN}), this.clientFactory));
            clientFactorySB.install();
            ServiceName notifyRegistrySN = NOTIFICATION_REGISTRY_CAPABILITY.getCapabilityServiceName();
            ServiceBuilder notifyRegistrySB = target.addService(notifyRegistrySN);
            notifyRegistrySB.setInstance(new SimpleService<NotificationHandlerRegistration>(notifyRegistrySB.provides(new ServiceName[]{notifyRegistrySN}), controller.getNotificationRegistry()));
            notifyRegistrySB.install();
        }
        this.capabilityRegistry.publish();
        this.controller = controller;
        this.processState.setStarting();
        final long bootStackSize = AbstractControllerService.getBootStackSize();
        Thread bootThread = new Thread(null, new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        AbstractControllerService.this.boot(new BootContext(){

                            @Override
                            public ServiceTarget getServiceTarget() {
                                return target;
                            }
                        });
                    }
                    finally {
                        AbstractControllerService.this.processState.setRunning();
                    }
                    AbstractControllerService.this.postBoot();
                }
                catch (Throwable t) {
                    container.shutdown();
                    if (t instanceof StackOverflowError) {
                        ControllerLogger.ROOT_LOGGER.errorBootingContainer(t, bootStackSize, AbstractControllerService.BOOT_STACK_SIZE_PROPERTY);
                    } else {
                        ControllerLogger.ROOT_LOGGER.errorBootingContainer(t);
                    }
                }
                finally {
                    AbstractControllerService.this.bootThreadDone();
                }
            }
        }, "Controller Boot Thread", bootStackSize);
        bootThread.start();
    }

    protected boolean isExposingClientServicesAllowed() {
        return true;
    }

    protected void boot(BootContext context) throws ConfigurationPersistenceException {
        List<ModelNode> bootOps = this.configurationPersister.load();
        ModelNode op = this.registerModelControllerServiceInitializationBootStep(context);
        if (op != null) {
            bootOps.add(op);
        }
        this.boot(bootOps, false);
        this.finishBoot();
    }

    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure) throws ConfigurationPersistenceException {
        return this.boot(bootOperations, rollbackOnRuntimeFailure, false, ModelControllerImpl.getMutableRootResourceRegistrationProvider());
    }

    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure, boolean skipModelValidation) throws ConfigurationPersistenceException {
        return this.boot(bootOperations, rollbackOnRuntimeFailure, skipModelValidation, ModelControllerImpl.getMutableRootResourceRegistrationProvider());
    }

    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure, boolean skipModelValidation, MutableRootResourceRegistrationProvider parallelBootRootResourceRegistrationProvider) throws ConfigurationPersistenceException {
        return this.controller.boot(bootOperations, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT, rollbackOnRuntimeFailure, parallelBootRootResourceRegistrationProvider, skipModelValidation, this.getPartialModelIndicator().isModelPartial(), this.configExtension);
    }

    protected OperationResponse internalExecute(Operation operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep) {
        return this.controller.internalExecute(operation.getOperation(), handler, control, (OperationAttachments)operation, prepareStep, false, this.getPartialModelIndicator().isModelPartial());
    }

    protected OperationResponse internalExecute(Operation operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep, boolean attemptLock) {
        return this.controller.internalExecute(operation.getOperation(), handler, control, (OperationAttachments)operation, prepareStep, attemptLock, this.getPartialModelIndicator().isModelPartial());
    }

    protected OperationResponse internalExecute(Operation operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep, boolean attemptLock, boolean partialModel) {
        return this.controller.internalExecute(operation.getOperation(), handler, control, (OperationAttachments)operation, prepareStep, attemptLock, partialModel);
    }

    protected final ModelNode executeReadOnlyOperation(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep, int lockPermit) {
        return this.controller.executeReadOnlyOperation(operation, handler, control, prepareStep, lockPermit);
    }

    protected final ModelNode executeReadOnlyOperation(ModelNode operation, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep) {
        return this.controller.executeReadOnlyOperation(operation, control, prepareStep);
    }

    protected final ModelNode executeReadOnlyOperation(ModelNode operation, Resource model, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep) {
        return this.controller.executeReadOnlyOperation(operation, model, control, prepareStep);
    }

    protected void finishBoot() throws ConfigurationPersistenceException {
        this.controller.finishBoot();
        this.configurationPersister.successfulBoot();
        this.capabilityRegistry.publish();
    }

    protected void finishBoot(boolean readOnly) throws ConfigurationPersistenceException {
        this.controller.finishBoot(readOnly);
        this.configurationPersister.successfulBoot();
        this.capabilityRegistry.publish();
    }

    protected void clearBootingReadOnlyFlag() {
        this.controller.clearBootingReadOnlyFlag();
    }

    protected void bootThreadDone() {
    }

    protected void postBoot() {
    }

    protected NotificationSupport getNotificationSupport() {
        return this.controller.getNotificationSupport();
    }

    protected final MutableRootResourceRegistrationProvider getMutableRootResourceRegistrationProvider() {
        return ModelControllerImpl.getMutableRootResourceRegistrationProvider();
    }

    protected PartialModelIndicator getPartialModelIndicator() {
        return PartialModelIndicator.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext context) {
        this.capabilityRegistry.clear();
        this.capabilityRegistry.publish();
        ServiceNameFactory.clearCache();
        this.controller = null;
        this.processState.setStopping();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractControllerService.this.stopAsynchronous(context);
                }
                finally {
                    try {
                        AbstractControllerService.this.authorizer.shutdown();
                    }
                    finally {
                        context.complete();
                    }
                }
            }
        };
        ExecutorService executorService = this.executorService != null ? this.executorService.get() : null;
        try {
            if (executorService != null) {
                try {
                    executorService.execute(r);
                }
                catch (RejectedExecutionException e) {
                    r.run();
                }
            } else {
                Thread executorShutdown = new Thread(r, this.getClass().getSimpleName() + " Shutdown Thread");
                executorShutdown.start();
            }
        }
        finally {
            this.processState.setStopped();
            context.asynchronous();
        }
    }

    protected void stopAsynchronous(StopContext context) {
    }

    public ModelController getValue() throws IllegalStateException, IllegalArgumentException {
        ModelControllerImpl controller;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        if ((controller = this.controller) == null) {
            throw new IllegalStateException();
        }
        return controller;
    }

    protected ExecutorService getExecutorService() {
        return this.executorService != null ? this.executorService.get() : null;
    }

    protected void setConfigurationPersister(ConfigurationPersister persister) {
        this.configurationPersister = persister;
    }

    protected abstract void initModel(ManagementModel var1, Resource var2);

    protected ManagedAuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    protected BootErrorCollector getBootErrorCollector() {
        return this.bootErrorCollector;
    }

    protected final ModelNode getBootErrors() {
        return this.bootErrorCollector.getErrors();
    }

    protected OperationStepHandler createExtraValidationStepHandler() {
        return null;
    }

    protected void acquireReadLock(int operationId) throws InterruptedException {
        this.controller.acquireReadLock(operationId, true);
    }

    protected void releaseReadLock(int operationId) {
        this.controller.releaseReadLock(operationId);
    }

    protected final ModelNode registerModelControllerServiceInitializationBootStep(BootContext context) {
        ModelControllerServiceInitializationParams initParams = this.getModelControllerServiceInitializationParams();
        if (initParams != null) {
            this.controller.getManagementModel().getRootResourceRegistration().registerOperationHandler(INIT_CONTROLLER_OP, new ModelControllerServiceInitializationBootStepHandler(initParams));
            return Util.createEmptyOperation(INIT_CONTROLLER_OP.getName(), PathAddress.EMPTY_ADDRESS);
        }
        return null;
    }

    protected ModelControllerServiceInitializationParams getModelControllerServiceInitializationParams() {
        return null;
    }

    protected ModelControllerClientFactory getModelControllerClientFactory() {
        return this.clientFactory;
    }

    protected void executeAdditionalCliBootScript() {
        String additionalBootCliScriptPath = WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.internal.cli.boot.hook.script", null);
        ControllerLogger.ROOT_LOGGER.debug("Checking -Dorg.wildfly.internal.cli.boot.hook.script to see if additional CLI operations are needed");
        if (additionalBootCliScriptPath == null) {
            ControllerLogger.ROOT_LOGGER.debug("No additional CLI operations are needed");
            return;
        }
        AdditionalBootCliScriptInvocation invocation = AdditionalBootCliScriptInvocation.create(additionalBootCliScriptPath, this);
        invocation.invoke();
    }

    private static class AdditionalBootCliScriptInvocation {
        private final AbstractControllerService controllerService;
        private final File additionalBootCliScript;
        private final boolean keepAlive;
        private final File doneMarker;
        private final File restartInitiated;
        private final File embeddedServerNeedsRestart;

        public AdditionalBootCliScriptInvocation(AbstractControllerService controllerService, File additionalBootCliScript, boolean keepAlive, File markerDirectory) {
            this.controllerService = controllerService;
            this.additionalBootCliScript = additionalBootCliScript;
            this.keepAlive = keepAlive;
            this.doneMarker = markerDirectory == null ? null : new File(markerDirectory, "wf-cli-invoker-result");
            this.restartInitiated = markerDirectory == null ? null : new File(markerDirectory, "wf-cli-shutdown-initiated");
            this.embeddedServerNeedsRestart = markerDirectory == null ? null : new File(markerDirectory, "wf-restart-embedded-server");
        }

        static AdditionalBootCliScriptInvocation create(String additionalBootCliScriptPath, AbstractControllerService controllerService) {
            boolean keepAlive = Boolean.parseBoolean(WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.internal.cli.boot.hook.reload.skip", (String)"false"));
            String markerDirectoryProperty = WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.internal.cli.boot.hook.marker.dir", null);
            if (keepAlive && markerDirectoryProperty == null) {
                throw ControllerLogger.ROOT_LOGGER.cliScriptPropertyDefinedWithoutMarkerDirectoryWhenNotSkippingReload("org.wildfly.internal.cli.boot.hook.reload.skip", "org.wildfly.internal.cli.boot.hook.script", "org.wildfly.internal.cli.boot.hook.marker.dir");
            }
            if (controllerService.processType != ProcessType.STANDALONE_SERVER && controllerService.processType != ProcessType.EMBEDDED_SERVER) {
                throw ControllerLogger.ROOT_LOGGER.propertyCanOnlyBeUsedWithStandaloneOrEmbeddedServer("org.wildfly.internal.cli.boot.hook.script");
            }
            if (controllerService.runningModeControl.getRunningMode() != RunningMode.ADMIN_ONLY) {
                throw ControllerLogger.ROOT_LOGGER.propertyCanOnlyBeUsedWithAdminOnlyModeServer("org.wildfly.internal.cli.boot.hook.script");
            }
            File additionalBootCliScriptFile = new File(additionalBootCliScriptPath);
            if (!additionalBootCliScriptFile.exists()) {
                throw ControllerLogger.ROOT_LOGGER.couldNotFindDirectorySpecifiedByProperty(additionalBootCliScriptPath, "org.wildfly.internal.cli.boot.hook.script");
            }
            File markerDirectory = null;
            if (markerDirectoryProperty != null && !(markerDirectory = new File(markerDirectoryProperty)).exists()) {
                throw ControllerLogger.ROOT_LOGGER.couldNotFindDirectorySpecifiedByProperty(markerDirectoryProperty, "org.wildfly.internal.cli.boot.hook.marker.dir");
            }
            return new AdditionalBootCliScriptInvocation(controllerService, additionalBootCliScriptFile, keepAlive, markerDirectory);
        }

        void invoke() {
            block11: {
                ControllerLogger.ROOT_LOGGER.checkingForPresenceOfRestartMarkerFile();
                if (this.restartInitiated != null && this.restartInitiated.exists()) {
                    ControllerLogger.ROOT_LOGGER.foundRestartMarkerFile(this.restartInitiated);
                    try (ModelControllerClient client = this.controllerService.controller.createBootClient(this.controllerService.executorService.get());){
                        this.deleteFile(this.restartInitiated);
                        this.executeReload(client, true);
                        break block11;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                ControllerLogger.ROOT_LOGGER.noRestartMarkerFile();
                if (this.keepAlive) {
                    ControllerLogger.ROOT_LOGGER.initialisedAdditionalBootCliScriptSystemKeepingAlive(this.additionalBootCliScript, this.doneMarker);
                } else {
                    ControllerLogger.ROOT_LOGGER.initialisedAdditionalBootCliScriptSystemNotKeepingAlive(this.additionalBootCliScript);
                }
                this.executeAdditionalCliScript();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void executeAdditionalCliScript() {
            block71: {
                Throwable suppressed;
                Throwable originalException;
                boolean success;
                block67: {
                    success = false;
                    originalException = null;
                    this.deleteFile(this.doneMarker);
                    this.deleteFile(this.embeddedServerNeedsRestart);
                    try (InvokerLoader loader = new InvokerLoader();){
                        assert (loader.getInvoker() != null) : "No invoker found";
                        try (ModelControllerClient client = this.controllerService.controller.createBootClient(this.controllerService.executorService.get());){
                            ControllerLogger.ROOT_LOGGER.executingBootCliScript(this.additionalBootCliScript);
                            loader.getInvoker().runCliScript(client, this.additionalBootCliScript);
                            ControllerLogger.ROOT_LOGGER.completedRunningBootCliScript();
                            if (!this.keepAlive) {
                                boolean restart = this.controllerService.processState.checkRestartRequired();
                                if (restart) {
                                    this.executeRestart(client);
                                } else {
                                    this.executeReload(client, false);
                                }
                            }
                            success = true;
                        }
                    }
                    this.clearProperties();
                    suppressed = originalException;
                    try {
                        if (this.doneMarker == null) break block67;
                        this.doneMarker.createNewFile();
                        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.doneMarker));){
                            writer.write(success ? "success" : "failed");
                            writer.write(10);
                        }
                    }
                    catch (IOException ex) {
                        if (originalException != null) {
                            originalException.addSuppressed(ex);
                            suppressed = originalException;
                        }
                        suppressed = new UncheckedIOException(ex);
                    }
                }
                if (suppressed != null) {
                    if (suppressed instanceof RuntimeException) {
                        throw (RuntimeException)suppressed;
                    }
                    if (suppressed instanceof Error) {
                        throw (Error)suppressed;
                    }
                }
                break block71;
                catch (IOException e) {
                    block68: {
                        originalException = new UncheckedIOException(e);
                        this.clearProperties();
                        suppressed = originalException;
                        try {
                            if (this.doneMarker == null) break block68;
                            this.doneMarker.createNewFile();
                            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.doneMarker));){
                                writer.write(success ? "success" : "failed");
                                writer.write(10);
                            }
                        }
                        catch (IOException ex) {
                            if (originalException != null) {
                                originalException.addSuppressed(ex);
                                suppressed = originalException;
                                break block68;
                            }
                            suppressed = new UncheckedIOException(ex);
                        }
                    }
                    if (suppressed != null) {
                        if (suppressed instanceof RuntimeException) {
                            throw (RuntimeException)suppressed;
                        }
                        if (suppressed instanceof Error) {
                            throw (Error)suppressed;
                        }
                    }
                }
                catch (Throwable ex) {
                    block69: {
                        if (ex instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        originalException = ex;
                        this.clearProperties();
                        suppressed = originalException;
                        {
                            catch (Throwable throwable) {
                                Throwable suppressed2;
                                block70: {
                                    this.clearProperties();
                                    suppressed2 = originalException;
                                    try {
                                        if (this.doneMarker == null) break block70;
                                        this.doneMarker.createNewFile();
                                        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.doneMarker));){
                                            writer.write(success ? "success" : "failed");
                                            writer.write(10);
                                        }
                                    }
                                    catch (IOException ex2) {
                                        if (originalException != null) {
                                            originalException.addSuppressed(ex2);
                                            suppressed2 = originalException;
                                            break block70;
                                        }
                                        suppressed2 = new UncheckedIOException(ex2);
                                    }
                                }
                                if (suppressed2 != null) {
                                    if (suppressed2 instanceof RuntimeException) {
                                        throw (RuntimeException)suppressed2;
                                    }
                                    if (suppressed2 instanceof Error) {
                                        throw (Error)suppressed2;
                                    }
                                }
                                throw throwable;
                            }
                        }
                        try {
                            if (this.doneMarker == null) break block69;
                            this.doneMarker.createNewFile();
                            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.doneMarker));){
                                writer.write(success ? "success" : "failed");
                                writer.write(10);
                            }
                        }
                        catch (IOException ex3) {
                            if (originalException != null) {
                                originalException.addSuppressed(ex3);
                                suppressed = originalException;
                                break block69;
                            }
                            suppressed = new UncheckedIOException(ex3);
                        }
                    }
                    if (suppressed != null) {
                        if (suppressed instanceof RuntimeException) {
                            throw (RuntimeException)suppressed;
                        }
                        if (suppressed instanceof Error) {
                            throw (Error)suppressed;
                        }
                    }
                }
            }
        }

        private void executeRestart(ModelControllerClient client) {
            if (this.controllerService.processType == ProcessType.STANDALONE_SERVER) {
                this.executeRestartNormalServer(client);
            } else {
                this.recordRestartEmbeddedServer();
            }
        }

        private void executeRestartNormalServer(ModelControllerClient client) {
            try {
                ModelNode shutdown = Util.createOperation("shutdown", PathAddress.EMPTY_ADDRESS);
                shutdown.get("restart").set(true);
                Files.createFile(this.restartInitiated.toPath(), new FileAttribute[0]);
                ControllerLogger.ROOT_LOGGER.restartingServerAfterBootCliScript(this.restartInitiated, "org.wildfly.internal.cli.boot.hook.script", "org.wildfly.internal.cli.boot.hook.reload.skip", "org.wildfly.internal.cli.boot.hook.marker.dir");
                ModelNode result = client.execute(shutdown);
                if (result.get("outcome").asString().equals("failed")) {
                    throw new RuntimeException(result.get("failure-description").asString());
                }
            }
            catch (IOException e) {
                try {
                    this.deleteFile(this.restartInitiated);
                }
                catch (IOException ex) {
                    e = ex;
                }
                throw new RuntimeException(e);
            }
        }

        private void recordRestartEmbeddedServer() {
            try {
                Files.createFile(this.embeddedServerNeedsRestart.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void executeReload(ModelControllerClient client, boolean afterRestart) {
            try {
                ModelNode reload = Util.createOperation("reload", PathAddress.EMPTY_ADDRESS);
                this.clearProperties();
                if (!afterRestart) {
                    ControllerLogger.ROOT_LOGGER.reloadingServerToNormalModeAfterAdditionalBootCliScript("org.wildfly.internal.cli.boot.hook.script", "org.wildfly.internal.cli.boot.hook.reload.skip", "org.wildfly.internal.cli.boot.hook.marker.dir");
                } else {
                    ControllerLogger.ROOT_LOGGER.reloadingServerToNormalModeAfterRestartAfterAdditionalBootCliScript("org.wildfly.internal.cli.boot.hook.script", "org.wildfly.internal.cli.boot.hook.reload.skip", "org.wildfly.internal.cli.boot.hook.marker.dir");
                }
                ModelNode result = client.execute(reload);
                if (result.get("outcome").asString().equals("failed")) {
                    throw new RuntimeException(result.get("failure-description").asString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.clearProperties();
            }
        }

        private void clearProperties() {
            WildFlySecurityManager.clearPropertyPrivileged((String)"org.wildfly.internal.cli.boot.hook.script");
            WildFlySecurityManager.clearPropertyPrivileged((String)"org.wildfly.internal.cli.boot.hook.reload.skip");
            WildFlySecurityManager.clearPropertyPrivileged((String)"org.wildfly.internal.cli.boot.hook.marker.dir");
        }

        private void deleteFile(File file) throws IOException {
            Path path;
            if (file != null && Files.exists(path = file.toPath(), new LinkOption[0])) {
                Files.delete(path);
            }
        }

        private static class InvokerLoader
        implements Closeable {
            private final AdditionalBootCliScriptInvoker invoker;
            private TemporaryModuleLayer tempModuleLayer;

            private InvokerLoader() {
                String testInvoker = WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.test.override.cli.boot.invoker", null);
                if (testInvoker != null) {
                    try {
                        this.invoker = (AdditionalBootCliScriptInvoker)Class.forName(testInvoker).newInstance();
                        return;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                this.tempModuleLayer = TemporaryModuleLayer.create(new PathFilter(){

                    public boolean accept(String path) {
                        return path.startsWith("org/jboss/as/cli/main") || path.startsWith("org/aesh/main");
                    }
                });
                try {
                    Module module = this.tempModuleLayer.getModuleLoader().loadModule("org.jboss.as.cli");
                    ServiceLoader sl = module.loadService(AdditionalBootCliScriptInvoker.class);
                    AdditionalBootCliScriptInvoker invoker = null;
                    for (AdditionalBootCliScriptInvoker currentInvoker : sl) {
                        if (invoker != null) {
                            throw ControllerLogger.ROOT_LOGGER.moreThanOneInstanceOfAdditionalBootCliScriptInvokerFound(invoker.getClass().getName(), currentInvoker.getClass().getName());
                        }
                        invoker = currentInvoker;
                    }
                    this.invoker = invoker;
                }
                catch (ModuleLoadException e) {
                    throw new RuntimeException(e);
                }
            }

            private AdditionalBootCliScriptInvoker getInvoker() {
                return this.invoker;
            }

            @Override
            public void close() throws IOException {
                if (this.tempModuleLayer != null) {
                    this.tempModuleLayer.close();
                }
            }
        }
    }

    private static final class SimpleService<V>
    implements Service {
        private final Consumer<V> injector;
        private final V value;

        private SimpleService(Consumer<V> injector, V value) {
            this.injector = injector;
            this.value = value;
        }

        public void start(StartContext context) {
            this.injector.accept(this.value);
        }

        public void stop(StopContext context) {
            this.injector.accept(null);
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static interface ControllerInstabilityListener {
        public void controllerUnstable();
    }

    protected static interface PartialModelIndicator {
        public static final PartialModelIndicator DEFAULT = new PartialModelIndicator(){};

        default public boolean isModelPartial() {
            return false;
        }
    }

    protected static abstract class ModelControllerServiceInitializationParams {
        private final ServiceLoader<ModelControllerServiceInitialization> serviceLoader;

        public ModelControllerServiceInitializationParams(ServiceLoader<ModelControllerServiceInitialization> serviceLoader) {
            this.serviceLoader = serviceLoader;
        }

        protected abstract String getHostName();
    }

    private final class ModelControllerServiceInitializationBootStepHandler
    implements OperationStepHandler {
        private final ModelControllerServiceInitializationParams initParams;

        ModelControllerServiceInitializationBootStepHandler(ModelControllerServiceInitializationParams initParams) {
            this.initParams = initParams;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    assert (context instanceof OperationContextImpl);
                    ModelControllerImpl.ManagementModelImpl managementModel = ((OperationContextImpl)context).getManagementModel();
                    ServiceLoader<ModelControllerServiceInitialization> sl = ModelControllerServiceInitializationBootStepHandler.this.initParams.serviceLoader;
                    String hostName = ModelControllerServiceInitializationBootStepHandler.this.initParams.getHostName();
                    assert (!AbstractControllerService.this.processType.isHostController() || hostName != null);
                    for (ModelControllerServiceInitialization init : sl) {
                        if (AbstractControllerService.this.processType.isHostController()) {
                            init.initializeHost(context.getServiceTarget(), managementModel, hostName, AbstractControllerService.this.processType);
                            init.initializeDomain(context.getServiceTarget(), managementModel);
                            continue;
                        }
                        init.initializeStandalone(context.getServiceTarget(), managementModel, AbstractControllerService.this.processType);
                    }
                    managementModel.getRootResourceRegistration().unregisterOperationHandler(INIT_CONTROLLER_OP.getName());
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

