/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.controller.CapabilityProvider;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.FunctionExecutorRegistry;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.ResourceDefinitionProvider;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.ServiceValueExecutorRegistry;
import org.jboss.as.clustering.controller.ServiceValueRegistry;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.controller.UnaryRequirementCapability;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidatorBuilder;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetric;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheRuntimeResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.NoTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScatteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.infinispan.marshall.InfinispanMarshallerFactory;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.service.InfinispanRequirement;
import org.wildfly.clustering.server.service.ClusteringDefaultCacheRequirement;
import org.wildfly.clustering.service.BinaryRequirement;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.clustering.singleton.SingletonDefaultCacheRequirement;

public class CacheContainerResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration> {
    static final PathElement WILDCARD_PATH = CacheContainerResourceDefinition.pathElement("*");
    static final Map<InfinispanCacheRequirement, org.jboss.as.clustering.controller.Capability> DEFAULT_CAPABILITIES = new EnumMap<InfinispanCacheRequirement, org.jboss.as.clustering.controller.Capability>(InfinispanCacheRequirement.class);
    static final Set<PathElement> REQUIRED_CHILDREN;
    static final Set<PathElement> REQUIRED_SINGLETON_CHILDREN;

    static PathElement pathElement(String containerName) {
        return PathElement.pathElement((String)"cache-container", (String)containerName);
    }

    CacheContainerResourceDefinition() {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(WILDCARD_PATH));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addAttributes(ListAttribute.class).addCapabilities(Capability.class).addCapabilities(model -> model.hasDefined(Attribute.DEFAULT_CACHE.getName()), DEFAULT_CAPABILITIES.values()).addCapabilities(model -> model.hasDefined(Attribute.DEFAULT_CACHE.getName()), (Iterable)EnumSet.allOf(ClusteringDefaultCacheRequirement.class).stream().map(UnaryRequirementCapability::new).collect(Collectors.toList())).addCapabilities(model -> model.hasDefined(Attribute.DEFAULT_CACHE.getName()), (Iterable)EnumSet.allOf(SingletonDefaultCacheRequirement.class).stream().map(UnaryRequirementCapability::new).collect(Collectors.toList())).addRequiredChildren(REQUIRED_CHILDREN).addRequiredSingletonChildren(REQUIRED_SINGLETON_CHILDREN).setResourceTransformation(CacheContainerResource::new);
        ServiceValueExecutorRegistry managerExecutors = new ServiceValueExecutorRegistry();
        ServiceValueExecutorRegistry cacheExecutors = new ServiceValueExecutorRegistry();
        CacheContainerServiceHandler handler = new CacheContainerServiceHandler((ServiceValueRegistry<EmbeddedCacheManager>)managerExecutors, (ServiceValueRegistry<Cache<?, ?>>)cacheExecutors);
        new SimpleResourceRegistrar(descriptor, (ResourceServiceHandler)handler).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        if (registration.isRuntimeOnlyRegistrationValid()) {
            new MetricHandler((MetricExecutor)new CacheContainerMetricExecutor((FunctionExecutorRegistry<EmbeddedCacheManager>)managerExecutors), CacheContainerMetric.class).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
            new CacheRuntimeResourceDefinition((FunctionExecutorRegistry<Cache<?, ?>>)cacheExecutors).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        new JGroupsTransportResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new NoTransportResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        for (ThreadPoolResourceDefinition threadPoolResourceDefinition : EnumSet.complementOf(EnumSet.of(ThreadPoolResourceDefinition.CLIENT))) {
            threadPoolResourceDefinition.register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        for (ScheduledThreadPoolResourceDefinition scheduledThreadPoolResourceDefinition : EnumSet.allOf(ScheduledThreadPoolResourceDefinition.class)) {
            scheduledThreadPoolResourceDefinition.register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        new LocalCacheResourceDefinition((FunctionExecutorRegistry<Cache<?, ?>>)cacheExecutors).register(registration);
        new InvalidationCacheResourceDefinition((FunctionExecutorRegistry<Cache<?, ?>>)cacheExecutors).register(registration);
        new ReplicatedCacheResourceDefinition((FunctionExecutorRegistry<Cache<?, ?>>)cacheExecutors).register(registration);
        new DistributedCacheResourceDefinition((FunctionExecutorRegistry<Cache<?, ?>>)cacheExecutors).register(registration);
        new ScatteredCacheResourceDefinition((FunctionExecutorRegistry<Cache<?, ?>>)cacheExecutors).register(registration);
        return registration;
    }

    static {
        for (InfinispanCacheRequirement requirement : EnumSet.allOf(InfinispanCacheRequirement.class)) {
            DEFAULT_CAPABILITIES.put(requirement, (org.jboss.as.clustering.controller.Capability)new UnaryRequirementCapability(requirement.getDefaultRequirement()));
        }
        REQUIRED_CHILDREN = Stream.concat(EnumSet.complementOf(EnumSet.of(ThreadPoolResourceDefinition.CLIENT)).stream(), EnumSet.allOf(ScheduledThreadPoolResourceDefinition.class).stream()).map(rec$ -> ((ResourceDefinitionProvider)rec$).getPathElement()).collect(Collectors.toSet());
        REQUIRED_SINGLETON_CHILDREN = Set.of(NoTransportResourceDefinition.PATH);
    }

    static enum ListAttribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<StringListAttributeDefinition.Builder>
    {
        ALIASES("aliases"),
        MODULES("modules"){

            @Override
            public StringListAttributeDefinition.Builder apply(StringListAttributeDefinition.Builder builder) {
                return (StringListAttributeDefinition.Builder)builder.setElementValidator(new ModuleIdentifierValidatorBuilder().configure((AbstractAttributeDefinitionBuilder)builder).build());
            }
        };

        private final AttributeDefinition definition;

        private ListAttribute(String name) {
            this.definition = this.apply((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(name).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public StringListAttributeDefinition.Builder apply(StringListAttributeDefinition.Builder builder) {
            return builder;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        DEFAULT_CACHE("default-cache", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(false)).setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference(DEFAULT_CAPABILITIES.get(InfinispanCacheRequirement.CONFIGURATION), (BinaryRequirement)InfinispanCacheRequirement.CONFIGURATION, WILDCARD_PATH));
            }
        }
        ,
        STATISTICS_ENABLED("statistics-enabled", ModelType.BOOLEAN){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setDefaultValue(ModelNode.FALSE);
            }
        }
        ,
        MARSHALLER("marshaller", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode(InfinispanMarshallerFactory.LEGACY.name()))).setValidator(new ParameterValidator(){
                    private final ParameterValidator validator = EnumValidator.create(InfinispanMarshallerFactory.class);

                    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                        this.validator.validateParameter(parameterName, value);
                        if (!value.isDefined() || value.equals(MARSHALLER.getDefinition().getDefaultValue())) {
                            InfinispanLogger.ROOT_LOGGER.marshallerEnumValueDeprecated(parameterName, InfinispanMarshallerFactory.LEGACY, EnumSet.complementOf(EnumSet.of(InfinispanMarshallerFactory.LEGACY)));
                        }
                    }
                });
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    static enum Capability implements CapabilityProvider
    {
        CONTAINER((UnaryRequirement)InfinispanRequirement.CONTAINER),
        CONFIGURATION((UnaryRequirement)InfinispanRequirement.CONFIGURATION),
        KEY_AFFINITY_FACTORY((UnaryRequirement)InfinispanRequirement.KEY_AFFINITY_FACTORY);

        private final org.jboss.as.clustering.controller.Capability capability;

        private Capability(UnaryRequirement requirement) {
            this.capability = new UnaryRequirementCapability(requirement);
        }

        public org.jboss.as.clustering.controller.Capability getCapability() {
            return this.capability;
        }
    }
}

