/*
 * Copyright The WildFly Authors
 * SPDX-License-Identifier: Apache-2.0
 */
package org.jboss.as.test.integration.ejb.interceptor.method;

import jakarta.ejb.Stateless;
import jakarta.interceptor.Interceptors;

/**
 * @author Stuart Douglas
 */
@Stateless
@Interceptors(SecretInterceptor.class)
public class ClassifiedBean {

    public String secretMethod() {
        return "Secret";
    }

    @Interceptors(TopSecretInterceptor.class)
    public String topSecretMethod() {
        return "TopSecret";
    }

    public String overloadedMethod(Integer i) {
        return "ArgInt:" + i.toString();
    }

    public String overloadedMethod(String str) {
        return "ArgStr:" + str;
    }
}
