/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.JsonElement;
import org.hibernate.search.util.common.AssertionFailure;

public abstract class JsonElementType<T> {
    JsonElementType() {
    }

    public final T fromElement(JsonElement element) {
        if (element == null) {
            return null;
        }
        if (this.isInstance(element)) {
            return this.nullUnsafeFromElement(element);
        }
        throw new AssertionFailure(element + " cannot be cast to " + this);
    }

    protected abstract T nullUnsafeFromElement(JsonElement var1);

    public final JsonElement toElement(T value) {
        if (value == null) {
            return null;
        }
        return this.nullUnsafeToElement(value);
    }

    protected abstract JsonElement nullUnsafeToElement(T var1);

    public final boolean isInstance(JsonElement element) {
        return element != null && this.nullUnsafeIsInstance(element);
    }

    protected abstract boolean nullUnsafeIsInstance(JsonElement var1);
}

