/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.time.Duration;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Supplier;
import org.wildfly.clustering.web.cache.Contextual;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSessionFactory;
import org.wildfly.clustering.web.cache.session.CompositeSession;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.cache.session.attributes.SessionAttributes;
import org.wildfly.clustering.web.cache.session.attributes.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.SessionMetaDataFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;

public class CompositeSessionFactory<C, MV extends Contextual<L>, AV, L>
extends CompositeImmutableSessionFactory<MV, AV>
implements SessionFactory<C, MV, AV, L> {
    private final SessionMetaDataFactory<MV> metaDataFactory;
    private final SessionAttributesFactory<C, AV> attributesFactory;
    private final Supplier<L> localContextFactory;

    public CompositeSessionFactory(SessionMetaDataFactory<MV> metaDataFactory, SessionAttributesFactory<C, AV> attributesFactory, Supplier<L> localContextFactory) {
        super(metaDataFactory, attributesFactory);
        this.metaDataFactory = metaDataFactory;
        this.attributesFactory = attributesFactory;
        this.localContextFactory = localContextFactory;
    }

    public Map.Entry<MV, AV> createValue(String id, Duration defaultTimeout) {
        Contextual metaDataValue = (Contextual)this.metaDataFactory.createValue(id, defaultTimeout);
        if (metaDataValue == null) {
            return null;
        }
        Object attributesValue = this.attributesFactory.createValue(id, null);
        return new AbstractMap.SimpleImmutableEntry<Contextual, Object>(metaDataValue, attributesValue);
    }

    @Override
    public Map.Entry<MV, AV> findValue(String id) {
        Contextual metaDataValue = (Contextual)this.metaDataFactory.findValue(id);
        if (metaDataValue != null) {
            Object attributesValue = this.attributesFactory.findValue(id);
            if (attributesValue != null) {
                return Map.entry(metaDataValue, attributesValue);
            }
            this.metaDataFactory.purge(id);
        }
        return null;
    }

    @Override
    public Map.Entry<MV, AV> tryValue(String id) {
        Object attributesValue;
        Contextual metaDataValue = (Contextual)this.metaDataFactory.tryValue(id);
        if (metaDataValue != null && (attributesValue = this.attributesFactory.tryValue(id)) != null) {
            return Map.entry(metaDataValue, attributesValue);
        }
        return null;
    }

    public boolean remove(String id) {
        this.attributesFactory.remove(id);
        return this.metaDataFactory.remove(id);
    }

    public boolean purge(String id) {
        this.attributesFactory.purge(id);
        return this.metaDataFactory.purge(id);
    }

    @Override
    public SessionMetaDataFactory<MV> getMetaDataFactory() {
        return this.metaDataFactory;
    }

    @Override
    public SessionAttributesFactory<C, AV> getAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public Session<L> createSession(String id, Map.Entry<MV, AV> entry, C context) {
        Contextual metaDataValue = (Contextual)entry.getKey();
        AV attributeValue = entry.getValue();
        InvalidatableSessionMetaData metaData = this.metaDataFactory.createSessionMetaData(id, metaDataValue);
        SessionAttributes attributes = this.attributesFactory.createSessionAttributes(id, attributeValue, (ImmutableSessionMetaData)metaData, context);
        return new CompositeSession<L>(id, metaData, attributes, metaDataValue, this.localContextFactory, this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, ImmutableSessionMetaData metaData, ImmutableSessionAttributes attributes) {
        return new CompositeImmutableSession(id, metaData, attributes);
    }

    @Override
    public void close() {
        this.metaDataFactory.close();
        this.attributesFactory.close();
    }
}

