/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.JMXStatisticsConfigurationBuilder;
import org.infinispan.configuration.cache.StatisticsConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class StatisticsConfigurationBuilder
extends JMXStatisticsConfigurationBuilder
implements Builder<StatisticsConfiguration> {
    private final AttributeSet attributes = StatisticsConfiguration.attributeDefinitionSet();

    StatisticsConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public StatisticsConfigurationBuilder enable() {
        this.attributes.attribute(StatisticsConfiguration.ENABLED).set((Object)true);
        return this;
    }

    @Override
    public StatisticsConfigurationBuilder disable() {
        this.attributes.attribute(StatisticsConfiguration.ENABLED).set((Object)false);
        return this;
    }

    @Override
    public StatisticsConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(StatisticsConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    @Override
    @Deprecated(forRemoval=true)
    public StatisticsConfigurationBuilder available(boolean available) {
        this.attributes.attribute(StatisticsConfiguration.AVAILABLE).set((Object)available);
        return this;
    }

    public void validate() {
        Attribute enabled = this.attributes.attribute(StatisticsConfiguration.ENABLED);
        Attribute available = this.attributes.attribute(StatisticsConfiguration.AVAILABLE);
        if (enabled.isModified() && available.isModified() && ((Boolean)enabled.get()).booleanValue() && !((Boolean)available.get()).booleanValue()) {
            throw Log.CONFIG.statisticsEnabledNotAvailable();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public StatisticsConfiguration create() {
        return new StatisticsConfiguration(this.attributes.protect());
    }

    public StatisticsConfigurationBuilder read(StatisticsConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "StatisticsConfigurationBuilder [attributes=" + String.valueOf(this.attributes) + "]";
    }
}

