/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.offset;

import java.time.Duration;
import java.time.Instant;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public interface Offset<V>
extends UnaryOperator<V> {
    public boolean isZero();

    public static Offset<Duration> forDuration(Duration offset) {
        return offset.isZero() ? DurationOffset.ZERO : new DurationOffset(offset);
    }

    public static Offset<Instant> forInstant(Duration offset) {
        return offset.isZero() ? InstantOffset.ZERO : new InstantOffset(offset);
    }

    public static class InstantOffset
    extends TemporalOffset<Instant> {
        static final Offset<Instant> ZERO = new InstantOffset(Duration.ZERO);
        private static final BiFunction<Instant, Duration, Instant> INSTANT_APPLICATOR = Instant::plus;

        InstantOffset(Duration value) {
            super(value, INSTANT_APPLICATOR);
        }
    }

    public static class DurationOffset
    extends TemporalOffset<Duration> {
        static final Offset<Duration> ZERO = new DurationOffset(Duration.ZERO);
        private static final BiFunction<Duration, Duration, Duration> DURATION_APPLICATOR = Duration::plus;

        DurationOffset(Duration value) {
            super(value, DURATION_APPLICATOR);
        }
    }

    public static class TemporalOffset<V>
    extends DefaultOffset<Duration, V> {
        private static final Predicate<Duration> IS_ZERO = Duration::isZero;

        TemporalOffset(Duration offset, BiFunction<V, Duration, V> applicator) {
            super(offset, IS_ZERO, applicator);
        }
    }

    public static class DefaultOffset<O, V>
    implements Offset<V>,
    Supplier<O> {
        private final O value;
        private final Predicate<O> isZero;
        private final BiFunction<V, O, V> applicator;

        DefaultOffset(O value, Predicate<O> isZero, BiFunction<V, O, V> applicator) {
            this.value = value;
            this.isZero = isZero;
            this.applicator = applicator;
        }

        @Override
        public V apply(V value) {
            return this.isZero() ? value : this.applicator.apply(value, this.value);
        }

        @Override
        public boolean isZero() {
            return this.isZero.test(this.value);
        }

        @Override
        public O get() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Offset)) {
                return false;
            }
            DefaultOffset offset = (DefaultOffset)object;
            return this.value.equals(offset.value);
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

