/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.runtime;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoader;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wildfly.common.os.Process;
import org.wildfly.common.xml.DocumentBuilderFactoryUtil;
import org.wildfly.common.xml.TransformerFactoryUtil;
import org.wildfly.core.jar.runtime.Arguments;
import org.wildfly.core.jar.runtime.BootableEnvironment;
import org.wildfly.core.jar.runtime.CmdUsage;
import org.wildfly.core.jar.runtime.InstallationCleaner;
import org.wildfly.core.jar.runtime.Server;
import org.wildfly.core.jar.runtime._private.BootableJarLogger;

public final class BootableJar
implements Server.ShutdownHandler {
    private static final String DEP_1 = "ff";
    private static final String DEP_2 = "00";
    private BootableJarLogger log;
    private final BootableEnvironment environment;
    private final List<String> startServerArgs = new ArrayList<String>();
    private Server server;
    private final Arguments arguments;
    private final ModuleLoader loader;
    private final Path pidFile;

    private BootableJar(BootableEnvironment environment, Arguments arguments, ModuleLoader loader, long unzipTime) throws Exception {
        this.environment = environment;
        this.arguments = arguments;
        this.loader = loader;
        this.startServerArgs.addAll(arguments.getServerArguments());
        this.startServerArgs.add("--read-only-server-config=standalone.xml");
        this.configureLogger();
        long t = System.currentTimeMillis();
        if (arguments.getDeployment() != null) {
            this.setupDeployment(arguments.getDeployment());
        }
        this.log.advertiseInstall(environment.getJBossHome(), unzipTime + (System.currentTimeMillis() - t));
        this.pidFile = environment.getPidFile();
    }

    @Override
    public void shutdown(int status) {
        if (status == 10) {
            this.log.cantRestartServer();
        }
        System.exit(status);
    }

    private void setupDeployment(Path deployment) throws Exception {
        Path deploymentDir = this.environment.resolveContentDir(DEP_1, DEP_2);
        Path target = deploymentDir.resolve("content");
        Files.createDirectories(deploymentDir, new FileAttribute[0]);
        boolean isExploded = Files.isDirectory(deployment, new LinkOption[0]);
        BootableJar.updateConfig(this.environment.resolveConfigurationDir("standalone.xml"), deployment.getFileName().toString(), isExploded);
        if (isExploded) {
            this.copyDirectory(deployment, target);
        } else {
            Files.copy(deployment, target, new CopyOption[0]);
        }
        this.log.installDeployment(deployment);
    }

    private static void updateConfig(Path configFile, String name, boolean isExploded) throws Exception {
        try (FileInputStream fileInputStream = new FileInputStream(configFile.toFile());){
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactoryUtil.create();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(fileInputStream);
            Element root = document.getDocumentElement();
            NodeList lst = root.getChildNodes();
            for (int i = 0; i < lst.getLength(); ++i) {
                Node n = lst.item(i);
                if (!(n instanceof Element) || !"deployments".equals(n.getNodeName())) continue;
                throw BootableJarLogger.ROOT_LOGGER.deploymentAlreadyExist();
            }
            Element deployments = document.createElement("deployments");
            Element deployment = document.createElement("deployment");
            Element content = document.createElement("content");
            content.setAttribute("sha1", "ff00");
            if (isExploded) {
                content.setAttribute("archive", "false");
            }
            deployment.appendChild(content);
            deployment.setAttribute("name", name);
            deployment.setAttribute("runtime-name", name);
            deployments.appendChild(deployment);
            root.appendChild(deployments);
            Transformer transformer = TransformerFactoryUtil.create().newTransformer();
            StreamResult output = new StreamResult(configFile.toFile());
            DOMSource input = new DOMSource(document);
            transformer.transform(input, output);
        }
    }

    private void copyDirectory(Path src, Path target) throws IOException {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(file -> {
                try {
                    Path targetFile = target.resolve(src.relativize((Path)file));
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        if (!Files.exists(targetFile, new LinkOption[0])) {
                            Files.createDirectory(targetFile, new FileAttribute[0]);
                        }
                    } else {
                        Files.copy(file, targetFile, new CopyOption[0]);
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
    }

    private void configureLogger() throws IOException {
        this.environment.setSystemProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        this.configureLogging();
        this.log = BootableJarLogger.ROOT_LOGGER;
    }

    private void configureLogging() throws IOException {
        if (!this.arguments.isVersion().booleanValue()) {
            this.loadBootConfigProperties();
            LogContext ctx = this.configureLogContext();
            LogContext.setLogContextSelector(() -> ctx);
            try {
                Class.forName(ConsoleHandler.class.getName(), true, ConsoleHandler.class.getClassLoader());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            StdioContext.install();
            StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (Level)org.jboss.logmanager.Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (Level)org.jboss.logmanager.Level.ERROR));
            StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        }
    }

    private LogContext configureLogContext() throws IOException {
        LogContext logContext = LogContext.create();
        Path bootLog = this.environment.resolveLogDir("server.log");
        Path loggingProperties = this.environment.resolveConfigurationDir("logging.properties");
        if (Files.exists(loggingProperties, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(loggingProperties, new OpenOption[0]);){
                this.environment.setSystemProperty("org.jboss.boot.log.file", bootLog.toAbsolutePath().toString());
                PropertyConfigurator configurator = new PropertyConfigurator(logContext);
                configurator.configure(in);
                logContext.getLogger("").attach(Configurator.ATTACHMENT_KEY, (Object)configurator);
            }
        }
        return logContext;
    }

    public void run() throws Exception {
        Path script = this.arguments.getCLIScript();
        if (script != null) {
            long id = System.currentTimeMillis();
            Path markerDir = this.environment.getTmpDir().resolve(id + "-cli-boot-hook-dir");
            Path outputFile = this.environment.getTmpDir().resolve(id + "-cli-boot-hook-output-file.txt");
            Files.createDirectories(markerDir, new FileAttribute[0]);
            this.startServerArgs.add("--start-mode=admin-only");
            this.startServerArgs.add("-Dorg.wildfly.internal.cli.boot.hook.script=" + script.toAbsolutePath().toString());
            this.startServerArgs.add("-Dorg.wildfly.internal.cli.boot.hook.marker.dir=" + markerDir.toAbsolutePath().toString());
            this.startServerArgs.add("-Dorg.wildfly.internal.cli.boot.hook.script.output.file=" + outputFile.toAbsolutePath().toString());
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        this.server = this.buildServer(this.startServerArgs);
        if (!Files.notExists(this.pidFile, new LinkOption[0])) {
            throw this.log.pidFileAlreadyExists(this.pidFile, this.environment.getJBossHome());
        }
        Files.write(this.pidFile, Collections.singleton(Long.toString(Process.getProcessId())), StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
        this.server.start();
    }

    private Server buildServer(List<String> args) throws IOException {
        String[] array = new String[args.size()];
        this.log.advertiseOptions(args);
        return Server.newSever(args.toArray(array), this.loader, this);
    }

    private void loadBootConfigProperties() throws IOException {
        Path configFile = this.environment.resolveConfigurationDir("boot-config.properties");
        if (Files.exists(configFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configFile, StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.load(reader);
                for (String key : properties.stringPropertyNames()) {
                    this.environment.setSystemProperty(key, properties.getProperty(key));
                }
            }
        }
    }

    public static void run(Path jbossHome, List<String> args, ModuleLoader moduleLoader, ModuleClassLoader moduleClassLoader, Long unzipTime) throws Exception {
        Arguments arguments;
        BootableJar.setTccl((ClassLoader)moduleClassLoader);
        BootableEnvironment environment = BootableEnvironment.of(jbossHome);
        try {
            arguments = Arguments.parseArguments(args, environment);
        }
        catch (Throwable ex) {
            System.err.println(ex);
            CmdUsage.printUsage(System.out);
            return;
        }
        if (arguments.isHelp().booleanValue()) {
            CmdUsage.printUsage(System.out);
            return;
        }
        BootableJar bootableJar = new BootableJar(environment, arguments, moduleLoader, unzipTime);
        BootableJar.configureJMX(moduleClassLoader, bootableJar.log);
        ServiceLoader<Provider> providerServiceLoader = ServiceLoader.load(Provider.class, (ClassLoader)moduleClassLoader);
        SecurityManager sm = System.getSecurityManager();
        Iterator<Provider> iterator = providerServiceLoader.iterator();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    Provider provider = iterator.next();
                    if (sm == null) {
                        new AddProviderAction(provider).run();
                        continue;
                    }
                    Class<?> providerClass = provider.getClass();
                    AccessController.doPrivileged(new AddProviderAction(provider), BootableJar.getProviderContext(providerClass));
                }
            }
            catch (RuntimeException | ServiceConfigurationError e) {
                bootableJar.log.securityProviderFailed(e);
                continue;
            }
            break;
        }
        bootableJar.run();
    }

    private static void configureJMX(ModuleClassLoader moduleClassLoader, BootableJarLogger log) throws Exception {
        String mbeanServerBuilderName = BootableJar.getServiceName((ClassLoader)moduleClassLoader, "javax.management.MBeanServerBuilder");
        if (mbeanServerBuilderName != null) {
            System.setProperty("javax.management.builder.initial", mbeanServerBuilderName);
            ManagementFactory.getPlatformMBeanServer();
        }
        ModuleLoader.installMBeanServer();
    }

    private static String getServiceName(ClassLoader classLoader, String className) throws IOException {
        try (InputStream stream = classLoader.getResourceAsStream("META-INF/services/" + className);){
            String line;
            if (stream == null) {
                String string = null;
                return string;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                int i = line.indexOf(35);
                if (i != -1) {
                    line = line.substring(0, i);
                }
                if ((line = line.trim()).length() == 0) continue;
                String string = line;
                return string;
            }
            String string = null;
            return string;
        }
    }

    static void setTccl(ClassLoader cl) {
        Thread.currentThread().setContextClassLoader(cl);
    }

    private static AccessControlContext getProviderContext(Class<? extends Provider> providerClass) {
        return new AccessControlContext(new ProtectionDomain[]{providerClass.getProtectionDomain()});
    }

    static final class AddProviderAction
    implements PrivilegedAction<Void> {
        private final Provider provider;

        AddProviderAction(Provider provider) {
            this.provider = provider;
        }

        @Override
        public Void run() {
            Security.addProvider(this.provider);
            return null;
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            BootableJar.this.log.shuttingDown();
            ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
                Thread thread = new Thread(r);
                thread.setName("installation-cleaner");
                return thread;
            });
            InstallationCleaner cleaner = new InstallationCleaner(BootableJar.this.environment, BootableJar.this.log);
            executor.submit(cleaner);
            if (Files.exists(BootableJar.this.pidFile, new LinkOption[0])) {
                this.waitForShutdown();
            }
            executor.shutdown();
            try {
                if (!executor.awaitTermination(BootableJar.this.environment.getTimeout(), TimeUnit.SECONDS)) {
                    cleaner.cleanup();
                }
            }
            catch (IOException | InterruptedException e) {
                BootableJar.this.log.failedToStartCleanupProcess(e, BootableJar.this.environment.getJBossHome());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitForShutdown() {
            try {
                ModelNode mn = new ModelNode();
                mn.get("address");
                mn.get("operation").set("read-attribute");
                mn.get("name").set("server-state");
                int i = 0;
                while (i < 10) {
                    try {
                        ModelControllerClient client = BootableJar.this.server.getModelControllerClient();
                        if (client == null) {
                            BootableJar.this.log.nullController();
                            return;
                        }
                        ModelNode ret = client.execute(mn);
                        if (ret.hasDefined("result")) {
                            String val = ret.get("result").asString();
                            if ("stopped".equals(val)) {
                                BootableJar.this.log.serverStopped();
                                return;
                            }
                            BootableJar.this.log.serverNotStopped();
                        }
                        Thread.sleep(1000L);
                    }
                    catch (Exception ex) {
                        throw BootableJar.this.log.unexpectedExceptionWhileShuttingDown(ex);
                    }
                    ++i;
                }
                return;
            }
            finally {
                try {
                    Files.deleteIfExists(BootableJar.this.pidFile);
                    BootableJar.this.log.debugf("Deleted PID file %s", BootableJar.this.pidFile);
                }
                catch (IOException e) {
                    BootableJar.this.log.cantDelete(BootableJar.this.pidFile.toString(), e);
                }
            }
        }
    }
}

