/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.cdi.async;

import com.arjuna.ats.jta.cdi.RunnableWithException;
import com.arjuna.ats.jta.cdi.TransactionHandler;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import io.smallrye.reactive.converters.Registry;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.Transactional;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.jboss.logging.Logger;
import org.reactivestreams.Publisher;

public final class ContextPropagationAsyncHandler {
    private static final Logger log = Logger.getLogger(ContextPropagationAsyncHandler.class);
    private static final boolean areSmallRyeReactiveClassesAvailable = ContextPropagationAsyncHandler.areSmallRyeReactiveClassesAvailable();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean tryHandleAsynchronously(TransactionManager tm, Transaction tx2, Transactional transactional, AtomicReference objectToHandleRef, Class<?> returnType, RunnableWithException afterEndTransaction) throws Exception {
        void var6_16;
        Object v = objectToHandleRef.get();
        if (v == null) {
            return false;
        }
        if (v instanceof CompletionStage) {
            Object object = ContextPropagationAsyncHandler.handleAsync(tm, tx2, transactional, v, afterEndTransaction);
        } else {
            void var6_10;
            Optional lookup;
            if (v instanceof CompletionStage || !areSmallRyeReactiveClassesAvailable) return false;
            ReactiveTypeConverter converter = null;
            if ((!(v instanceof Publisher) || returnType != Publisher.class) && (lookup = Registry.lookup(v.getClass())).isPresent()) {
                converter = (ReactiveTypeConverter)lookup.get();
                if (converter.emitAtMostOneItem()) {
                    CompletionStage completionStage = converter.toCompletionStage(v);
                } else {
                    Publisher publisher = converter.toRSPublisher(v);
                }
            }
            if (var6_10 instanceof CompletionStage) {
                Object object = ContextPropagationAsyncHandler.handleAsync(tm, tx2, transactional, var6_10, afterEndTransaction);
                if (converter != null) {
                    Object object2 = converter.fromCompletionStage((CompletionStage)object);
                }
            } else {
                if (!(var6_10 instanceof Publisher)) return false;
                Object object = ContextPropagationAsyncHandler.handleAsync(tm, tx2, transactional, var6_10, afterEndTransaction);
                if (converter != null) {
                    Object object3 = converter.fromPublisher((Publisher)object);
                }
            }
        }
        objectToHandleRef.set(var6_16);
        return true;
    }

    private static Object handleAsync(TransactionManager tm, Transaction tx2, Transactional transactional, Object ret, RunnableWithException afterEndTransaction) throws Exception {
        tm.suspend();
        afterEndTransaction.run();
        if (ret instanceof CompletionStage) {
            return ((CompletionStage)ret).handle((v, throwable) -> {
                try {
                    ContextPropagationAsyncHandler.doInTransaction(tm, tx2, () -> {
                        if (throwable != null) {
                            TransactionHandler.handleExceptionNoThrow(transactional, throwable, tx2);
                        }
                        TransactionHandler.endTransaction(tm, tx2, () -> {});
                    });
                }
                catch (RuntimeException e) {
                    if (throwable != null) {
                        e.addSuppressed((Throwable)throwable);
                    }
                    throw e;
                }
                catch (Exception e) {
                    CompletionException x = new CompletionException(e);
                    if (throwable != null) {
                        x.addSuppressed((Throwable)throwable);
                    }
                    throw x;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable != null) {
                    throw new CompletionException((Throwable)throwable);
                }
                return v;
            });
        }
        if (ret instanceof Publisher) {
            ret = ReactiveStreams.fromPublisher((Publisher)((Publisher)ret)).onError(throwable -> {
                try {
                    ContextPropagationAsyncHandler.doInTransaction(tm, tx2, () -> TransactionHandler.handleExceptionNoThrow(transactional, throwable, tx2));
                }
                catch (RuntimeException e) {
                    e.addSuppressed((Throwable)throwable);
                    throw e;
                }
                catch (Exception e) {
                    RuntimeException x = new RuntimeException(e);
                    x.addSuppressed((Throwable)throwable);
                    throw x;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException((Throwable)throwable);
            }).onTerminate(() -> {
                try {
                    ContextPropagationAsyncHandler.doInTransaction(tm, tx2, () -> TransactionHandler.endTransaction(tm, tx2, () -> {}));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    RuntimeException x = new RuntimeException(e);
                    throw x;
                }
            }).buildRs();
        }
        return ret;
    }

    private static void doInTransaction(TransactionManager tm, Transaction tx2, RunnableWithException f) throws Exception {
        Transaction currentTransaction = tm.getTransaction();
        if (currentTransaction != tx2) {
            if (currentTransaction != null) {
                tm.suspend();
            }
            tm.resume(tx2);
        }
        f.run();
        if (currentTransaction != tx2) {
            tm.suspend();
            if (currentTransaction != null) {
                tm.resume(currentTransaction);
            }
        }
    }

    private static boolean areSmallRyeReactiveClassesAvailable() {
        return Arrays.asList("io.smallrye.reactive.converters.ReactiveTypeConverter", "io.smallrye.reactive.converters.Registry", "org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams", "org.reactivestreams.Publisher").stream().allMatch(className -> {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                log.debugf("Class %s is not available on classpath. Handling of asynchronous types in @Transactional methods could not work properly. Consider to add java artifacts 'org.eclipse.microprofile.reactive-streams-operators.microprofile-reactive-streams-operators-api', 'org.reactivestreams:reactive-streams' and  'io.smallrye.reactive:smallrye-reactive-converter-api' to your classpath", className);
                return false;
            }
            return true;
        });
    }
}

