/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayPositionFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleArrayPositionFunction
extends AbstractArrayPositionFunction {
    public OracleArrayPositionFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        String arrayTypeName = DdlTypeHelper.getTypeName(arrayExpression.getExpressionType(), walker.getSessionFactory().getTypeConfiguration());
        sqlAppender.appendSql(arrayTypeName);
        sqlAppender.append("_position(");
        arrayExpression.accept(walker);
        sqlAppender.append(',');
        sqlAstArguments.get(1).accept(walker);
        if (sqlAstArguments.size() > 2) {
            sqlAppender.append(',');
            sqlAstArguments.get(2).accept(walker);
        }
        sqlAppender.append(")");
    }
}

