/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.topology.CacheAvailabilityUpdateCommand;
import org.infinispan.commands.topology.CacheJoinCommand;
import org.infinispan.commands.topology.CacheLeaveCommand;
import org.infinispan.commands.topology.CacheShutdownRequestCommand;
import org.infinispan.commands.topology.RebalancePhaseConfirmCommand;
import org.infinispan.commands.topology.RebalancePolicyUpdateCommand;
import org.infinispan.commands.topology.RebalanceStatusRequestCommand;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Version;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.GlobalStateProvider;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.globalstate.impl.ScopedPersistentStateImpl;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.topology.CacheJoinException;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyHandler;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.EventLoggerViewListener;
import org.infinispan.topology.LocalCacheStatus;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.ManagerStatusResponse;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.topology.RebalancingStatus;
import org.infinispan.topology.TopologyManagementHelper;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.concurrent.ActionSequencer;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;
import org.infinispan.util.logging.events.Messages;

@MBean(objectName="LocalTopologyManager", description="Controls the cache membership and state transfer")
@Scope(value=Scopes.GLOBAL)
public class LocalTopologyManagerImpl
implements LocalTopologyManager,
GlobalStateProvider {
    private static final Log log = LogFactory.getLog(LocalTopologyManagerImpl.class);
    @Inject
    Transport transport;
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    ExecutorService nonBlockingExecutor;
    @Inject
    BlockingManager blockingManager;
    @Inject
    @ComponentName(value="org.infinispan.executors.timeout")
    ScheduledExecutorService timeoutExecutor;
    @Inject
    GlobalComponentRegistry gcr;
    @Inject
    TimeService timeService;
    @Inject
    GlobalStateManager globalStateManager;
    @Inject
    PersistentUUIDManager persistentUUIDManager;
    @Inject
    EventLogManager eventLogManager;
    @Inject
    CacheManagerNotifier cacheManagerNotifier;
    @Inject
    ClusterTopologyManager clusterTopologyManager;
    private TopologyManagementHelper helper;
    private ActionSequencer actionSequencer;
    private EventLogger eventLogger;
    private final Map<String, LocalCacheStatus> runningCaches = Collections.synchronizedMap(new HashMap());
    private volatile boolean running;
    @GuardedBy(value="runningCaches")
    private int latestStatusResponseViewId;
    private PersistentUUID persistentUUID;
    private EventLoggerViewListener viewListener;

    @Start(priority=0)
    public void preStart() {
        this.helper = new TopologyManagementHelper(this.gcr);
        this.actionSequencer = new ActionSequencer(this.nonBlockingExecutor, true, this.timeService);
        if (this.globalStateManager != null) {
            this.globalStateManager.registerStateProvider(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Start(priority=100)
    public void start() {
        if (log.isTraceEnabled()) {
            log.tracef("Starting LocalTopologyManager on %s", this.transport.getAddress());
        }
        if (this.persistentUUID == null) {
            this.persistentUUID = PersistentUUID.randomUUID();
            this.globalStateManager.writeGlobalState();
        }
        this.persistentUUIDManager.addPersistentAddressMapping(this.transport.getAddress(), this.persistentUUID);
        this.eventLogger = this.eventLogManager.getEventLogger().scope(this.transport.getAddress()).context(this.getClass().getName());
        this.viewListener = new EventLoggerViewListener(this.eventLogManager);
        this.cacheManagerNotifier.addListener(this.viewListener);
        Map<String, LocalCacheStatus> map = this.runningCaches;
        synchronized (map) {
            this.latestStatusResponseViewId = this.transport.getViewId();
        }
        this.running = true;
    }

    @Stop(priority=110)
    public void stop() {
        if (log.isTraceEnabled()) {
            log.tracef("Stopping LocalTopologyManager on %s", this.transport.getAddress());
        }
        this.cacheManagerNotifier.removeListener(this.viewListener);
        this.running = false;
    }

    @Override
    public CompletionStage<CacheTopology> join(String cacheName, CacheJoinInfo joinInfo, CacheTopologyHandler stm, PartitionHandlingManager phm) {
        CompletionStage<KeyValuePair> cf = this.orderOnCache(cacheName, () -> {
            log.debugf("Node %s joining cache %s", this.transport.getAddress(), cacheName);
            LocalCacheStatus cacheStatus = new LocalCacheStatus(joinInfo, stm, phm, this.getNumberMembersFromState(cacheName, joinInfo));
            LocalCacheStatus previousStatus = this.runningCaches.put(cacheName, cacheStatus);
            if (previousStatus != null) {
                throw new IllegalStateException("A cache can only join once");
            }
            long timeout = joinInfo.getTimeout();
            long endTime = this.timeService.expectedEndTime(timeout, TimeUnit.MILLISECONDS);
            return this.sendJoinRequest(cacheName, joinInfo, timeout, endTime).thenCompose(joinResponse -> this.handleJoinResponse(cacheName, cacheStatus, (CacheStatusResponse)joinResponse).thenApply(ct -> KeyValuePair.of(joinResponse, ct)));
        });
        return cf.thenCompose(entry -> {
            if (((CacheStatusResponse)entry.getKey()).isEmpty()) {
                LocalCacheStatus lcs = this.runningCaches.get(cacheName);
                return lcs.getStableTopologyCompletion().thenCompose(ignore -> {
                    lcs.setCurrentTopology(null);
                    return this.join(cacheName, lcs);
                });
            }
            return CompletableFuture.completedFuture((CacheTopology)entry.getValue());
        });
    }

    private CompletionStage<CacheTopology> join(String cacheName, LocalCacheStatus cacheStatus) {
        return this.orderOnCache(cacheName, () -> {
            if (this.runningCaches.get(cacheName) != cacheStatus) {
                throw new IllegalStateException("Cache status changed while joining");
            }
            long timeout = cacheStatus.getJoinInfo().getTimeout();
            long endTime = this.timeService.expectedEndTime(timeout, TimeUnit.MILLISECONDS);
            return this.sendJoinRequest(cacheName, cacheStatus.getJoinInfo(), timeout, endTime).thenCompose(joinResponse -> this.handleJoinResponse(cacheName, cacheStatus, (CacheStatusResponse)joinResponse));
        });
    }

    private CompletionStage<CacheStatusResponse> sendJoinRequest(String cacheName, CacheJoinInfo joinInfo, long timeout, long endTime) {
        int viewId = this.transport.getViewId();
        CacheJoinCommand command = new CacheJoinCommand(cacheName, this.transport.getAddress(), joinInfo, viewId);
        return CompletionStages.handleAndCompose(this.helper.executeOnCoordinator(this.transport, command, timeout), (response, throwable) -> {
            int currentViewId = this.transport.getViewId();
            if (viewId != currentViewId) {
                log.tracef("Received new view %d before join response for cache %s, retrying", currentViewId, cacheName);
                return this.sendJoinRequest(cacheName, joinInfo, timeout, endTime);
            }
            if (throwable == null) {
                if (response != null) {
                    return CompletableFuture.completedFuture((CacheStatusResponse)response);
                }
                log.debugf("Coordinator sent a null join response, retrying in view %d", viewId + 1);
                return this.retryJoinInView(cacheName, joinInfo, timeout, endTime, viewId + 1);
            }
            Throwable t = CompletableFutures.extractException((Throwable)throwable);
            if (!(t instanceof SuspectException)) {
                log.debugf(t, "Join request failed for cache %s", cacheName);
                if (t instanceof TimeoutException) {
                    throw (TimeoutException)((Object)((Object)t));
                }
                throw (CacheJoinException)((Object)((Object)t.getCause()));
            }
            log.debugf("Join request received CacheNotFoundResponse for cache %s, retrying", cacheName);
            long delay = 100L;
            return CompletionStages.scheduleNonBlocking(() -> this.sendJoinRequest(cacheName, joinInfo, timeout, endTime), this.timeoutExecutor, delay, TimeUnit.MILLISECONDS);
        });
    }

    private CompletionStage<CacheStatusResponse> retryJoinInView(String cacheName, CacheJoinInfo joinInfo, long timeout, long endTime, int viewId) {
        return this.withView(viewId, timeout, TimeUnit.MILLISECONDS).thenCompose(v -> this.sendJoinRequest(cacheName, joinInfo, timeout, endTime));
    }

    private CompletionStage<CacheTopology> handleJoinResponse(String cacheName, LocalCacheStatus cacheStatus, CacheStatusResponse initialStatus) {
        int viewId = this.transport.getViewId();
        return this.doHandleTopologyUpdate(cacheName, initialStatus.getCacheTopology(), initialStatus.getAvailabilityMode(), viewId, this.transport.getCoordinator(), cacheStatus).thenCompose(applied -> {
            if (!applied.booleanValue()) {
                throw new IllegalStateException("We already had a newer topology by the time we received the join response");
            }
            LocalCacheStatus lcs = this.runningCaches.get(cacheName);
            if (initialStatus.getStableTopology() == null && !this.transport.isCoordinator()) {
                Log.CONTAINER.recoverFromStateMissingMembers(cacheName, initialStatus.joinedMembers(), lcs.getStableMembersSize());
            }
            cacheStatus.setCurrentMembers(initialStatus.joinedMembers());
            return this.doHandleStableTopologyUpdate(cacheName, initialStatus.getStableTopology(), viewId, this.transport.getCoordinator(), cacheStatus);
        }).thenApply(ignored -> initialStatus.getCacheTopology());
    }

    private int getNumberMembersFromState(String cacheName, CacheJoinInfo joinInfo) {
        Optional<ScopedPersistentState> optional = this.globalStateManager.readScopedState(cacheName);
        return optional.map(state -> {
            Object ch = joinInfo.getConsistentHashFactory().fromPersistentState((ScopedPersistentState)state);
            return ch.getMembers().size();
        }).orElse(-1);
    }

    @Override
    public void leave(String cacheName, long timeout) {
        log.debugf("Node %s leaving cache %s", this.transport.getAddress(), cacheName);
        this.runningCaches.remove(cacheName);
        CacheLeaveCommand command = new CacheLeaveCommand(cacheName, this.transport.getAddress(), this.transport.getViewId());
        try {
            CompletionStages.join(this.helper.executeOnCoordinator(this.transport, command, timeout));
        }
        catch (Exception e) {
            log.debugf(e, "Error sending the leave request for cache %s to coordinator", cacheName);
        }
    }

    @Override
    public void confirmRebalancePhase(String cacheName, int topologyId, int rebalanceId, Throwable throwable) {
        try {
            this.helper.executeOnCoordinatorAsync(this.transport, new RebalancePhaseConfirmCommand(cacheName, this.transport.getAddress(), throwable, topologyId, this.transport.getViewId()));
        }
        catch (Exception e) {
            log.debugf(e, "Error sending the rebalance completed notification for cache %s to the coordinator", cacheName);
        }
    }

    @Override
    public CompletionStage<ManagerStatusResponse> handleStatusRequest(int viewId) {
        return this.withView(viewId, this.getGlobalTimeout(), TimeUnit.MILLISECONDS).thenApply(ignored -> {
            HashMap<String, CacheStatusResponse> caches = new HashMap<String, CacheStatusResponse>();
            Map<String, LocalCacheStatus> map = this.runningCaches;
            synchronized (map) {
                this.latestStatusResponseViewId = viewId;
                for (Map.Entry<String, LocalCacheStatus> e : this.runningCaches.entrySet()) {
                    String cacheName = e.getKey();
                    LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
                    if (cacheStatus.getCurrentTopology() == null) {
                        if (!cacheStatus.needRecovery()) continue;
                        String name = cacheName;
                        this.join(name, cacheStatus).whenComplete((ignore, t) -> {
                            if (t != null) {
                                this.leave(name, this.getGlobalTimeout());
                            }
                        });
                        continue;
                    }
                    caches.put(e.getKey(), new CacheStatusResponse(cacheStatus.getJoinInfo(), cacheStatus.getCurrentTopology(), cacheStatus.getStableTopology(), cacheStatus.getPartitionHandlingManager().getAvailabilityMode(), cacheStatus.knownMembers()));
                }
            }
            log.debugf("Sending cluster status response for view %d", viewId);
            return new ManagerStatusResponse(caches, this.gcr.getClusterTopologyManager().isRebalancingEnabled());
        });
    }

    @Override
    public CompletionStage<Void> handleTopologyUpdate(String cacheName, CacheTopology cacheTopology, AvailabilityMode availabilityMode, int viewId, Address sender) {
        if (!this.running) {
            log.tracef("Ignoring consistent hash update %s for cache %s, the local cache manager is not running", cacheTopology.getTopologyId(), cacheName);
            return CompletableFutures.completedNull();
        }
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        if (cacheStatus == null) {
            log.tracef("Ignoring consistent hash update %s for cache %s that doesn't exist locally", cacheTopology.getTopologyId(), cacheName);
            return CompletableFutures.completedNull();
        }
        return this.withView(viewId, cacheStatus.getJoinInfo().getTimeout(), TimeUnit.MILLISECONDS).thenCompose(ignored -> this.orderOnCache(cacheName, () -> this.doHandleTopologyUpdate(cacheName, cacheTopology, availabilityMode, viewId, sender, cacheStatus))).handle((ignored, throwable) -> {
            if (throwable != null && !(throwable instanceof IllegalLifecycleStateException)) {
                log.topologyUpdateError(cacheName, (Throwable)throwable);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Boolean> doHandleTopologyUpdate(String cacheName, CacheTopology cacheTopology, AvailabilityMode availabilityMode, int viewId, Address sender, LocalCacheStatus cacheStatus) {
        ConsistentHash unionCH;
        CacheTopology existingTopology;
        LocalCacheStatus localCacheStatus = cacheStatus;
        synchronized (localCacheStatus) {
            if (cacheTopology == null) {
                return CompletableFutures.completedTrue();
            }
            this.registerPersistentUUID(cacheTopology);
            existingTopology = cacheStatus.getCurrentTopology();
            if (existingTopology != null && cacheTopology.getTopologyId() <= existingTopology.getTopologyId()) {
                log.debugf("Ignoring late consistent hash update for cache %s, current topology is %s: %s", cacheName, existingTopology.getTopologyId(), cacheTopology);
                return CompletableFutures.completedFalse();
            }
            if (!this.updateCacheTopology(cacheName, cacheTopology, viewId, sender, cacheStatus)) {
                return CompletableFutures.completedFalse();
            }
        }
        CacheTopologyHandler handler = cacheStatus.getHandler();
        ConsistentHash currentCH = cacheTopology.getCurrentCH();
        ConsistentHash pendingCH = cacheTopology.getPendingCH();
        if (pendingCH != null) {
            ConsistentHashFactory chf = cacheStatus.getJoinInfo().getConsistentHashFactory();
            switch (cacheTopology.getPhase()) {
                case READ_NEW_WRITE_ALL: {
                    unionCH = chf.union(pendingCH, currentCH);
                    break;
                }
                default: {
                    unionCH = chf.union(currentCH, pendingCH);
                    break;
                }
            }
        } else {
            unionCH = null;
        }
        List<PersistentUUID> persistentUUIDs = this.persistentUUIDManager.mapAddresses(cacheTopology.getActualMembers());
        CacheTopology unionTopology = new CacheTopology(cacheTopology.getTopologyId(), cacheTopology.getRebalanceId(), currentCH, pendingCH, unionCH, cacheTopology.getPhase(), cacheTopology.getActualMembers(), persistentUUIDs);
        boolean updateAvailabilityModeFirst = availabilityMode != AvailabilityMode.AVAILABLE;
        CompletionStage<Void> stage = this.resetLocalTopologyBeforeRebalance(cacheName, cacheTopology, existingTopology, handler);
        stage = stage.thenCompose(ignored -> {
            unionTopology.logRoutingTableInformation(cacheName);
            if (updateAvailabilityModeFirst && availabilityMode != null) {
                return cacheStatus.getPartitionHandlingManager().setAvailabilityMode(availabilityMode);
            }
            return CompletableFutures.completedNull();
        });
        stage = stage.thenCompose(ignored -> {
            boolean startConflictResolution;
            boolean bl = startConflictResolution = cacheTopology.getPhase() == CacheTopology.Phase.CONFLICT_RESOLUTION;
            if (!(startConflictResolution || unionCH == null || existingTopology != null && existingTopology.getRebalanceId() == cacheTopology.getRebalanceId())) {
                log.tracef("This topology update has a pending CH, starting the rebalance now", new Object[0]);
                return handler.rebalance(unionTopology);
            }
            return handler.updateConsistentHash(unionTopology);
        });
        if (!updateAvailabilityModeFirst) {
            stage = stage.thenCompose(ignored -> cacheStatus.getPartitionHandlingManager().setAvailabilityMode(availabilityMode));
        }
        return stage.thenApply(ignored -> true);
    }

    private void registerPersistentUUID(CacheTopology cacheTopology) {
        int count = cacheTopology.getActualMembers().size();
        for (int i = 0; i < count; ++i) {
            this.persistentUUIDManager.addPersistentAddressMapping(cacheTopology.getActualMembers().get(i), cacheTopology.getMembersPersistentUUIDs().get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateCacheTopology(String cacheName, CacheTopology cacheTopology, int viewId, Address sender, LocalCacheStatus cacheStatus) {
        Map<String, LocalCacheStatus> map = this.runningCaches;
        synchronized (map) {
            if (!this.validateCommandViewId(cacheTopology, viewId, sender, cacheName)) {
                return false;
            }
            log.debugf("Updating local topology for cache %s: %s", cacheName, cacheTopology);
            cacheStatus.setCurrentTopology(cacheTopology);
            return true;
        }
    }

    @GuardedBy(value="runningCaches")
    private boolean validateCommandViewId(CacheTopology cacheTopology, int viewId, Address sender, String cacheName) {
        if (!sender.equals(this.transport.getCoordinator())) {
            log.debugf("Ignoring topology %d for cache %s from old coordinator %s", cacheTopology.getTopologyId(), cacheName, sender);
            return false;
        }
        if (viewId < this.latestStatusResponseViewId) {
            log.debugf("Ignoring topology %d for cache %s from view %d received after status request from view %d", new Object[]{cacheTopology.getTopologyId(), cacheName, viewId, this.latestStatusResponseViewId});
            return false;
        }
        return true;
    }

    private CompletionStage<Void> resetLocalTopologyBeforeRebalance(String cacheName, CacheTopology newCacheTopology, CacheTopology oldCacheTopology, CacheTopologyHandler handler) {
        boolean newRebalance;
        boolean bl = newRebalance = newCacheTopology.getPhase() != CacheTopology.Phase.NO_REBALANCE && newCacheTopology.getPhase() != CacheTopology.Phase.CONFLICT_RESOLUTION;
        if (newRebalance) {
            if (oldCacheTopology == null) {
                return CompletableFutures.completedNull();
            }
            if (newCacheTopology.getTopologyId() <= oldCacheTopology.getTopologyId() + 1) {
                return CompletableFutures.completedNull();
            }
            if (newCacheTopology.getRebalanceId() != oldCacheTopology.getRebalanceId()) {
                this.registerPersistentUUID(newCacheTopology);
                CacheTopology resetTopology = new CacheTopology(newCacheTopology.getTopologyId() - 1, newCacheTopology.getRebalanceId() - 1, newCacheTopology.getCurrentCH(), null, CacheTopology.Phase.NO_REBALANCE, newCacheTopology.getActualMembers(), this.persistentUUIDManager.mapAddresses(newCacheTopology.getActualMembers()));
                log.debugf("Installing fake cache topology %s for cache %s", resetTopology, cacheName);
                return handler.updateConsistentHash(resetTopology);
            }
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> handleStableTopologyUpdate(String cacheName, CacheTopology newStableTopology, Address sender, int viewId) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        if (cacheStatus != null) {
            return this.orderOnCache(cacheName, () -> this.doHandleStableTopologyUpdate(cacheName, newStableTopology, viewId, sender, cacheStatus));
        }
        return CompletableFutures.completedNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> doHandleStableTopologyUpdate(String cacheName, CacheTopology newStableTopology, int viewId, Address sender, LocalCacheStatus cacheStatus) {
        Map<String, LocalCacheStatus> map = this.runningCaches;
        synchronized (map) {
            if (!this.validateCommandViewId(newStableTopology, viewId, sender, cacheName)) {
                return CompletableFutures.completedNull();
            }
            CacheTopology stableTopology = cacheStatus.getStableTopology();
            if (stableTopology == null || stableTopology.getTopologyId() < newStableTopology.getTopologyId()) {
                log.tracef("Updating stable topology for cache %s: %s", cacheName, newStableTopology);
                cacheStatus.setStableTopology(newStableTopology);
                if (newStableTopology != null && cacheStatus.getJoinInfo().getPersistentUUID() != null) {
                    this.deleteCHState(cacheName);
                }
            }
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> handleRebalance(String cacheName, CacheTopology cacheTopology, int viewId, Address sender) {
        if (!this.running) {
            log.debugf("Ignoring rebalance request %s for cache %s, the local cache manager is not running", cacheTopology.getTopologyId(), cacheName);
            return CompletableFutures.completedNull();
        }
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        if (cacheStatus == null) {
            log.tracef("Ignoring rebalance %s for cache %s that doesn't exist locally", cacheTopology.getTopologyId(), cacheName);
            return CompletableFutures.completedNull();
        }
        this.eventLogger.context(cacheName).info(EventLogCategory.LIFECYCLE, Messages.MESSAGES.cacheRebalanceStart(cacheTopology.getMembers(), cacheTopology.getPhase(), cacheTopology.getTopologyId()));
        return this.withView(viewId, cacheStatus.getJoinInfo().getTimeout(), TimeUnit.MILLISECONDS).thenCompose(ignored -> this.orderOnCache(cacheName, () -> this.doHandleRebalance(viewId, cacheStatus, cacheTopology, cacheName, sender))).handle((ignore, throwable) -> {
            List<Address> members = cacheTopology.getMembers();
            int topologyId = cacheTopology.getTopologyId();
            if (throwable != null) {
                Throwable t = CompletableFutures.extractException((Throwable)throwable);
                if (!(t instanceof IllegalLifecycleStateException)) {
                    log.rebalanceStartError(cacheName, (Throwable)throwable);
                    this.eventLogger.context(cacheName).error(EventLogCategory.LIFECYCLE, Messages.MESSAGES.rebalanceFinishedWithFailure(members, topologyId, t));
                }
            } else {
                this.eventLogger.context(cacheName).info(EventLogCategory.LIFECYCLE, Messages.MESSAGES.rebalanceFinished(members, topologyId));
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> doHandleRebalance(int viewId, LocalCacheStatus cacheStatus, CacheTopology cacheTopology, String cacheName, Address sender) {
        CacheTopology existingTopology;
        LocalCacheStatus localCacheStatus = cacheStatus;
        synchronized (localCacheStatus) {
            existingTopology = cacheStatus.getCurrentTopology();
            if (existingTopology != null && cacheTopology.getTopologyId() <= existingTopology.getTopologyId()) {
                log.debugf("Ignoring old rebalance for cache %s, current topology is %s: %s", cacheName, existingTopology.getTopologyId(), cacheTopology);
                return CompletableFutures.completedNull();
            }
            if (!this.updateCacheTopology(cacheName, cacheTopology, viewId, sender, cacheStatus)) {
                return CompletableFutures.completedNull();
            }
        }
        CacheTopologyHandler handler = cacheStatus.getHandler();
        ConsistentHash unionCH = cacheStatus.getJoinInfo().getConsistentHashFactory().union(cacheTopology.getCurrentCH(), cacheTopology.getPendingCH());
        CacheTopology newTopology = new CacheTopology(cacheTopology.getTopologyId(), cacheTopology.getRebalanceId(), cacheTopology.getCurrentCH(), cacheTopology.getPendingCH(), unionCH, cacheTopology.getPhase(), cacheTopology.getActualMembers(), cacheTopology.getMembersPersistentUUIDs());
        CompletionStage<Void> stage = this.resetLocalTopologyBeforeRebalance(cacheName, cacheTopology, existingTopology, handler);
        return stage.thenCompose(ignored -> {
            log.debugf("Starting local rebalance for cache %s, topology = %s", cacheName, cacheTopology);
            cacheTopology.logRoutingTableInformation(cacheName);
            return handler.rebalance(newTopology);
        });
    }

    @Override
    public CacheTopology getCacheTopology(String cacheName) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        return cacheStatus != null ? cacheStatus.getCurrentTopology() : null;
    }

    @Override
    public CacheTopology getStableCacheTopology(String cacheName) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        return cacheStatus != null ? cacheStatus.getStableTopology() : null;
    }

    private CompletionStage<Void> withView(int viewId, long timeout, TimeUnit timeUnit) {
        CompletableFuture<Void> viewFuture = this.transport.withView(viewId);
        ScheduledFuture<Boolean> cancelTask = this.timeoutExecutor.schedule(() -> viewFuture.completeExceptionally((Throwable)((Object)Log.CLUSTER.timeoutWaitingForView(viewId, this.transport.getViewId()))), timeout, timeUnit);
        viewFuture.whenComplete((v, throwable) -> cancelTask.cancel(false));
        return viewFuture;
    }

    @Override
    @ManagedAttribute(description="Rebalancing enabled", displayName="Rebalancing enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isRebalancingEnabled() {
        return this.isCacheRebalancingEnabled(null);
    }

    @Override
    public void setRebalancingEnabled(boolean enabled) {
        this.setCacheRebalancingEnabled(null, enabled);
    }

    @Override
    public boolean isCacheRebalancingEnabled(String cacheName) {
        RebalanceStatusRequestCommand command = new RebalanceStatusRequestCommand(cacheName);
        int viewId = this.transport.getViewId();
        RebalancingStatus status = (RebalancingStatus)((Object)CompletionStages.join(this.executeOnCoordinatorRetry(command, viewId, this.timeService.expectedEndTime((long)this.getGlobalTimeout(), TimeUnit.MILLISECONDS))));
        return status != RebalancingStatus.SUSPENDED;
    }

    public CompletionStage<Object> executeOnCoordinatorRetry(ReplicableCommand command, int viewId, long endNanos) {
        long remainingMillis = this.timeService.remainingTime(endNanos, TimeUnit.MILLISECONDS);
        return CompletionStages.handleAndCompose(this.helper.executeOnCoordinator(this.transport, command, remainingMillis), (o, throwable) -> {
            if (throwable == null) {
                return CompletableFuture.completedFuture(o);
            }
            Throwable t = CompletableFutures.extractException((Throwable)throwable);
            if (t instanceof SuspectException) {
                if (log.isTraceEnabled()) {
                    log.tracef("Coordinator left the cluster while querying rebalancing status, retrying", new Object[0]);
                }
                int newViewId = Math.max(viewId + 1, this.transport.getViewId());
                return this.executeOnCoordinatorRetry(command, newViewId, endNanos);
            }
            return CompletableFutures.completedExceptionFuture((Throwable)t);
        });
    }

    @Override
    public void setCacheRebalancingEnabled(String cacheName, boolean enabled) {
        if (cacheName != null) {
            LocalCacheStatus lcs = this.runningCaches.get(cacheName);
            if (lcs == null) {
                log.debugf("Not changing rebalance for unknown cache %s", cacheName);
                return;
            }
            if (!lcs.isStableTopologyRestored()) {
                log.debugf("Not changing rebalance for cache '%s' without stable topology", cacheName);
                return;
            }
        }
        RebalancePolicyUpdateCommand command = new RebalancePolicyUpdateCommand(cacheName, enabled);
        CompletionStages.join(this.helper.executeOnClusterSync(this.transport, command, this.getGlobalTimeout(), VoidResponseCollector.ignoreLeavers()));
    }

    @Override
    public RebalancingStatus getRebalancingStatus(String cacheName) {
        RebalanceStatusRequestCommand command = new RebalanceStatusRequestCommand(cacheName);
        return (RebalancingStatus)((Object)CompletionStages.join(this.executeOnCoordinatorRetry(command, this.transport.getViewId(), this.timeService.expectedEndTime((long)this.getGlobalTimeout(), TimeUnit.MILLISECONDS))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(description="Cluster availability", displayName="Cluster availability", dataType=DataType.TRAIT, writable=false)
    public String getClusterAvailability() {
        AvailabilityMode clusterAvailability = AvailabilityMode.AVAILABLE;
        Map<String, LocalCacheStatus> map = this.runningCaches;
        synchronized (map) {
            for (LocalCacheStatus cacheStatus : this.runningCaches.values()) {
                AvailabilityMode availabilityMode = cacheStatus.getPartitionHandlingManager().getAvailabilityMode();
                clusterAvailability = clusterAvailability.min(availabilityMode);
            }
        }
        return clusterAvailability.toString();
    }

    @Override
    public AvailabilityMode getCacheAvailability(String cacheName) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        return cacheStatus.getPartitionHandlingManager().getAvailabilityMode();
    }

    @Override
    public void setCacheAvailability(String cacheName, AvailabilityMode availabilityMode) {
        CacheAvailabilityUpdateCommand command = new CacheAvailabilityUpdateCommand(cacheName, availabilityMode);
        CompletionStages.join(this.helper.executeOnCoordinator(this.transport, command, this.getGlobalTimeout()));
    }

    @Override
    public void cacheShutdown(String name) {
        CacheShutdownRequestCommand command = new CacheShutdownRequestCommand(name);
        CompletionStages.join(this.helper.executeOnCoordinator(this.transport, command, this.getGlobalTimeout()));
    }

    @Override
    public CompletionStage<Void> handleCacheShutdown(String cacheName) {
        this.writeCHState(cacheName);
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> stableTopologyCompletion(String cacheName) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        if (cacheStatus == null) {
            return null;
        }
        return cacheStatus.getStableTopologyCompletion().thenCompose(recovered -> {
            PersistenceManager pm;
            ComponentRegistry cr;
            if (!recovered.booleanValue() && (cr = this.gcr.getNamedComponentRegistry(cacheName)) != null && (pm = cr.getComponent(PersistenceManager.class)) != null) {
                return pm.clearAllStores(PersistenceManager.AccessMode.PRIVATE.and(StoreConfiguration::purgeOnStartup));
            }
            return CompletableFutures.completedNull();
        });
    }

    @Override
    public void assertTopologyStable(String cacheName) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        if (cacheStatus != null && !cacheStatus.isStableTopologyRestored()) {
            List<Address> members = this.clusterTopologyManager.currentJoiners(cacheName);
            if (members == null) {
                members = cacheStatus.knownMembers();
            }
            throw log.recoverFromStateMissingMembers(cacheName, members, String.valueOf(cacheStatus.getStableMembersSize()));
        }
    }

    private void writeCHState(String cacheName) {
        CacheTopology topology;
        ScopedPersistentStateImpl cacheState = new ScopedPersistentStateImpl(cacheName);
        cacheState.setProperty("@version", Version.getVersion());
        cacheState.setProperty("@timestamp", this.timeService.instant().toString());
        cacheState.setProperty("version-major", Version.getMajor());
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        CacheTopology cacheTopology = topology = cacheStatus != null ? cacheStatus.getCurrentTopology() : null;
        if (cacheStatus != null && topology != null) {
            ConsistentHash remappedCH = topology.getCurrentCH().remapAddresses(this.persistentUUIDManager.addressToPersistentUUID());
            remappedCH.toScopedState(cacheState);
            this.globalStateManager.writeScopedState(cacheState);
            if (log.isTraceEnabled()) {
                log.tracef("Written CH state for cache %s, checksum=%s: %s", cacheName, cacheState.getChecksum(), remappedCH);
            }
        } else {
            log.tracef("Cache '%s' status not found (%s) to write CH or without topology", cacheName, cacheStatus);
        }
    }

    private void deleteCHState(String cacheName) {
        this.globalStateManager.deleteScopedState(cacheName);
        if (log.isTraceEnabled()) {
            log.tracef("Removed CH state for cache %s", cacheName);
        }
    }

    private int getGlobalTimeout() {
        return (int)this.gcr.getGlobalConfiguration().transport().distributedSyncTimeout();
    }

    @Override
    public void prepareForPersist(ScopedPersistentState state) {
        if (this.persistentUUID != null) {
            state.setProperty("uuid", this.persistentUUID.toString());
        }
    }

    @Override
    public void prepareForRestore(ScopedPersistentState state) {
        if (!state.containsProperty("uuid")) {
            throw Log.CONFIG.invalidPersistentState("___global");
        }
        this.persistentUUID = PersistentUUID.fromString(state.getProperty("uuid"));
    }

    @Override
    public PersistentUUID getPersistentUUID() {
        return this.persistentUUID;
    }

    private <T> CompletionStage<T> orderOnCache(String cacheName, Callable<CompletionStage<T>> action) {
        return this.actionSequencer.orderOnKey(cacheName, () -> {
            log.tracef("Acquired cache status %s", cacheName);
            return ((CompletionStage)action.call()).whenComplete((v, t) -> log.tracef("Released cache status %s", cacheName));
        });
    }
}

