/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect;

import io.netty.channel.ChannelHandler;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederatedBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationAddressPolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationQueuePolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.BrokerConnection;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerQueuePlugin;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnectionChannelHandler;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnectionManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationSource;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerAggregation;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolLogger;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.SenderController;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASLFactory;
import org.apache.activemq.artemis.protocol.amqp.sasl.scram.SCRAMClientSASL;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.security.scram.SCRAM;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPBrokerConnection
implements ClientConnectionLifeCycleListener,
ActiveMQServerQueuePlugin,
BrokerConnection {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AMQPBrokerConnectConfiguration brokerConnectConfiguration;
    private final ProtonProtocolManager protonProtocolManager;
    private final ActiveMQServer server;
    private final NettyConnector bridgesConnector;
    private NettyConnection connection;
    private Session session;
    private AMQPSessionContext sessionContext;
    private ActiveMQProtonRemotingConnection protonRemotingConnection;
    private volatile boolean started = false;
    private final AMQPBrokerConnectionManager bridgeManager;
    private AMQPMirrorControllerSource mirrorControllerSource;
    private AMQPFederationSource brokerFederation;
    private int retryCounter = 0;
    private int lastRetryCounter;
    private boolean connecting = false;
    private volatile ScheduledFuture<?> reconnectFuture;
    private final Set<Queue> senders = new HashSet<Queue>();
    private final Set<Queue> receivers = new HashSet<Queue>();
    private final Map<String, Predicate<Link>> linkClosedInterceptors = new ConcurrentHashMap<String, Predicate<Link>>();
    final Executor connectExecutor;
    final ScheduledExecutorService scheduledExecutorService;
    String host;
    int port;
    private static final String EXTERNAL = "EXTERNAL";
    private static final String PLAIN = "PLAIN";
    private static final String ANONYMOUS = "ANONYMOUS";
    private static final byte[] EMPTY = new byte[0];

    public AMQPBrokerConnection(AMQPBrokerConnectionManager bridgeManager, AMQPBrokerConnectConfiguration brokerConnectConfiguration, ProtonProtocolManager protonProtocolManager, ActiveMQServer server, NettyConnector bridgesConnector) {
        this.bridgeManager = bridgeManager;
        this.brokerConnectConfiguration = brokerConnectConfiguration;
        this.protonProtocolManager = protonProtocolManager;
        this.server = server;
        this.bridgesConnector = bridgesConnector;
        this.connectExecutor = server.getExecutorFactory().getExecutor();
        this.scheduledExecutorService = server.getScheduledPool();
    }

    public String getName() {
        return this.brokerConnectConfiguration.getName();
    }

    public String getProtocol() {
        return "AMQP";
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public int getConnectionTimeout() {
        return this.bridgesConnector.getConnectTimeoutMillis();
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.protonRemotingConnection != null) {
            this.protonRemotingConnection.fail(new ActiveMQException("Stopping Broker Connection"));
            this.protonRemotingConnection = null;
            this.connection = null;
        }
        ScheduledFuture<?> scheduledFuture = this.reconnectFuture;
        this.reconnectFuture = null;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        if (this.brokerFederation != null) {
            try {
                this.brokerFederation.stop();
            }
            catch (ActiveMQException activeMQException) {
                // empty catch block
            }
        }
    }

    public void start() throws Exception {
        if (this.started) {
            return;
        }
        this.started = true;
        this.server.getConfiguration().registerBrokerPlugin((ActiveMQServerBasePlugin)this);
        try {
            if (this.brokerConnectConfiguration != null && this.brokerConnectConfiguration.getConnectionElements() != null) {
                for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                    AMQPBrokerConnectionAddressType elementType = connectionElement.getType();
                    if (elementType == AMQPBrokerConnectionAddressType.MIRROR) {
                        this.installMirrorController((AMQPMirrorBrokerConnectionElement)connectionElement, this.server);
                        continue;
                    }
                    if (elementType != AMQPBrokerConnectionAddressType.FEDERATION) continue;
                    this.installFederation((AMQPFederatedBrokerConnectionElement)connectionElement, this.server);
                }
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
            return;
        }
        this.connectExecutor.execute(() -> this.doConnect());
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    public NettyConnection getConnection() {
        return this.connection;
    }

    public void afterCreateQueue(Queue queue) {
        this.connectExecutor.execute(() -> {
            for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                this.validateMatching(queue, connectionElement);
            }
        });
    }

    public void validateMatching(Queue queue, AMQPBrokerConnectionElement connectionElement) {
        if (connectionElement.getType() != AMQPBrokerConnectionAddressType.MIRROR && connectionElement.getType() != AMQPBrokerConnectionAddressType.FEDERATION) {
            if (connectionElement.getQueueName() != null) {
                if (queue.getName().equals((Object)connectionElement.getQueueName())) {
                    this.createLink(queue, connectionElement);
                }
            } else if (connectionElement.match(queue.getAddress(), this.server.getConfiguration().getWildcardConfiguration())) {
                this.createLink(queue, connectionElement);
            }
        }
    }

    public void createLink(Queue queue, AMQPBrokerConnectionElement connectionElement) {
        if (connectionElement.getType() == AMQPBrokerConnectionAddressType.PEER) {
            Symbol[] dispatchCapability = new Symbol[]{AMQPMirrorControllerSource.QPID_DISPATCH_WAYPOINT_CAPABILITY};
            this.connectSender(queue, queue.getAddress().toString(), null, null, null, null, dispatchCapability);
            this.connectReceiver(this.protonRemotingConnection, this.session, this.sessionContext, queue, dispatchCapability);
        } else {
            if (connectionElement.getType() == AMQPBrokerConnectionAddressType.SENDER) {
                this.connectSender(queue, queue.getAddress().toString(), null, null, null, null, null);
            }
            if (connectionElement.getType() == AMQPBrokerConnectionAddressType.RECEIVER) {
                this.connectReceiver(this.protonRemotingConnection, this.session, this.sessionContext, queue, new Symbol[0]);
            }
        }
    }

    SimpleString getMirrorSNF(AMQPMirrorBrokerConnectionElement mirrorElement) {
        SimpleString snf = mirrorElement.getMirrorSNF();
        if (snf == null) {
            snf = SimpleString.toSimpleString((String)ProtonProtocolManager.getMirrorAddress(this.brokerConnectConfiguration.getName()));
            mirrorElement.setMirrorSNF(snf);
        }
        return snf;
    }

    public AMQPBrokerConnection addLinkClosedInterceptor(String id, Predicate<Link> interceptor) {
        this.linkClosedInterceptors.put(id, interceptor);
        return this;
    }

    public AMQPBrokerConnection removeLinkClosedInterceptor(String id) {
        this.linkClosedInterceptors.remove(id);
        return this;
    }

    private void linkClosed(Link link) {
        for (Map.Entry<String, Predicate<Link>> interceptor : this.linkClosedInterceptors.entrySet()) {
            if (!interceptor.getValue().test(link)) continue;
            logger.trace("Remote link[{}] close intercepted and handled by interceptor: {}", (Object)link.getName(), (Object)interceptor.getKey());
            return;
        }
        if (link.getLocalState() == EndpointState.ACTIVE) {
            this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionRemoteLinkClosed()), this.lastRetryCounter);
        }
    }

    private void doConnect() {
        try {
            this.connecting = true;
            List configurationList = this.brokerConnectConfiguration.getTransportConfigurations();
            TransportConfiguration tpConfig = (TransportConfiguration)configurationList.get(this.retryCounter % configurationList.size());
            String hostOnParameter = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", (Map)tpConfig.getParams());
            int portOnParameter = ConfigurationHelper.getIntProperty((String)"port", (int)61616, (Map)tpConfig.getParams());
            this.host = hostOnParameter;
            this.port = portOnParameter;
            this.connection = this.bridgesConnector.createConnection(null, hostOnParameter, portOnParameter);
            if (this.connection == null) {
                this.retryConnection();
                return;
            }
            this.lastRetryCounter = this.retryCounter;
            this.retryCounter = 0;
            this.reconnectFuture = null;
            this.senders.clear();
            this.receivers.clear();
            SaslFactory saslFactory = new SaslFactory(this.connection, this.brokerConnectConfiguration);
            ConnectionEntry entry = this.protonProtocolManager.createOutgoingConnectionEntry((Connection)this.connection, saslFactory);
            this.server.getRemotingService().addConnectionEntry((Connection)this.connection, entry);
            this.protonRemotingConnection = (ActiveMQProtonRemotingConnection)entry.connection;
            this.protonRemotingConnection.getAmqpConnection().addLinkRemoteCloseListener(this.getName(), this::linkClosed);
            this.connection.getChannel().pipeline().addLast(new ChannelHandler[]{new AMQPBrokerConnectionChannelHandler(this.bridgesConnector.getChannelGroup(), this.protonRemotingConnection.getAmqpConnection().getHandler(), this, (Executor)this.server.getExecutorFactory().getExecutor())});
            this.session = this.protonRemotingConnection.getAmqpConnection().getHandler().getConnection().session();
            this.sessionContext = this.protonRemotingConnection.getAmqpConnection().getSessionExtension(this.session);
            this.protonRemotingConnection.getAmqpConnection().runLater(() -> {
                this.protonRemotingConnection.getAmqpConnection().open();
                this.session.open();
                this.protonRemotingConnection.getAmqpConnection().flush();
            });
            if (this.brokerConnectConfiguration.getConnectionElements() != null) {
                Stream bindingStream = this.server.getPostOffice().getAllBindings();
                bindingStream.forEach(binding -> {
                    if (binding instanceof QueueBinding) {
                        Queue queue = ((QueueBinding)binding).getQueue();
                        for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                            this.validateMatching(queue, connectionElement);
                        }
                    }
                });
                for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                    if (connectionElement.getType() == AMQPBrokerConnectionAddressType.MIRROR) {
                        AMQPMirrorBrokerConnectionElement replica = (AMQPMirrorBrokerConnectionElement)connectionElement;
                        Queue queue = this.server.locateQueue(this.getMirrorSNF(replica));
                        this.connectSender(queue, queue.getName().toString(), this.mirrorControllerSource::setLink, r -> AMQPMirrorControllerSource.validateProtocolData(this.protonProtocolManager.getReferenceIDSupplier(), r, this.getMirrorSNF(replica)), this.server.getNodeID().toString(), new Symbol[]{AMQPMirrorControllerSource.MIRROR_CAPABILITY}, null);
                        continue;
                    }
                    if (connectionElement.getType() != AMQPBrokerConnectionAddressType.FEDERATION) continue;
                    this.brokerFederation.handleConnectionRestored(this.protonRemotingConnection.getAmqpConnection(), this.sessionContext);
                }
            }
            this.protonRemotingConnection.getAmqpConnection().flush();
            this.bridgeManager.connected(this.connection, this);
            ActiveMQAMQPProtocolLogger.LOGGER.successReconnect(this.brokerConnectConfiguration.getName(), this.host + ":" + this.port, this.lastRetryCounter);
            this.connecting = false;
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    public void retryConnection() {
        this.lastRetryCounter = this.retryCounter;
        if (this.bridgeManager.isStarted() && this.started) {
            if (this.brokerConnectConfiguration.getReconnectAttempts() < 0 || this.retryCounter < this.brokerConnectConfiguration.getReconnectAttempts()) {
                ++this.retryCounter;
                ActiveMQAMQPProtocolLogger.LOGGER.retryConnection(this.brokerConnectConfiguration.getName(), this.host + ":" + this.port, this.retryCounter, this.brokerConnectConfiguration.getReconnectAttempts());
                if (logger.isDebugEnabled()) {
                    logger.debug("Reconnecting in {}, this is the {} of {}", new Object[]{this.brokerConnectConfiguration.getRetryInterval(), this.retryCounter, this.brokerConnectConfiguration.getReconnectAttempts()});
                }
                this.reconnectFuture = this.scheduledExecutorService.schedule(() -> this.connectExecutor.execute(() -> this.doConnect()), (long)this.brokerConnectConfiguration.getRetryInterval(), TimeUnit.MILLISECONDS);
            } else {
                this.retryCounter = 0;
                this.started = false;
                this.connecting = false;
                ActiveMQAMQPProtocolLogger.LOGGER.retryConnectionFailed(this.brokerConnectConfiguration.getName(), this.host + ":" + this.port, this.lastRetryCounter);
                if (logger.isDebugEnabled()) {
                    logger.debug("no more reconnections as the retry counter reached {} out of {}", (Object)this.retryCounter, (Object)this.brokerConnectConfiguration.getReconnectAttempts());
                }
            }
        }
    }

    private static void uninstallMirrorController(AMQPMirrorBrokerConnectionElement replicaConfig, ActiveMQServer server) {
    }

    private Queue installMirrorController(AMQPMirrorBrokerConnectionElement replicaConfig, ActiveMQServer server) throws Exception {
        AMQPMirrorControllerSource newPartition;
        AddressInfo addressInfo;
        MirrorController currentMirrorController = server.getMirrorController();
        if (currentMirrorController != null && currentMirrorController instanceof AMQPMirrorControllerSource) {
            Queue queue = AMQPBrokerConnection.checkCurrentMirror(this, (AMQPMirrorControllerSource)currentMirrorController);
            if (queue != null) {
                return queue;
            }
        } else if (currentMirrorController != null && currentMirrorController instanceof AMQPMirrorControllerAggregation) {
            AMQPMirrorControllerAggregation aggregation = (AMQPMirrorControllerAggregation)currentMirrorController;
            for (AMQPMirrorControllerSource source : aggregation.getPartitions()) {
                Queue queue = AMQPBrokerConnection.checkCurrentMirror(this, source);
                if (queue == null) continue;
                return queue;
            }
        }
        if ((addressInfo = server.getAddressInfo(this.getMirrorSNF(replicaConfig))) == null) {
            addressInfo = new AddressInfo(this.getMirrorSNF(replicaConfig)).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false).setTemporary(!replicaConfig.isDurable()).setInternal(true);
            server.addAddressInfo(addressInfo);
        }
        if (addressInfo.getRoutingType() != RoutingType.ANYCAST) {
            throw new IllegalArgumentException(addressInfo.getName() + " has " + addressInfo.getRoutingType() + " instead of ANYCAST");
        }
        Queue mirrorControlQueue = server.locateQueue(this.getMirrorSNF(replicaConfig));
        if (mirrorControlQueue == null) {
            mirrorControlQueue = server.createQueue(new QueueConfiguration(this.getMirrorSNF(replicaConfig)).setAddress(this.getMirrorSNF(replicaConfig)).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(replicaConfig.isDurable())).setInternal(Boolean.valueOf(true)), true);
        }
        logger.debug("Mirror queue {}", (Object)mirrorControlQueue.getName());
        mirrorControlQueue.setMirrorController(true);
        QueueBinding snfReplicaQueueBinding = (QueueBinding)server.getPostOffice().getBinding(this.getMirrorSNF(replicaConfig));
        if (snfReplicaQueueBinding == null) {
            logger.warn("Queue does not exist even after creation! {}", (Object)replicaConfig);
            throw new IllegalAccessException("Cannot start replica");
        }
        Queue snfQueue = snfReplicaQueueBinding.getQueue();
        if (!snfQueue.getAddress().equals((Object)this.getMirrorSNF(replicaConfig))) {
            logger.warn("Queue {} belong to a different address ({}), while we expected it to be {}", new Object[]{snfQueue, snfQueue.getAddress(), addressInfo.getName()});
            throw new IllegalAccessException("Cannot start replica");
        }
        this.mirrorControllerSource = newPartition = new AMQPMirrorControllerSource(this.protonProtocolManager, snfQueue, server, replicaConfig, this);
        server.scanAddresses((MirrorController)newPartition);
        if (currentMirrorController == null) {
            server.installMirrorController((MirrorController)newPartition);
        } else {
            if (currentMirrorController instanceof AMQPMirrorControllerSource) {
                AMQPMirrorControllerAggregation remoteAggregation = new AMQPMirrorControllerAggregation();
                remoteAggregation.addPartition((AMQPMirrorControllerSource)currentMirrorController);
                currentMirrorController = remoteAggregation;
                server.installMirrorController((MirrorController)remoteAggregation);
            }
            ((AMQPMirrorControllerAggregation)currentMirrorController).addPartition(newPartition);
        }
        return snfQueue;
    }

    private static Queue checkCurrentMirror(AMQPBrokerConnection brokerConnection, AMQPMirrorControllerSource currentMirrorController) {
        AMQPMirrorControllerSource source = currentMirrorController;
        if (source.getBrokerConnection() == brokerConnection) {
            return source.getSnfQueue();
        }
        return null;
    }

    private void installFederation(AMQPFederatedBrokerConnectionElement connectionElement, ActiveMQServer server) throws Exception {
        Set remoteQueuePolicies;
        Set remoteAddressPolicies;
        Set localQueuePolicies;
        AMQPFederationSource federation = new AMQPFederationSource(connectionElement.getName(), connectionElement.getProperties(), this);
        Set localAddressPolicies = connectionElement.getLocalAddressPolicies();
        if (!localAddressPolicies.isEmpty()) {
            for (AMQPFederationAddressPolicyElement policy : localAddressPolicies) {
                federation.addAddressMatchPolicy(AMQPFederationPolicySupport.create(policy, federation.getWildcardConfiguration()));
            }
        }
        if (!(localQueuePolicies = connectionElement.getLocalQueuePolicies()).isEmpty()) {
            for (AMQPFederationQueuePolicyElement policy : localQueuePolicies) {
                federation.addQueueMatchPolicy(AMQPFederationPolicySupport.create(policy, federation.getWildcardConfiguration()));
            }
        }
        if (!(remoteAddressPolicies = connectionElement.getRemoteAddressPolicies()).isEmpty()) {
            for (AMQPFederationAddressPolicyElement policy : remoteAddressPolicies) {
                federation.addRemoteAddressMatchPolicy(AMQPFederationPolicySupport.create(policy, federation.getWildcardConfiguration()));
            }
        }
        if (!(remoteQueuePolicies = connectionElement.getRemoteQueuePolicies()).isEmpty()) {
            for (AMQPFederationQueuePolicyElement policy : remoteQueuePolicies) {
                federation.addRemoteQueueMatchPolicy(AMQPFederationPolicySupport.create(policy, federation.getWildcardConfiguration()));
            }
        }
        this.brokerFederation = federation;
        this.brokerFederation.start();
    }

    private void connectReceiver(ActiveMQProtonRemotingConnection protonRemotingConnection, Session session, AMQPSessionContext sessionContext, Queue queue, Symbol ... capabilities) {
        logger.debug("Connecting inbound for {}", (Object)queue);
        if (session == null) {
            logger.debug("session is null");
            return;
        }
        protonRemotingConnection.getAmqpConnection().runLater(() -> {
            if (this.receivers.contains(queue)) {
                logger.debug("Receiver for queue {} already exists, just giving up", (Object)queue);
                return;
            }
            this.receivers.add(queue);
            Receiver receiver = session.receiver(queue.getAddress().toString() + ":" + UUIDGenerator.getInstance().generateStringUUID());
            receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
            receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            Target target = new Target();
            target.setAddress(queue.getAddress().toString());
            receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
            Source source = new Source();
            source.setAddress(queue.getAddress().toString());
            receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
            if (capabilities != null) {
                source.setCapabilities(capabilities);
            }
            receiver.open();
            protonRemotingConnection.getAmqpConnection().flush();
            try {
                sessionContext.addReceiver(receiver);
            }
            catch (Exception e) {
                this.error(e);
            }
        });
    }

    private void connectSender(Queue queue, String targetName, java.util.function.Consumer<Sender> senderConsumer, java.util.function.Consumer<? super MessageReference> beforeDeliver, String brokerID, Symbol[] desiredCapabilities, Symbol[] targetCapabilities) {
        logger.debug("Connecting outbound for {}", (Object)queue);
        if (this.session == null) {
            logger.debug("Session is null");
            return;
        }
        this.protonRemotingConnection.getAmqpConnection().runLater(() -> {
            try {
                if (this.senders.contains(queue)) {
                    logger.debug("Sender for queue {} already exists, just giving up", (Object)queue);
                    return;
                }
                this.senders.add(queue);
                Sender sender = this.session.sender(targetName + ":" + UUIDGenerator.getInstance().generateStringUUID());
                sender.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                Target target = new Target();
                target.setAddress(targetName);
                if (targetCapabilities != null) {
                    target.setCapabilities(targetCapabilities);
                }
                sender.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
                Source source = new Source();
                source.setAddress(queue.getAddress().toString());
                sender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
                if (brokerID != null) {
                    HashMap<Symbol, String> mapProperties = new HashMap<Symbol, String>(1, 1.0f);
                    mapProperties.put(AMQPMirrorControllerSource.BROKER_ID, brokerID);
                    sender.setProperties(mapProperties);
                }
                if (desiredCapabilities != null) {
                    sender.setDesiredCapabilities(desiredCapabilities);
                }
                AMQPOutgoingController outgoingInitializer = new AMQPOutgoingController(queue, sender, this.sessionContext.getSessionSPI());
                sender.open();
                AtomicBoolean cancelled = new AtomicBoolean(false);
                ScheduledFuture<?> futureTimeout = this.bridgesConnector.getConnectTimeoutMillis() > 0 ? this.server.getScheduledPool().schedule(() -> {
                    cancelled.set(true);
                    this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionTimeout()), this.lastRetryCounter);
                }, (long)this.bridgesConnector.getConnectTimeoutMillis(), TimeUnit.MILLISECONDS) : null;
                sender.attachments().set(AmqpSupport.AMQP_LINK_INITIALIZER_KEY, Runnable.class, () -> {
                    ProtonServerSenderContext senderContext = new ProtonServerSenderContext(this.protonRemotingConnection.getAmqpConnection(), sender, this.sessionContext, this.sessionContext.getSessionSPI(), outgoingInitializer).setBeforeDelivery(beforeDeliver);
                    try {
                        if (!cancelled.get()) {
                            if (futureTimeout != null) {
                                futureTimeout.cancel(false);
                            }
                            if (sender.getRemoteTarget() == null) {
                                this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.senderLinkRefused(sender.getTarget().getAddress())), this.lastRetryCounter);
                                return;
                            }
                            if (desiredCapabilities != null && !AmqpSupport.verifyOfferedCapabilities((Link)sender, desiredCapabilities)) {
                                this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.missingOfferedCapability(Arrays.toString(desiredCapabilities))), this.lastRetryCounter);
                                return;
                            }
                            if (brokerID != null) {
                                if (sender.getRemoteProperties() == null || !sender.getRemoteProperties().containsKey(AMQPMirrorControllerSource.BROKER_ID)) {
                                    this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.missingBrokerID()), this.lastRetryCounter);
                                    return;
                                }
                                Object remoteBrokerID = sender.getRemoteProperties().get(AMQPMirrorControllerSource.BROKER_ID);
                                if (remoteBrokerID.equals(brokerID)) {
                                    this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionMirrorItself()), this.lastRetryCounter);
                                    return;
                                }
                            }
                            this.sessionContext.addSender(sender, senderContext);
                            if (senderConsumer != null) {
                                senderConsumer.accept(sender);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.error(e);
                    }
                });
            }
            catch (Exception e) {
                this.error(e);
            }
            this.protonRemotingConnection.getAmqpConnection().flush();
        });
    }

    public void error(Throwable e) {
        this.error(e, 0);
    }

    public void runtimeError(Throwable error) {
        this.error(error, 0);
    }

    public void connectError(Throwable error) {
        this.error(error, this.lastRetryCounter);
    }

    protected void error(Throwable e, int retryCounter) {
        this.retryCounter = retryCounter;
        this.connecting = false;
        logger.warn(e.getMessage(), e);
        this.redoConnection();
    }

    public void disconnect() throws Exception {
        this.redoConnection();
    }

    public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
    }

    public void connectionDestroyed(Object connectionID) {
        this.server.getRemotingService().removeConnection(connectionID);
        this.redoConnection();
    }

    public void connectionException(Object connectionID, ActiveMQException me) {
        this.redoConnection();
    }

    private void redoConnection() {
        if (this.protonRemotingConnection != null) {
            this.protonRemotingConnection.getAmqpConnection().clearLinkRemoteCloseListeners();
        }
        if (this.brokerFederation != null) {
            try {
                this.brokerFederation.handleConnectionDropped();
            }
            catch (ActiveMQException e) {
                logger.debug("Broker Federation on connection {} threw an error on stop before connection attempt", (Object)this.getName());
            }
        }
        this.connectExecutor.execute(() -> {
            if (this.connecting) {
                logger.debug("Broker connection {} was already in retry mode, exception or retry not captured", (Object)this.getName());
                return;
            }
            this.connecting = true;
            try {
                if (this.protonRemotingConnection != null) {
                    this.protonRemotingConnection.fail(new ActiveMQException("Connection being recreated"));
                    this.connection = null;
                    this.protonRemotingConnection = null;
                }
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
            }
            this.retryConnection();
        });
    }

    public void connectionReadyForWrites(Object connectionID, boolean ready) {
        this.protonRemotingConnection.flush();
    }

    private static final class SaslFactory
    implements ClientSASLFactory {
        private final NettyConnection connection;
        private final AMQPBrokerConnectConfiguration brokerConnectConfiguration;

        SaslFactory(NettyConnection connection, AMQPBrokerConnectConfiguration brokerConnectConfiguration) {
            this.connection = connection;
            this.brokerConnectConfiguration = brokerConnectConfiguration;
        }

        @Override
        public ClientSASL chooseMechanism(String[] offeredMechanims) {
            List<Object> availableMechanisms;
            List<Object> list = availableMechanisms = offeredMechanims == null ? Collections.emptyList() : Arrays.asList(offeredMechanims);
            if (availableMechanisms.contains(AMQPBrokerConnection.EXTERNAL) && ExternalSASLMechanism.isApplicable(this.connection)) {
                return new ExternalSASLMechanism();
            }
            if (SCRAMClientSASL.isApplicable(this.brokerConnectConfiguration.getUser(), this.brokerConnectConfiguration.getPassword())) {
                for (SCRAM scram : SCRAM.values()) {
                    if (!availableMechanisms.contains(scram.getName())) continue;
                    return new SCRAMClientSASL(scram, this.brokerConnectConfiguration.getUser(), this.brokerConnectConfiguration.getPassword());
                }
            }
            if (availableMechanisms.contains(AMQPBrokerConnection.PLAIN) && PlainSASLMechanism.isApplicable(this.brokerConnectConfiguration.getUser(), this.brokerConnectConfiguration.getPassword())) {
                return new PlainSASLMechanism(this.brokerConnectConfiguration.getUser(), this.brokerConnectConfiguration.getPassword());
            }
            if (availableMechanisms.contains(AMQPBrokerConnection.ANONYMOUS)) {
                return new AnonymousSASLMechanism();
            }
            return null;
        }
    }

    private static class ExternalSASLMechanism
    implements ClientSASL {
        private ExternalSASLMechanism() {
        }

        @Override
        public String getName() {
            return AMQPBrokerConnection.EXTERNAL;
        }

        @Override
        public byte[] getInitialResponse() {
            return EMPTY;
        }

        @Override
        public byte[] getResponse(byte[] challenge) {
            return EMPTY;
        }

        public static boolean isApplicable(NettyConnection connection) {
            return CertificateUtil.getLocalPrincipalFromConnection((NettyConnection)connection) != null;
        }
    }

    private static class AnonymousSASLMechanism
    implements ClientSASL {
        private AnonymousSASLMechanism() {
        }

        @Override
        public String getName() {
            return AMQPBrokerConnection.ANONYMOUS;
        }

        @Override
        public byte[] getInitialResponse() {
            return EMPTY;
        }

        @Override
        public byte[] getResponse(byte[] challenge) {
            return EMPTY;
        }
    }

    private static class PlainSASLMechanism
    implements ClientSASL {
        private final byte[] initialResponse;

        PlainSASLMechanism(String username, String password) {
            byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
            byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
            byte[] encoded = new byte[usernameBytes.length + passwordBytes.length + 2];
            System.arraycopy(usernameBytes, 0, encoded, 1, usernameBytes.length);
            System.arraycopy(passwordBytes, 0, encoded, usernameBytes.length + 2, passwordBytes.length);
            this.initialResponse = encoded;
        }

        @Override
        public String getName() {
            return AMQPBrokerConnection.PLAIN;
        }

        @Override
        public byte[] getInitialResponse() {
            return this.initialResponse;
        }

        @Override
        public byte[] getResponse(byte[] challenge) {
            return EMPTY;
        }

        public static boolean isApplicable(String username, String password) {
            return username != null && username.length() > 0 && password != null && password.length() > 0;
        }
    }

    private class AMQPOutgoingController
    implements SenderController {
        final Queue queue;
        final Sender sender;
        final AMQPSessionCallback sessionSPI;

        AMQPOutgoingController(Queue queue, Sender sender, AMQPSessionCallback sessionSPI) {
            this.queue = queue;
            this.sessionSPI = sessionSPI;
            this.sender = sender;
        }

        @Override
        public Consumer init(ProtonServerSenderContext senderContext) throws Exception {
            SimpleString queueName = this.queue.getName();
            return (Consumer)this.sessionSPI.createSender(senderContext, queueName, null, false);
        }

        @Override
        public void close() throws Exception {
        }
    }
}

