/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.hotrod;

import java.time.Duration;
import java.util.function.Function;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;

public class RemoteCacheMutatorFactory<K, V>
implements MutatorFactory<K, V> {
    private final RemoteCache<K, V> cache;
    private final Flag[] flags;
    private final Function<V, Duration> maxIdle;

    public RemoteCacheMutatorFactory(RemoteCache<K, V> cache, Flag[] flags) {
        this(cache, flags, null);
    }

    public RemoteCacheMutatorFactory(RemoteCache<K, V> cache, Flag[] flags, Function<V, Duration> maxIdle) {
        this.cache = cache;
        this.flags = flags;
        this.maxIdle = maxIdle;
    }

    public Mutator createMutator(K key, V value) {
        return this.maxIdle != null ? new RemoteCacheEntryMutator<K, V>(this.cache, this.flags, key, value, () -> this.maxIdle.apply(value)) : new RemoteCacheEntryMutator<K, V>(this.cache, this.flags, key, value);
    }
}

