/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.security.sasl;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.security.DomainServerCredential;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.sasl.util.SaslWrapper;
import org.wildfly.security.sasl.util.StringPrep;

final class DomainServerSaslClient
implements SaslClient,
SaslWrapper {
    private final CallbackHandler cbh;
    private boolean complete = false;

    DomainServerSaslClient(CallbackHandler cbh) {
        this.cbh = cbh;
    }

    @Override
    public String getMechanismName() {
        return "JBOSS-DOMAIN-SERVER";
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        String token;
        if (this.complete) {
            throw ServerLogger.AS_ROOT_LOGGER.mechMessageAfterComplete().toSaslException();
        }
        this.complete = true;
        if (challenge.length > 0) {
            throw ServerLogger.AS_ROOT_LOGGER.mechInvalidMessageReceived().toSaslException();
        }
        NameCallback nameCallback = new NameCallback("Login name");
        CredentialCallback credentialCallback = new CredentialCallback(DomainServerCredential.class);
        try {
            this.cbh.handle(new Callback[]{nameCallback, credentialCallback});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw ServerLogger.AS_ROOT_LOGGER.mechCallbackHandlerFailedForUnknownReason(e).toSaslException();
        }
        String name = nameCallback.getName();
        if (name == null) {
            throw ServerLogger.AS_ROOT_LOGGER.mechNoLoginNameGiven().toSaslException();
        }
        DomainServerCredential credential = (DomainServerCredential)credentialCallback.getCredential(DomainServerCredential.class);
        String string = token = credential != null ? credential.getToken() : null;
        if (token == null) {
            throw ServerLogger.AS_ROOT_LOGGER.mechNoTokenGiven().toSaslException();
        }
        try {
            ByteStringBuilder b = new ByteStringBuilder();
            StringPrep.encode((String)name, (ByteStringBuilder)b, (long)16383L);
            b.append((byte)0);
            StringPrep.encode((String)token, (ByteStringBuilder)b, (long)16383L);
            ServerLogger.AS_ROOT_LOGGER.tracef("SASL Negotiation Completed", new Object[0]);
            return b.toArray();
        }
        catch (IllegalArgumentException ex) {
            throw ServerLogger.AS_ROOT_LOGGER.mechMalformedFields(ex).toSaslException();
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ServerLogger.AS_ROOT_LOGGER.mechNoSecurityLayer();
        }
        throw ServerLogger.AS_ROOT_LOGGER.mechAuthenticationNotComplete();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ServerLogger.AS_ROOT_LOGGER.mechNoSecurityLayer();
        }
        throw ServerLogger.AS_ROOT_LOGGER.mechAuthenticationNotComplete();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.complete) {
            return null;
        }
        throw ServerLogger.AS_ROOT_LOGGER.mechAuthenticationNotComplete();
    }

    @Override
    public void dispose() throws SaslException {
    }
}

