/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.broadcast;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Manager;
import org.wildfly.clustering.ee.cache.ConcurrentManager;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastCommandDispatcherFactory;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastReceiver;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ConcurrentBroadcastCommandDispatcherFactory
implements BroadcastCommandDispatcherFactory {
    private final Set<BroadcastReceiver> receivers = ConcurrentHashMap.newKeySet();
    private final Manager<Object, CommandDispatcher<?>> dispatchers = new ConcurrentManager(Functions.discardingConsumer(), new Consumer<CommandDispatcher<?>>(){

        @Override
        public void accept(CommandDispatcher<?> dispatcher) {
            ((ConcurrentCommandDispatcher)dispatcher).closeDispatcher();
        }
    });
    private final CommandDispatcherFactory factory;

    public ConcurrentBroadcastCommandDispatcherFactory(CommandDispatcherFactory factory) {
        this.factory = factory;
    }

    @Override
    public void receive(byte[] data) {
        for (BroadcastReceiver receiver : this.receivers) {
            receiver.receive(data);
        }
    }

    public Registration register(BroadcastReceiver receiver) {
        this.receivers.add(receiver);
        return () -> this.receivers.remove(receiver);
    }

    public Group getGroup() {
        return this.factory.getGroup();
    }

    public <C> CommandDispatcher<C> createCommandDispatcher(final Object id, final C context) {
        final CommandDispatcherFactory dispatcherFactory = this.factory;
        Function factory = new Function<Runnable, CommandDispatcher<?>>(){

            @Override
            public CommandDispatcher<C> apply(Runnable closeTask) {
                CommandDispatcher dispatcher = dispatcherFactory.createCommandDispatcher(id, context, WildFlySecurityManager.getClassLoaderPrivileged(this.getClass()));
                return new ConcurrentCommandDispatcher(dispatcher, closeTask);
            }
        };
        return (CommandDispatcher)this.dispatchers.apply(id, factory);
    }

    private static class ConcurrentCommandDispatcher<C>
    implements CommandDispatcher<C> {
        private final CommandDispatcher<C> dispatcher;
        private final Runnable closeTask;

        ConcurrentCommandDispatcher(CommandDispatcher<C> dispatcher, Runnable closeTask) {
            this.dispatcher = dispatcher;
            this.closeTask = closeTask;
        }

        void closeDispatcher() {
            this.dispatcher.close();
        }

        public C getContext() {
            return (C)this.dispatcher.getContext();
        }

        public <R> CompletionStage<R> executeOnMember(Command<R, ? super C> command, Node member) throws CommandDispatcherException {
            return this.dispatcher.executeOnMember(command, member);
        }

        public <R> Map<Node, CompletionStage<R>> executeOnGroup(Command<R, ? super C> command, Node ... excludedMembers) throws CommandDispatcherException {
            return this.dispatcher.executeOnGroup(command, excludedMembers);
        }

        public void close() {
            this.closeTask.run();
        }
    }
}

