/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.search.mapper.orm.loading.impl.AbstractHibernateOrmLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmSelectionEntityByNonIdPropertyLoader;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.spi.LoadingSessionContext;
import org.hibernate.search.mapper.orm.loading.spi.LoadingTypeContext;
import org.hibernate.search.mapper.orm.loading.spi.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public class HibernateOrmNonEntityIdPropertyEntityLoadingStrategy<E, I>
extends AbstractHibernateOrmLoadingStrategy<E, I> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EntityMappingType entityMappingType;
    private final TypeQueryFactory<E, I> queryFactory;
    private final String documentIdSourcePropertyName;
    private final ValueReadHandle<?> documentIdSourceHandle;

    public static <I> HibernateOrmEntityLoadingStrategy<?, ?> create(SessionFactoryImplementor sessionFactory, EntityMappingType entityMappingType, String documentIdSourcePropertyName, ValueReadHandle<I> documentIdSourceHandle) {
        TypeQueryFactory<?, ?> queryFactory = TypeQueryFactory.create(sessionFactory, entityMappingType, documentIdSourcePropertyName);
        return new HibernateOrmNonEntityIdPropertyEntityLoadingStrategy(sessionFactory, entityMappingType, queryFactory, documentIdSourcePropertyName, documentIdSourceHandle);
    }

    private HibernateOrmNonEntityIdPropertyEntityLoadingStrategy(SessionFactoryImplementor sessionFactory, EntityMappingType entityMappingType, TypeQueryFactory<E, I> queryFactory, String documentIdSourcePropertyName, ValueReadHandle<I> documentIdSourceHandle) {
        super(sessionFactory, entityMappingType, queryFactory);
        this.entityMappingType = entityMappingType;
        this.queryFactory = queryFactory;
        this.documentIdSourcePropertyName = documentIdSourcePropertyName;
        this.documentIdSourceHandle = documentIdSourceHandle;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        HibernateOrmNonEntityIdPropertyEntityLoadingStrategy other = (HibernateOrmNonEntityIdPropertyEntityLoadingStrategy)obj;
        return this.entityMappingType.equals(other.entityMappingType) && this.documentIdSourcePropertyName.equals(other.documentIdSourcePropertyName) && this.documentIdSourceHandle.equals(other.documentIdSourceHandle);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityMappingType, this.documentIdSourcePropertyName, this.documentIdSourceHandle);
    }

    @Override
    public <E2> PojoSelectionEntityLoader<E2> createLoader(Set<LoadingTypeContext<? extends E2>> targetEntityTypeContexts, LoadingSessionContext sessionContext, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
        if (targetEntityTypeContexts.size() != 1) {
            throw this.multipleTypesException(targetEntityTypeContexts);
        }
        return this.doCreate(targetEntityTypeContexts.iterator().next(), sessionContext, cacheLookupStrategy, loadingOptions);
    }

    private <E2> PojoSelectionEntityLoader<E2> doCreate(LoadingTypeContext<?> targetEntityTypeContext, LoadingSessionContext sessionContext, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
        if (!this.entityMappingType.equals(targetEntityTypeContext.entityMappingType())) {
            throw this.invalidTypeException(targetEntityTypeContext.entityMappingType());
        }
        HibernateOrmSelectionEntityByNonIdPropertyLoader result = new HibernateOrmSelectionEntityByNonIdPropertyLoader(this.entityMappingType, targetEntityTypeContext, this.queryFactory, this.documentIdSourcePropertyName, this.documentIdSourceHandle, sessionContext, loadingOptions);
        if (!EntityLoadingCacheLookupStrategy.SKIP.equals((Object)cacheLookupStrategy)) {
            log.skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(targetEntityTypeContext.jpaEntityName(), cacheLookupStrategy);
        }
        return result;
    }

    private AssertionFailure invalidTypeException(EntityMappingType otherEntityMappingType) {
        throw new AssertionFailure("Attempt to use a criteria-based entity loader with an unexpected target entity type. Expected entity name: " + this.entityMappingType.getEntityName() + " Targeted entity name: " + otherEntityMappingType.getEntityName());
    }

    private AssertionFailure multipleTypesException(Set<? extends LoadingTypeContext<?>> targetEntityTypeContexts) {
        return new AssertionFailure("Attempt to use a criteria-based entity loader with multiple target entity types. Expected entity name: " + this.entityMappingType.getEntityName() + " Targeted entity names: " + targetEntityTypeContexts.stream().map(LoadingTypeContext::entityMappingType).map(EntityMappingType::getEntityName).collect(Collectors.toList()));
    }
}

