/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.discovery.impl.AggregateDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.extension.discovery.AggregateDiscoveryProviderRegistrar;
import org.wildfly.extension.discovery.DiscoveryProviderRegistrar;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class AggregateDiscoveryProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        List providers = AggregateDiscoveryProviderRegistrar.PROVIDER_NAMES.unwrap((ExpressionResolver)context, model);
        final ArrayList<ServiceDependency> dependencies = new ArrayList<ServiceDependency>(providers.size());
        for (String provider : providers) {
            dependencies.add(ServiceDependency.on(DiscoveryProviderRegistrar.DISCOVERY_PROVIDER_DESCRIPTOR, (String)provider));
        }
        Supplier<DiscoveryProvider> factory = new Supplier<DiscoveryProvider>(){

            @Override
            public DiscoveryProvider get() {
                return new AggregateDiscoveryProvider((DiscoveryProvider[])dependencies.stream().map(Supplier::get).toArray(DiscoveryProvider[]::new));
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(DiscoveryProviderRegistrar.DISCOVERY_PROVIDER_CAPABILITY, (Supplier)factory).requires(dependencies)).build();
    }
}

