/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.impl.StaticDiscoveryProvider;
import org.wildfly.extension.discovery.DiscoveryProviderRegistrar;
import org.wildfly.extension.discovery.Messages;
import org.wildfly.extension.discovery.StaticDiscoveryProviderRegistrar;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class StaticDiscoveryProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        List services = StaticDiscoveryProviderRegistrar.SERVICES.resolveModelAttribute(context, model).asListOrEmpty();
        ArrayList<ServiceURL> serviceURLs = new ArrayList<ServiceURL>(services.size());
        for (ModelNode service : services) {
            String uriSchemeAuthority;
            String abstractTypeAuthority;
            ServiceURL.Builder builder = new ServiceURL.Builder();
            builder.setUri(URI.create(StaticDiscoveryProviderRegistrar.URI.resolveModelAttribute(context, service).asString()));
            String abstractType = StaticDiscoveryProviderRegistrar.ABSTRACT_TYPE.resolveModelAttribute(context, service).asStringOrNull();
            if (abstractType != null) {
                builder.setAbstractType(abstractType);
            }
            if ((abstractTypeAuthority = StaticDiscoveryProviderRegistrar.ABSTRACT_TYPE_AUTHORITY.resolveModelAttribute(context, service).asStringOrNull()) != null) {
                builder.setAbstractTypeAuthority(abstractTypeAuthority);
            }
            if ((uriSchemeAuthority = StaticDiscoveryProviderRegistrar.URI_SCHEME_AUTHORITY.resolveModelAttribute(context, service).asStringOrNull()) != null) {
                builder.setUriSchemeAuthority(uriSchemeAuthority);
            }
            for (ModelNode attribute : StaticDiscoveryProviderRegistrar.SERVICE_ATTRIBUTES.resolveModelAttribute(context, service).asListOrEmpty()) {
                String name = StaticDiscoveryProviderRegistrar.NAME.resolveModelAttribute(context, attribute).asString();
                String value = StaticDiscoveryProviderRegistrar.VALUE.resolveModelAttribute(context, attribute).asStringOrNull();
                if (value != null) {
                    builder.addAttribute(name, AttributeValue.fromString((String)value));
                    continue;
                }
                builder.addAttribute(name);
            }
            ServiceURL serviceURL = builder.create();
            Messages.log.tracef("Adding service URL %s", serviceURL);
            serviceURLs.add(serviceURL);
        }
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(DiscoveryProviderRegistrar.DISCOVERY_PROVIDER_CAPABILITY, (Object)new StaticDiscoveryProvider(serviceURLs)).build();
    }
}

