/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.vectorization;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.lucene.internal.vectorization.DefaultVectorizationProvider;
import org.apache.lucene.internal.vectorization.VectorUtilSupport;
import org.apache.lucene.util.SuppressForbidden;

public abstract class VectorizationProvider {
    private static final Logger LOG = Logger.getLogger(VectorizationProvider.class.getName());
    private static final Runtime.Version VERSION_JDK8301190_FIXED = Runtime.Version.parse("20.0.2");
    private static final Set<String> VALID_CALLERS = Set.of("org.apache.lucene.util.VectorUtil");

    public static VectorizationProvider getInstance() {
        VectorizationProvider.ensureCaller();
        return Objects.requireNonNull(Holder.INSTANCE, "call to getInstance() from subclass of VectorizationProvider");
    }

    VectorizationProvider() {
    }

    public abstract VectorUtilSupport getVectorUtilSupport();

    static VectorizationProvider lookup(boolean testMode) {
        int runtimeVersion = Runtime.version().feature();
        if (runtimeVersion >= 20 && runtimeVersion <= 21) {
            if (VectorizationProvider.isAffectedByJDK8301190()) {
                LOG.warning("Java runtime is using a buggy default locale; Java vector incubator API can't be enabled: " + Locale.getDefault());
                return new DefaultVectorizationProvider();
            }
            if (!VectorizationProvider.vectorModulePresentAndReadable()) {
                LOG.warning("Java vector incubator module is not readable. For optimal vector performance, pass '--add-modules jdk.incubator.vector' to enable Vector API.");
                return new DefaultVectorizationProvider();
            }
            if (!testMode && VectorizationProvider.isClientVM()) {
                LOG.warning("C2 compiler is disabled; Java vector incubator API can't be enabled");
                return new DefaultVectorizationProvider();
            }
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Class<?> cls = lookup.findClass("org.apache.lucene.internal.vectorization.PanamaVectorizationProvider");
                MethodHandle constr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE, Boolean.TYPE));
                try {
                    return constr.invoke(testMode);
                }
                catch (UnsupportedOperationException uoe) {
                    LOG.warning("Java vector incubator API was not enabled. " + uoe.getMessage());
                    return new DefaultVectorizationProvider();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new AssertionError((Object)th);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new LinkageError("PanamaVectorizationProvider is missing correctly typed constructor", e);
            }
            catch (ClassNotFoundException cnfe) {
                throw new LinkageError("PanamaVectorizationProvider is missing in Lucene JAR file", cnfe);
            }
        }
        if (runtimeVersion >= 22) {
            LOG.warning("You are running with Java 22 or later. To make full use of the Vector API, please update Apache Lucene.");
        }
        return new DefaultVectorizationProvider();
    }

    private static boolean vectorModulePresentAndReadable() {
        Optional<Module> opt = ModuleLayer.boot().modules().stream().filter(m -> m.getName().equals("jdk.incubator.vector")).findFirst();
        if (opt.isPresent()) {
            VectorizationProvider.class.getModule().addReads(opt.get());
            return true;
        }
        return false;
    }

    private static boolean isAffectedByJDK8301190() {
        return VERSION_JDK8301190_FIXED.compareToIgnoreOptional(Runtime.version()) > 0 && !Objects.equals("I", "i".toUpperCase(Locale.getDefault()));
    }

    @SuppressForbidden(reason="security manager")
    private static boolean isClientVM() {
        try {
            PrivilegedAction<Boolean> action = () -> System.getProperty("java.vm.info", "").contains("emulated-client");
            return AccessController.doPrivileged(action);
        }
        catch (SecurityException e) {
            LOG.warning("SecurityManager denies permission to 'java.vm.info' system property, so state of C2 compiler can't be detected. In case of performance issues allow access to this property.");
            return false;
        }
    }

    private static void ensureCaller() {
        boolean validCaller = StackWalker.getInstance().walk(s -> s.skip(2L).limit(1L).map(StackWalker.StackFrame::getClassName).allMatch(VALID_CALLERS::contains));
        if (!validCaller) {
            throw new UnsupportedOperationException("VectorizationProvider is internal and can only be used by known Lucene classes.");
        }
    }

    private static final class Holder {
        static final VectorizationProvider INSTANCE = VectorizationProvider.lookup(false);

        private Holder() {
        }
    }
}

