/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import java.nio.ByteBuffer;
import org.apache.http.nio.ContentEncoder;

final class ByteBufferContentEncoder
implements ContentEncoder {
    private final ByteBuffer buffer;
    private boolean complete = false;

    ByteBufferContentEncoder(ByteBuffer buffer) {
        this.buffer = buffer;
        if (!buffer.hasArray()) {
            throw new IllegalArgumentException(this.getClass().getName() + " requires a ByteBuffer backed by an array.");
        }
    }

    public int write(ByteBuffer src) {
        int toWrite = Math.min(src.remaining(), this.buffer.remaining());
        src.get(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), toWrite);
        this.buffer.position(this.buffer.position() + toWrite);
        return toWrite;
    }

    public void complete() {
        this.complete = true;
    }

    public boolean isCompleted() {
        return this.complete;
    }
}

