/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.proxy;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.GssApiMechanisms;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.auth.AuthenticationHandler;
import org.eclipse.jgit.internal.transport.sshd.auth.BasicAuthentication;
import org.eclipse.jgit.internal.transport.sshd.auth.GssApiAuthentication;
import org.eclipse.jgit.internal.transport.sshd.proxy.AbstractClientProxyConnector;
import org.ietf.jgss.GSSContext;

public class Socks5ClientConnector
extends AbstractClientProxyConnector {
    private static final byte SOCKS_VERSION_5 = 5;
    private static final byte SOCKS_CMD_CONNECT = 1;
    private static final byte SOCKS_ADDRESS_IPv4 = 1;
    private static final byte SOCKS_ADDRESS_FQDN = 3;
    private static final byte SOCKS_ADDRESS_IPv6 = 4;
    private static final byte SOCKS_REPLY_SUCCESS = 0;
    private static final byte SOCKS_REPLY_FAILURE = 1;
    private static final byte SOCKS_REPLY_FORBIDDEN = 2;
    private static final byte SOCKS_REPLY_NETWORK_UNREACHABLE = 3;
    private static final byte SOCKS_REPLY_HOST_UNREACHABLE = 4;
    private static final byte SOCKS_REPLY_CONNECTION_REFUSED = 5;
    private static final byte SOCKS_REPLY_TTL_EXPIRED = 6;
    private static final byte SOCKS_REPLY_COMMAND_UNSUPPORTED = 7;
    private static final byte SOCKS_REPLY_ADDRESS_UNSUPPORTED = 8;
    private ProtocolState state = ProtocolState.NONE;
    private AuthenticationHandler<Buffer, Buffer> authenticator;
    private GSSContext context;
    private byte[] authenticationProposals;

    public Socks5ClientConnector(@NonNull InetSocketAddress proxyAddress, @NonNull InetSocketAddress remoteAddress) {
        this(proxyAddress, remoteAddress, null, null);
    }

    public Socks5ClientConnector(@NonNull InetSocketAddress proxyAddress, @NonNull InetSocketAddress remoteAddress, String proxyUser, char[] proxyPassword) {
        super(proxyAddress, remoteAddress, proxyUser, proxyPassword);
    }

    public void sendClientProxyMetadata(ClientSession sshSession) throws Exception {
        this.init(sshSession);
        IoSession session = sshSession.getIoSession();
        ByteArrayBuffer buffer = new ByteArrayBuffer(5, false);
        buffer.putByte((byte)5);
        this.context = Socks5ClientConnector.getGSSContext(this.remoteAddress);
        this.authenticationProposals = this.getAuthenticationProposals();
        buffer.putByte((byte)this.authenticationProposals.length);
        buffer.putRawBytes(this.authenticationProposals);
        this.state = ProtocolState.INIT;
        session.writeBuffer((Buffer)buffer).verify(this.getTimeout(), new CancelOption[0]);
    }

    private byte[] getAuthenticationProposals() {
        byte[] proposals = new byte[3];
        int i = 0;
        proposals[i++] = SocksAuthenticationMethod.ANONYMOUS.getValue();
        proposals[i++] = SocksAuthenticationMethod.PASSWORD.getValue();
        if (this.context != null) {
            proposals[i++] = SocksAuthenticationMethod.GSSAPI.getValue();
        }
        if (i == proposals.length) {
            return proposals;
        }
        byte[] result = new byte[i];
        System.arraycopy(proposals, 0, result, 0, i);
        return result;
    }

    private void sendConnectInfo(IoSession session) throws Exception {
        byte type;
        GssApiMechanisms.closeContextSilently(this.context);
        byte[] rawAddress = Socks5ClientConnector.getRawAddress(this.remoteAddress);
        byte[] remoteName = null;
        int length = 0;
        if (rawAddress == null) {
            remoteName = this.remoteAddress.getHostString().getBytes(StandardCharsets.US_ASCII);
            if (remoteName == null || remoteName.length == 0) {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksNoRemoteHostName, this.remoteAddress));
            }
            if (remoteName.length > 255) {
                throw new IOException(MessageFormat.format("Proxy host name too long for SOCKS (at most 255 characters): {0}", this.remoteAddress.getHostString()));
            }
            type = 3;
            length = remoteName.length + 1;
        } else {
            length = rawAddress.length;
            type = length == 4 ? (byte)1 : 4;
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(4 + length + 2, false);
        buffer.putByte((byte)5);
        buffer.putByte((byte)1);
        buffer.putByte((byte)0);
        buffer.putByte(type);
        if (remoteName != null) {
            buffer.putByte((byte)remoteName.length);
            buffer.putRawBytes(remoteName);
        } else {
            buffer.putRawBytes(rawAddress);
        }
        int port = this.remoteAddress.getPort();
        if (port <= 0) {
            port = 22;
        }
        buffer.putByte((byte)(port >> 8 & 0xFF));
        buffer.putByte((byte)(port & 0xFF));
        this.state = ProtocolState.CONNECTING;
        session.writeBuffer((Buffer)buffer).verify(this.getTimeout(), new CancelOption[0]);
    }

    private void doPasswordAuth(IoSession session) throws Exception {
        GssApiMechanisms.closeContextSilently(this.context);
        this.authenticator = new SocksBasicAuthentication();
        session.addCloseFutureListener(f -> this.close());
        this.startAuth(session);
    }

    private void doGssApiAuth(IoSession session) throws Exception {
        this.authenticator = new SocksGssApiAuthentication();
        session.addCloseFutureListener(f -> this.close());
        this.startAuth(session);
    }

    private void close() {
        AuthenticationHandler<Buffer, Buffer> handler = this.authenticator;
        this.authenticator = null;
        if (handler != null) {
            handler.close();
        }
    }

    private void startAuth(IoSession session) throws Exception {
        Buffer buffer = null;
        try {
            this.authenticator.setParams(null);
            this.authenticator.start();
            buffer = this.authenticator.getToken();
            this.state = ProtocolState.AUTHENTICATING;
            if (buffer == null) {
                throw new IOException("No data for proxy authentication with " + String.valueOf(this.proxyAddress));
            }
            session.writeBuffer(buffer).verify(this.getTimeout(), new CancelOption[0]);
        }
        finally {
            if (buffer != null) {
                buffer.clear(true);
            }
        }
    }

    private void authStep(IoSession session, Buffer input) throws Exception {
        Buffer buffer = null;
        try {
            this.authenticator.setParams(input);
            this.authenticator.process();
            buffer = this.authenticator.getToken();
            if (buffer != null) {
                session.writeBuffer(buffer).verify(this.getTimeout(), new CancelOption[0]);
            }
        }
        finally {
            if (buffer != null) {
                buffer.clear(true);
            }
        }
        if (this.authenticator.isDone()) {
            this.sendConnectInfo(session);
        }
    }

    private void establishConnection(Buffer data) throws Exception {
        byte reply = data.getByte();
        switch (reply) {
            case 0: {
                this.state = ProtocolState.CONNECTED;
                this.setDone(true);
                return;
            }
            case 1: {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksFailureGeneral, this.proxyAddress));
            }
            case 2: {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksFailureForbidden, this.proxyAddress, this.remoteAddress));
            }
            case 3: {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksFailureNetworkUnreachable, this.proxyAddress, this.remoteAddress));
            }
            case 4: {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksFailureHostUnreachable, this.proxyAddress, this.remoteAddress));
            }
            case 5: {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksFailureRefused, this.proxyAddress, this.remoteAddress));
            }
            case 6: {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksFailureTTL, this.proxyAddress));
            }
            case 7: {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksFailureUnsupportedCommand, this.proxyAddress));
            }
            case 8: {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksFailureUnsupportedAddress, this.proxyAddress));
            }
        }
        throw new IOException(MessageFormat.format(SshdText.get().proxySocksFailureUnspecified, this.proxyAddress));
    }

    @Override
    public void messageReceived(IoSession session, Readable buffer) throws Exception {
        try {
            ByteArrayBuffer data = new ByteArrayBuffer(buffer.available(), false);
            data.putBuffer(buffer);
            data.compact();
            this.state.handleMessage(this, session, (Buffer)data);
        }
        catch (Exception e) {
            this.state = ProtocolState.FAILED;
            if (this.authenticator != null) {
                this.authenticator.close();
                this.authenticator = null;
            }
            try {
                this.setDone(false);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
    }

    private void versionCheck(byte version) throws Exception {
        if (version != 5) {
            throw new IOException(MessageFormat.format(SshdText.get().proxySocksUnexpectedVersion, Integer.toString(version & 0xFF)));
        }
    }

    private SocksAuthenticationMethod getAuthMethod(byte value) {
        if (value != SocksAuthenticationMethod.NONE_ACCEPTABLE.getValue()) {
            byte[] byArray = this.authenticationProposals;
            int n = this.authenticationProposals.length;
            int n2 = 0;
            while (n2 < n) {
                byte proposed = byArray[n2];
                if (proposed == value) {
                    SocksAuthenticationMethod[] socksAuthenticationMethodArray = SocksAuthenticationMethod.values();
                    int n3 = socksAuthenticationMethodArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        SocksAuthenticationMethod method = socksAuthenticationMethodArray[n4];
                        if (method.getValue() == value) {
                            return method;
                        }
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
        }
        return SocksAuthenticationMethod.NONE_ACCEPTABLE;
    }

    private static byte[] getRawAddress(@NonNull InetSocketAddress address) {
        InetAddress ipAddress = GssApiMechanisms.resolve(address);
        return ipAddress == null ? null : ipAddress.getAddress();
    }

    private static GSSContext getGSSContext(@NonNull InetSocketAddress address) {
        if (!GssApiMechanisms.getSupportedMechanisms().contains(GssApiMechanisms.KERBEROS_5)) {
            return null;
        }
        return GssApiMechanisms.createContext(GssApiMechanisms.KERBEROS_5, GssApiMechanisms.getCanonicalName(address));
    }

    private static enum ProtocolState {
        NONE,
        INIT{

            @Override
            public void handleMessage(Socks5ClientConnector connector, IoSession session, Buffer data) throws Exception {
                connector.versionCheck(data.getByte());
                SocksAuthenticationMethod authMethod = connector.getAuthMethod(data.getByte());
                switch (authMethod) {
                    case ANONYMOUS: {
                        connector.sendConnectInfo(session);
                        break;
                    }
                    case PASSWORD: {
                        connector.doPasswordAuth(session);
                        break;
                    }
                    case GSSAPI: {
                        connector.doGssApiAuth(session);
                        break;
                    }
                    default: {
                        throw new IOException(MessageFormat.format(SshdText.get().proxyCannotAuthenticate, connector.proxyAddress));
                    }
                }
            }
        }
        ,
        AUTHENTICATING{

            @Override
            public void handleMessage(Socks5ClientConnector connector, IoSession session, Buffer data) throws Exception {
                connector.authStep(session, data);
            }
        }
        ,
        CONNECTING{

            @Override
            public void handleMessage(Socks5ClientConnector connector, IoSession session, Buffer data) throws Exception {
                if (data.available() != 4) {
                    connector.versionCheck(data.getByte());
                    connector.establishConnection(data);
                }
            }
        }
        ,
        CONNECTED,
        FAILED;


        public void handleMessage(Socks5ClientConnector connector, IoSession session, Buffer data) throws Exception {
            throw new IOException(MessageFormat.format(SshdText.get().proxySocksUnexpectedMessage, new Object[]{connector.proxyAddress, this, BufferUtils.toHex((byte[])data.array())}));
        }
    }

    private static enum SocksAuthenticationMethod {
        ANONYMOUS(0),
        GSSAPI(1),
        PASSWORD(2),
        NONE_ACCEPTABLE(255);

        private final byte value;

        private SocksAuthenticationMethod(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }
    }

    private class SocksBasicAuthentication
    extends BasicAuthentication<Buffer, Buffer> {
        private static final byte SOCKS_BASIC_PROTOCOL_VERSION = 1;
        private static final byte SOCKS_BASIC_AUTH_SUCCESS = 0;

        public SocksBasicAuthentication() {
            super(Socks5ClientConnector.this.proxyAddress, Socks5ClientConnector.this.proxyUser, Socks5ClientConnector.this.proxyPassword);
        }

        @Override
        public void process() throws Exception {
            this.done = true;
            if (((Buffer)this.params).getByte() != 1 || ((Buffer)this.params).getByte() != 0) {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksAuthenticationFailed, this.proxy));
            }
        }

        @Override
        protected void askCredentials() {
            super.askCredentials();
            Socks5ClientConnector.this.adjustTimeout();
        }

        @Override
        public Buffer getToken() throws IOException {
            if (this.done) {
                return null;
            }
            try {
                byte[] rawUser = this.user.getBytes(StandardCharsets.UTF_8);
                if (rawUser.length > 255) {
                    throw new IOException(MessageFormat.format(SshdText.get().proxySocksUsernameTooLong, this.proxy, Integer.toString(rawUser.length), this.user));
                }
                if (this.password.length > 255) {
                    throw new IOException(MessageFormat.format(SshdText.get().proxySocksPasswordTooLong, this.proxy, Integer.toString(this.password.length)));
                }
                ByteArrayBuffer buffer = new ByteArrayBuffer(3 + rawUser.length + this.password.length, false);
                buffer.putByte((byte)1);
                buffer.putByte((byte)rawUser.length);
                buffer.putRawBytes(rawUser);
                buffer.putByte((byte)this.password.length);
                buffer.putRawBytes(this.password);
                ByteArrayBuffer byteArrayBuffer = buffer;
                return byteArrayBuffer;
            }
            finally {
                this.clearPassword();
                this.done = true;
            }
        }
    }

    private class SocksGssApiAuthentication
    extends GssApiAuthentication<Buffer, Buffer> {
        private static final byte SOCKS5_GSSAPI_VERSION = 1;
        private static final byte SOCKS5_GSSAPI_TOKEN = 1;
        private static final int SOCKS5_GSSAPI_FAILURE = 255;

        public SocksGssApiAuthentication() {
            super(Socks5ClientConnector.this.proxyAddress);
        }

        @Override
        protected GSSContext createContext() throws Exception {
            return Socks5ClientConnector.this.context;
        }

        @Override
        public Buffer getToken() throws Exception {
            if (this.token == null) {
                return null;
            }
            ByteArrayBuffer buffer = new ByteArrayBuffer(4 + this.token.length, false);
            buffer.putByte((byte)1);
            buffer.putByte((byte)1);
            buffer.putByte((byte)(this.token.length >> 8 & 0xFF));
            buffer.putByte((byte)(this.token.length & 0xFF));
            buffer.putRawBytes(this.token);
            return buffer;
        }

        @Override
        protected byte[] extractToken(Buffer input) throws Exception {
            if (Socks5ClientConnector.this.context == null) {
                return null;
            }
            int version = input.getUByte();
            if (version != 1) {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksGssApiVersionMismatch, Socks5ClientConnector.this.remoteAddress, Integer.toString(version)));
            }
            int msgType = input.getUByte();
            if (msgType == 255) {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksGssApiFailure, Socks5ClientConnector.this.remoteAddress));
            }
            if (msgType != 1) {
                throw new IOException(MessageFormat.format(SshdText.get().proxySocksGssApiUnknownMessage, Socks5ClientConnector.this.remoteAddress, Integer.toHexString(msgType & 0xFF)));
            }
            if (input.available() >= 2) {
                int length = (input.getUByte() << 8) + input.getUByte();
                if (input.available() >= length) {
                    byte[] value = new byte[length];
                    if (length > 0) {
                        input.getRawBytes(value);
                    }
                    return value;
                }
            }
            throw new IOException(MessageFormat.format(SshdText.get().proxySocksGssApiMessageTooShort, Socks5ClientConnector.this.remoteAddress));
        }
    }
}

