/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class JandexReflection {
    public static Class<?> loadRawType(Type type) {
        if (type == null) {
            return null;
        }
        switch (type.kind()) {
            case VOID: {
                return Void.TYPE;
            }
            case PRIMITIVE: {
                switch (type.asPrimitiveType().primitive()) {
                    case BOOLEAN: {
                        return Boolean.TYPE;
                    }
                    case BYTE: {
                        return Byte.TYPE;
                    }
                    case SHORT: {
                        return Short.TYPE;
                    }
                    case INT: {
                        return Integer.TYPE;
                    }
                    case LONG: {
                        return Long.TYPE;
                    }
                    case FLOAT: {
                        return Float.TYPE;
                    }
                    case DOUBLE: {
                        return Double.TYPE;
                    }
                    case CHAR: {
                        return Character.TYPE;
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type: " + type);
            }
            case CLASS: 
            case PARAMETERIZED_TYPE: 
            case ARRAY: 
            case WILDCARD_TYPE: 
            case TYPE_VARIABLE: 
            case TYPE_VARIABLE_REFERENCE: {
                return JandexReflection.load(type.name());
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                return Object.class;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static Class<?> loadClass(ClassInfo clazz) {
        if (clazz == null) {
            return null;
        }
        return JandexReflection.load(clazz.name());
    }

    private static Class<?> load(DotName name) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = JandexReflection.class.getClassLoader();
            }
            return Class.forName(name.toString(), false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

