/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.Mutator;

public class CacheEntryMutator<K, V>
implements Mutator {
    private final Cache<K, V> cache;
    private final K key;
    private final V value;
    private final AtomicBoolean mutated;

    public CacheEntryMutator(Cache<K, V> cache, Map.Entry<K, V> entry) {
        this(cache, entry.getKey(), entry.getValue());
    }

    public CacheEntryMutator(Cache<K, V> cache, K key, V value) {
        this.cache = cache;
        this.key = key;
        this.value = value;
        this.mutated = cache.getCacheConfiguration().transaction().transactionMode().isTransactional() ? new AtomicBoolean(false) : null;
    }

    public void mutate() {
        if (this.mutated == null || this.mutated.compareAndSet(false, true)) {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FAIL_SILENTLY}).put(this.key, this.value);
        }
    }
}

