/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.analysis.impl.ScopedAnalyzer;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneNestablePredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneCommonMinimumShouldMatchConstraint;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneCommonQueryStringPredicateBuilderFieldState;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.common.spi.SearchIndexSchemaElementContextHelper;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.engine.search.predicate.spi.CommonQueryStringPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class LuceneCommonQueryStringPredicate
extends AbstractLuceneNestablePredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<String> nestedPathHierarchy;
    private final List<String> fieldPaths;
    private final Query query;

    protected LuceneCommonQueryStringPredicate(Builder builder) {
        super(builder);
        this.nestedPathHierarchy = builder.firstFieldState.field().nestedPathHierarchy();
        this.fieldPaths = new ArrayList<String>(builder.fieldStates.keySet());
        this.query = builder.buildQuery();
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        return this.query;
    }

    @Override
    protected List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    @Override
    protected List<String> getFieldPathsForErrorMessage() {
        return this.fieldPaths;
    }

    public static abstract class Builder
    extends AbstractLuceneSearchPredicate.AbstractBuilder
    implements CommonQueryStringPredicateBuilder {
        private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
        private LuceneCommonQueryStringPredicateBuilderFieldState firstFieldState;
        private final Map<String, LuceneCommonQueryStringPredicateBuilderFieldState> fieldStates = new LinkedHashMap<String, LuceneCommonQueryStringPredicateBuilderFieldState>();
        protected BooleanOperator defaultOperator = BooleanOperator.OR;
        protected String queryString;
        private Analyzer overrideAnalyzer;
        private boolean ignoreAnalyzer = false;
        private NavigableMap<Integer, LuceneCommonMinimumShouldMatchConstraint> minimumShouldMatchConstraints;

        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
            this.analysisDefinitionRegistry = scope.analysisDefinitionRegistry();
        }

        public void defaultOperator(BooleanOperator operator) {
            this.defaultOperator = operator;
        }

        public CommonQueryStringPredicateBuilder.FieldState field(String fieldPath) {
            LuceneCommonQueryStringPredicateBuilderFieldState fieldState = this.fieldStates.get(fieldPath);
            if (fieldState == null) {
                fieldState = (LuceneCommonQueryStringPredicateBuilderFieldState)this.scope.fieldQueryElement(fieldPath, this.typeKey());
                if (this.firstFieldState == null) {
                    this.firstFieldState = fieldState;
                } else {
                    SearchIndexSchemaElementContextHelper.checkNestedDocumentPathCompatibility(this.firstFieldState.field(), fieldState.field());
                }
                this.fieldStates.put(fieldPath, fieldState);
            }
            return fieldState;
        }

        public void queryString(String queryString) {
            this.queryString = queryString;
        }

        public void analyzer(String analyzerName) {
            this.overrideAnalyzer = this.analysisDefinitionRegistry.getAnalyzerDefinition(analyzerName);
            if (this.overrideAnalyzer == null) {
                throw log.unknownAnalyzer(analyzerName, EventContexts.fromIndexNames((Set)this.scope.hibernateSearchIndexNames()));
            }
        }

        public void skipAnalysis() {
            this.ignoreAnalyzer = true;
        }

        public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
            this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new LuceneCommonMinimumShouldMatchConstraint(matchingClausesNumber, null));
        }

        public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
            this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new LuceneCommonMinimumShouldMatchConstraint(null, matchingClausesPercent));
        }

        private void addMinimumShouldMatchConstraint(int ignoreConstraintCeiling, LuceneCommonMinimumShouldMatchConstraint constraint) {
            LuceneCommonMinimumShouldMatchConstraint previous;
            if (this.minimumShouldMatchConstraints == null) {
                this.minimumShouldMatchConstraints = new TreeMap<Integer, LuceneCommonMinimumShouldMatchConstraint>();
            }
            if ((previous = this.minimumShouldMatchConstraints.put(ignoreConstraintCeiling, constraint)) != null) {
                throw log.minimumShouldMatchConflictingConstraints(ignoreConstraintCeiling);
            }
        }

        protected Query applyMinimumShouldMatch(Query query) {
            if (this.minimumShouldMatchConstraints == null) {
                return query;
            }
            if (query instanceof BooleanQuery) {
                int shouldClauses = (int)((BooleanQuery)query).clauses().stream().map(BooleanClause::getOccur).filter(arg_0 -> BooleanClause.Occur.SHOULD.equals(arg_0)).count();
                int minimumShouldMatch = LuceneCommonMinimumShouldMatchConstraint.minimumShouldMatch(this.minimumShouldMatchConstraints, shouldClauses);
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                for (BooleanClause clause : ((BooleanQuery)query).clauses()) {
                    builder.add(clause);
                }
                query = builder.setMinimumNumberShouldMatch(minimumShouldMatch).build();
            }
            return query;
        }

        protected abstract Query buildQuery();

        protected abstract SearchQueryElementTypeKey<LuceneCommonQueryStringPredicateBuilderFieldState> typeKey();

        protected Analyzer buildAnalyzer() {
            if (this.ignoreAnalyzer) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            if (this.overrideAnalyzer != null) {
                return this.overrideAnalyzer;
            }
            if (this.fieldStates.size() == 1) {
                return this.fieldStates.values().iterator().next().field().type().searchAnalyzerOrNormalizer();
            }
            ScopedAnalyzer.Builder builder = new ScopedAnalyzer.Builder();
            for (LuceneCommonQueryStringPredicateBuilderFieldState state : this.fieldStates.values()) {
                builder.setAnalyzer(state.field().absolutePath(), state.field().type().searchAnalyzerOrNormalizer());
            }
            return builder.build();
        }

        protected Map<String, Float> buildWeights() {
            LinkedHashMap<String, Float> weights = new LinkedHashMap<String, Float>();
            for (LuceneCommonQueryStringPredicateBuilderFieldState state : this.fieldStates.values()) {
                Float boost = state.boost();
                if (boost == null) {
                    boost = Float.valueOf(1.0f);
                }
                weights.put(state.field().absolutePath(), boost);
            }
            return weights;
        }
    }
}

