/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.lang.invoke.MethodHandles;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.apache.activemq.artemis.utils.actors.HandlerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessorBase<T>
extends HandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int STATE_NOT_RUNNING = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_FORCED_SHUTDOWN = 2;
    protected final Queue<T> tasks = new ConcurrentLinkedQueue<T>();
    private final Executor delegate;
    private final Runnable task = this::executePendingTasks;
    private volatile int state = 0;
    private volatile boolean requestedForcedShutdown = false;
    protected volatile boolean requestedShutdown = false;
    private volatile boolean yielded = false;
    private static final AtomicIntegerFieldUpdater<ProcessorBase> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ProcessorBase.class, "state");

    private void executePendingTasks() {
        do {
            if (stateUpdater.compareAndSet(this, 0, 1)) {
                ProcessorBase.enter();
                try {
                    T task;
                    while (!this.yielded && !this.requestedForcedShutdown && (task = this.tasks.poll()) != null) {
                        this.doTask(task);
                    }
                }
                finally {
                    ProcessorBase.leave();
                    if (!stateUpdater.compareAndSet(this, 1, 0)) {
                        return;
                    }
                }
            } else {
                return;
            }
        } while (!this.tasks.isEmpty() && !this.requestedShutdown && !this.yielded);
        if (this.yielded) {
            this.yielded = false;
            this.delegate.execute(this.task);
        }
    }

    public void shutdown() {
        this.shutdown(30L, TimeUnit.SECONDS);
    }

    public void shutdown(long timeout, TimeUnit unit) {
        this.requestedShutdown = true;
        if (!ProcessorBase.inHandler()) {
            this.flush(timeout, unit);
        }
    }

    public void yield() {
        this.yielded = true;
    }

    public int shutdownNow(Consumer<? super T> onPendingItem, int timeout, TimeUnit unit) {
        T item;
        this.requestedForcedShutdown = true;
        this.requestedShutdown = true;
        this.yielded = false;
        if (!ProcessorBase.inHandler()) {
            this.flush(timeout, unit);
        }
        stateUpdater.set(this, 2);
        int pendingItems = 0;
        while ((item = this.tasks.poll()) != null) {
            onPendingItem.accept(item);
            ++pendingItems;
        }
        return pendingItems;
    }

    protected abstract void doTask(T var1);

    public ProcessorBase(Executor parent) {
        this.delegate = parent;
    }

    public final boolean isFlushed() {
        return this.state == 0;
    }

    public final boolean flush(long timeout, TimeUnit unit) {
        if (this.state == 0) {
            return true;
        }
        long timeLimit = System.currentTimeMillis() + unit.toMillis(timeout);
        try {
            while (this.state == 1 && timeLimit > System.currentTimeMillis()) {
                if (this.tasks.isEmpty()) {
                    return true;
                }
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.state == 0;
    }

    protected void task(T command) {
        if (this.requestedShutdown) {
            ProcessorBase.logAddOnShutdown();
            return;
        }
        this.tasks.add(command);
        int state = stateUpdater.get(this);
        if (state != 1) {
            this.onAddedTaskIfNotRunning(state);
        }
    }

    private void onAddedTaskIfNotRunning(int state) {
        if (state == 0) {
            this.delegate.execute(this.task);
        }
    }

    private static void logAddOnShutdown() {
        if (logger.isDebugEnabled()) {
            logger.debug("Ordered executor has been gently shutdown at {}", new Exception("debug"));
        }
    }

    public final int remaining() {
        return this.tasks.size();
    }

    public final int status() {
        return this.state;
    }
}

