/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicationBackupPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.ReplicationPrimaryActivation;
import org.apache.activemq.artemis.quorum.DistributedPrimitiveManager;

public class ReplicationPrimaryPolicy
implements HAPolicy<ReplicationPrimaryActivation> {
    private final ReplicationBackupPolicy backupPolicy;
    private final String clusterName;
    private final String groupName;
    private final long initialReplicationSyncTimeout;
    private final DistributedPrimitiveManagerConfiguration distributedManagerConfiguration;
    private final boolean allowAutoFailBack;
    private final String coordinationId;

    private ReplicationPrimaryPolicy(ReplicationPrimaryPolicyConfiguration configuration, ReplicationBackupPolicy backupPolicy, boolean allowAutoFailBack) {
        Objects.requireNonNull(backupPolicy);
        this.clusterName = configuration.getClusterName();
        this.groupName = configuration.getGroupName();
        this.initialReplicationSyncTimeout = configuration.getInitialReplicationSyncTimeout();
        this.distributedManagerConfiguration = configuration.getDistributedManagerConfiguration();
        this.coordinationId = configuration.getCoordinationId();
        this.allowAutoFailBack = allowAutoFailBack;
        this.backupPolicy = backupPolicy;
    }

    private ReplicationPrimaryPolicy(ReplicationPrimaryPolicyConfiguration config) {
        this.clusterName = config.getClusterName();
        this.groupName = config.getGroupName();
        this.coordinationId = config.getCoordinationId();
        this.initialReplicationSyncTimeout = config.getInitialReplicationSyncTimeout();
        this.distributedManagerConfiguration = config.getDistributedManagerConfiguration();
        this.allowAutoFailBack = false;
        this.backupPolicy = ReplicationBackupPolicy.failback(config.getRetryReplicationWait(), config.getMaxSavedReplicatedJournalsSize(), config.getClusterName(), config.getGroupName(), this, config.getDistributedManagerConfiguration());
    }

    static ReplicationPrimaryPolicy failoverPolicy(long initialReplicationSyncTimeout, String groupName, String clusterName, ReplicationBackupPolicy replicaPolicy, boolean allowAutoFailback, DistributedPrimitiveManagerConfiguration distributedManagerConfiguration) {
        return new ReplicationPrimaryPolicy(ReplicationPrimaryPolicyConfiguration.withDefault().setInitialReplicationSyncTimeout(initialReplicationSyncTimeout).setGroupName(groupName).setClusterName(clusterName).setDistributedManagerConfiguration(distributedManagerConfiguration), replicaPolicy, allowAutoFailback);
    }

    public static ReplicationPrimaryPolicy with(ReplicationPrimaryPolicyConfiguration configuration) {
        return new ReplicationPrimaryPolicy(configuration);
    }

    public ReplicationBackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    @Override
    public ReplicationPrimaryActivation createActivation(ActiveMQServerImpl server, boolean wasPrimary, Map<String, Object> activationParams, IOCriticalErrorListener shutdownOnCriticalIO) throws Exception {
        return new ReplicationPrimaryActivation(server, DistributedPrimitiveManager.newInstanceOf((String)this.distributedManagerConfiguration.getClassName(), this.distributedManagerConfiguration.getProperties()), this);
    }

    @Override
    public boolean isSharedStore() {
        return false;
    }

    @Override
    public boolean isBackup() {
        return false;
    }

    @Override
    public boolean isWaitForActivation() {
        return true;
    }

    @Override
    public boolean canScaleDown() {
        return false;
    }

    @Override
    public String getBackupGroupName() {
        return this.groupName;
    }

    @Override
    public String getScaleDownGroupName() {
        return null;
    }

    @Override
    public String getScaleDownClustername() {
        return null;
    }

    public boolean isAllowAutoFailBack() {
        return this.allowAutoFailBack;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public long getInitialReplicationSyncTimeout() {
        return this.initialReplicationSyncTimeout;
    }

    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public boolean useQuorumManager() {
        return false;
    }

    public String getCoordinationId() {
        return this.coordinationId;
    }
}

