/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.wildfly.clustering.ee.Creator;
import org.wildfly.clustering.ee.Manager;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ee.cache.ConcurrentManager;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.cache.bean.BeanGroup;
import org.wildfly.clustering.ejb.cache.bean.BeanGroupManager;
import org.wildfly.clustering.ejb.cache.bean.DefaultBeanGroup;
import org.wildfly.clustering.ejb.cache.bean.DefaultBeanGroupManagerConfiguration;
import org.wildfly.clustering.ejb.cache.bean.MutableBeanGroup;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.common.function.Functions;

public class DefaultBeanGroupManager<K, V extends BeanInstance<K>, C>
implements BeanGroupManager<K, V> {
    static final Logger LOGGER = Logger.getLogger(DefaultBeanGroupManager.class);
    private final Creator<K, MarshalledValue<Map<K, V>, C>, MarshalledValue<Map<K, V>, C>> creator;
    private final MutatorFactory<K, MarshalledValue<Map<K, V>, C>> mutatorFactory;
    private final MarshalledValueFactory<C> factory;
    private final Manager<K, MutableBeanGroup<K, V>> manager;
    private final Consumer<Map<K, V>> postActivateTask;
    private final Consumer<Map<K, V>> prePassivateTask;

    public DefaultBeanGroupManager(DefaultBeanGroupManagerConfiguration<K, V, C> configuration) {
        this.creator = configuration.getCreator();
        this.mutatorFactory = configuration.getMutatorFactory();
        this.factory = configuration.getMarshalledValueFactory();
        boolean persistent = configuration.getCacheProperties().isPersistent();
        this.postActivateTask = persistent ? new MapValuesTask(BeanInstance::postActivate) : Functions.discardingConsumer();
        this.prePassivateTask = persistent ? new MapValuesTask(BeanInstance::prePassivate) : Functions.discardingConsumer();
        this.manager = new ConcurrentManager(Functions.discardingConsumer(), new NewBeanGroupCloseTask(configuration.getRemover()));
    }

    @Override
    public BeanGroup<K, V> getBeanGroup(final K id) {
        final Creator<K, MarshalledValue<Map<K, V>, C>, MarshalledValue<Map<K, V>, C>> creator = this.creator;
        final MutatorFactory<K, MarshalledValue<Map<K, V>, C>> mutatorFactory = this.mutatorFactory;
        final MarshalledValueFactory<C> factory = this.factory;
        final Consumer<Map<K, V>> postActivateTask = this.postActivateTask;
        final Consumer<Map<K, V>> prePassivateTask = this.prePassivateTask;
        Function beanGroupFactory = new Function<Runnable, MutableBeanGroup<K, V>>(){

            @Override
            public MutableBeanGroup<K, V> apply(Runnable closeTask) {
                Map instances = new ConcurrentHashMap();
                MarshalledValue newValue = factory.createMarshalledValue(instances);
                MarshalledValue value = (MarshalledValue)creator.createValue(id, (Object)newValue);
                if (value != newValue) {
                    try {
                        instances = (Map)value.get(factory.getMarshallingContext());
                        postActivateTask.accept(instances);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                Mutator mutator = mutatorFactory.createMutator(id, (Object)value);
                return new DefaultBeanGroup(id, instances, prePassivateTask, mutator, closeTask);
            }
        };
        return (BeanGroup)this.manager.apply(id, beanGroupFactory);
    }

    private static class MapValuesTask<K, V>
    implements Consumer<Map<K, V>> {
        private final Consumer<V> task;

        MapValuesTask(Consumer<V> task) {
            this.task = task;
        }

        @Override
        public void accept(Map<K, V> instances) {
            instances.values().forEach(this.task);
        }
    }

    private static class NewBeanGroupCloseTask<K, V extends BeanInstance<K>, C>
    implements Consumer<MutableBeanGroup<K, V>> {
        private final Remover<K> remover;

        NewBeanGroupCloseTask(Remover<K> remover) {
            this.remover = remover;
        }

        @Override
        public void accept(MutableBeanGroup<K, V> group) {
            if (group.isEmpty()) {
                this.remover.remove(group.getId());
            } else {
                group.mutate();
            }
        }
    }
}

