/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationCommandDispatcher;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.DeleteOnClose;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationSource
extends AMQPFederation {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Symbol[] CONTROL_LINK_CAPABILITIES = new Symbol[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK};
    private final AMQPBrokerConnection brokerConnection;
    private final Map<String, FederationReceiveFromQueuePolicy> remoteQueueMatchPolicies = new HashMap<String, FederationReceiveFromQueuePolicy>();
    private final Map<String, FederationReceiveFromAddressPolicy> remoteAddressMatchPolicies = new HashMap<String, FederationReceiveFromAddressPolicy>();
    private final Map<String, Object> properties;
    private volatile AMQPFederationConfiguration configuration;

    public AMQPFederationSource(String name, Map<String, Object> properties, AMQPBrokerConnection connection) {
        super(name, connection.getServer());
        this.properties = properties == null || properties.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(new HashMap<String, Object>(properties));
        this.brokerConnection = connection;
        this.brokerConnection.addLinkClosedInterceptor(this.getName(), this::invokeLinkClosedInterceptors);
    }

    public AMQPBrokerConnection getBrokerConnection() {
        return this.brokerConnection;
    }

    @Override
    public int getLinkAttachTimeout() {
        return this.configuration.getLinkAttachTimeout();
    }

    @Override
    public synchronized AMQPSessionContext getSessionContext() {
        if (!this.connected) {
            throw new IllegalStateException("Cannot access session while federation is not connected");
        }
        return this.session;
    }

    @Override
    public synchronized AMQPConnectionContext getConnectionContext() {
        if (!this.connected) {
            throw new IllegalStateException("Cannot access connection while federation is not connected");
        }
        return this.connection;
    }

    @Override
    public synchronized int getReceiverCredits() {
        if (!this.connected) {
            throw new IllegalStateException("Cannot access connection configuration, federation is not connected");
        }
        return this.configuration.getReceiverCredits();
    }

    @Override
    public synchronized int getReceiverCreditsLow() {
        if (!this.connected) {
            throw new IllegalStateException("Cannot access connection configuration, federation is not connected");
        }
        return this.configuration.getReceiverCreditsLow();
    }

    @Override
    public synchronized int getLargeMessageThreshold() {
        if (!this.connected) {
            throw new IllegalStateException("Cannot access connection configuration, federation is not connected");
        }
        return this.configuration.getLargeMessageThreshold();
    }

    @Override
    public boolean isCoreMessageTunnelingEnabled() {
        if (!this.connected) {
            throw new IllegalStateException("Cannot access connection configuration, federation is not connected");
        }
        return this.configuration.isCoreMessageTunnelingEnabled();
    }

    public synchronized AMQPFederationSource addRemoteQueueMatchPolicy(FederationReceiveFromQueuePolicy queuePolicy) {
        this.remoteQueueMatchPolicies.putIfAbsent(queuePolicy.getPolicyName(), queuePolicy);
        return this;
    }

    public synchronized AMQPFederationSource addRemoteAddressMatchPolicy(FederationReceiveFromAddressPolicy addressPolicy) {
        this.remoteAddressMatchPolicies.putIfAbsent(addressPolicy.getPolicyName(), addressPolicy);
        return this;
    }

    public synchronized void handleConnectionDropped() throws ActiveMQException {
        this.connected = false;
        AtomicReference errorCaught = new AtomicReference();
        this.queueMatchPolicies.forEach((k, v) -> {
            try {
                v.stop();
            }
            catch (Exception ex) {
                errorCaught.compareAndExchange(null, ex);
            }
        });
        this.addressMatchPolicies.forEach((k, v) -> {
            try {
                v.stop();
            }
            catch (Exception ex) {
                errorCaught.compareAndExchange(null, ex);
            }
        });
        this.connection = null;
        this.session = null;
        if (errorCaught.get() != null) {
            Exception error = (Exception)errorCaught.get();
            if (error instanceof ActiveMQException) {
                throw (ActiveMQException)((Object)error);
            }
            throw (ActiveMQException)new ActiveMQException(error.getMessage()).initCause((Throwable)error);
        }
    }

    public synchronized void handleConnectionRestored(AMQPConnectionContext connection, AMQPSessionContext session) throws ActiveMQException {
        Connection protonConnection = session.getSession().getConnection();
        Record attachments = protonConnection.attachments();
        if (attachments.get((Object)"FEDERATION_INSTANCE_RECORD", AMQPFederation.class) != null) {
            throw new ActiveMQAMQPIllegalStateException("An existing federation instance was found on the connection");
        }
        this.connection = connection;
        this.session = session;
        this.configuration = new AMQPFederationConfiguration(connection, this.properties);
        attachments.set((Object)"FEDERATION_INSTANCE_RECORD", AMQPFederationSource.class, (Object)this);
        this.asyncCreateControlLink();
    }

    @Override
    protected void signalResourceCreateError(Exception cause) {
        this.brokerConnection.connectError(cause);
    }

    @Override
    protected void signalError(Exception cause) {
        this.brokerConnection.runtimeError(cause);
    }

    protected boolean interceptLinkClosedEvent(Link link) {
        return false;
    }

    private void asyncCreateControlLink() {
        this.connection.runLater(() -> {
            try {
                Sender sender = this.session.getSession().sender("Federation:" + this.getName() + ":" + UUIDGenerator.getInstance().generateStringUUID());
                AMQPFederationCommandDispatcher commandLink = new AMQPFederationCommandDispatcher(sender, this.getServer(), this.session.getSessionSPI());
                Target target = new Target();
                target.setDynamic(true);
                target.setCapabilities(new Symbol[]{Symbol.valueOf((String)"temporary-topic")});
                target.setDurable(TerminusDurability.NONE);
                target.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
                HashMap<Symbol, DeleteOnClose> dynamicNodeProperties = new HashMap<Symbol, DeleteOnClose>();
                dynamicNodeProperties.put(AmqpSupport.LIFETIME_POLICY, DeleteOnClose.getInstance());
                target.setDynamicNodeProperties(dynamicNodeProperties);
                HashMap<Symbol, Map<String, Object>> senderProperties = new HashMap<Symbol, Map<String, Object>>();
                senderProperties.put(AMQPFederationConstants.FEDERATION_CONFIGURATION, this.configuration.toConfigurationMap());
                sender.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                sender.setDesiredCapabilities(CONTROL_LINK_CAPABILITIES);
                sender.setProperties(senderProperties);
                sender.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
                sender.setSource((org.apache.qpid.proton.amqp.transport.Source)new Source());
                sender.open();
                AtomicBoolean cancelled = new AtomicBoolean(false);
                ScheduledFuture<?> futureTimeout = this.brokerConnection.getConnectionTimeout() > 0 ? this.brokerConnection.getServer().getScheduledPool().schedule(() -> {
                    cancelled.set(true);
                    this.brokerConnection.connectError((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionTimeout()));
                }, (long)this.brokerConnection.getConnectionTimeout(), TimeUnit.MILLISECONDS) : null;
                sender.attachments().set(AmqpSupport.AMQP_LINK_INITIALIZER_KEY, Runnable.class, () -> {
                    try {
                        if (cancelled.get()) {
                            return;
                        }
                        if (futureTimeout != null) {
                            futureTimeout.cancel(false);
                        }
                        if (sender.getRemoteTarget() == null) {
                            this.brokerConnection.connectError((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.federationControlLinkRefused(sender.getName())));
                            return;
                        }
                        if (!AmqpSupport.verifyOfferedCapabilities((Link)sender)) {
                            this.brokerConnection.connectError((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.missingOfferedCapability(Arrays.toString(CONTROL_LINK_CAPABILITIES))));
                            return;
                        }
                        try {
                            this.session.getSessionSPI().addMetaData("federation-name", this.getName());
                        }
                        catch (ActiveMQAMQPException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            logger.trace("Exception on add of federation Metadata: ", (Throwable)e);
                            throw new ActiveMQAMQPInternalErrorException("Error while configuring interal session metadata");
                        }
                        ProtonServerSenderContext senderContext = new ProtonServerSenderContext(this.connection, sender, this.session, this.session.getSessionSPI(), commandLink);
                        this.session.addSender(sender, senderContext);
                        this.connected = true;
                        this.remoteQueueMatchPolicies.forEach((key, policy) -> {
                            try {
                                commandLink.sendPolicy((FederationReceiveFromQueuePolicy)policy);
                            }
                            catch (Exception e) {
                                this.brokerConnection.error(e);
                            }
                        });
                        this.remoteAddressMatchPolicies.forEach((key, policy) -> {
                            try {
                                commandLink.sendPolicy((FederationReceiveFromAddressPolicy)policy);
                            }
                            catch (Exception e) {
                                this.brokerConnection.error(e);
                            }
                        });
                        this.scheduler.execute(() -> {
                            AMQPFederationSource aMQPFederationSource = this;
                            synchronized (aMQPFederationSource) {
                                if (this.isStarted()) {
                                    this.queueMatchPolicies.forEach((k, v) -> v.start());
                                    this.addressMatchPolicies.forEach((k, v) -> v.start());
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        this.brokerConnection.error(e);
                    }
                });
            }
            catch (Exception e) {
                this.brokerConnection.error(e);
            }
            this.connection.flush();
        });
    }
}

