/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.function.ExceptionBiConsumer;

class MailSessionWriteAttributeHandler
extends ReloadRequiredWriteAttributeHandler {
    private final ExceptionBiConsumer<OperationContext, ModelNode, OperationFailedException> remover;
    private final ExceptionBiConsumer<OperationContext, ModelNode, OperationFailedException> installer;

    MailSessionWriteAttributeHandler(AttributeDefinition attribute, ExceptionBiConsumer<OperationContext, ModelNode, OperationFailedException> remover, ExceptionBiConsumer<OperationContext, ModelNode, OperationFailedException> installer) {
        super(List.of(attribute));
        this.remover = remover;
        this.installer = installer;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handback) throws OperationFailedException {
        boolean updated = super.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, handback);
        if (updated) {
            PathAddress address = context.getCurrentAddress();
            if (context.isResourceServiceRestartAllowed() && this.getAttributeDefinition(attributeName).getFlags().contains(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES) && context.markResourceRestarted(address, (Object)this)) {
                this.remover.accept((Object)context, (Object)context.getOriginalRootResource().navigate(address).getModel());
                this.installer.accept((Object)context, (Object)Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS)));
                return false;
            }
        }
        return updated;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode resolvedValue, Void handback) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        if (context.isResourceServiceRestartAllowed() && this.getAttributeDefinition(attributeName).getFlags().contains(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES) && context.revertResourceRestarted(address, (Object)this)) {
            this.remover.accept((Object)context, (Object)context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel());
            this.installer.accept((Object)context, (Object)Resource.Tools.readModel((Resource)context.getOriginalRootResource().navigate(address)));
        }
    }
}

