/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.advertise.impl;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import org.jboss.logging.Logger;
import org.jboss.modcluster.ModClusterLogger;
import org.jboss.modcluster.advertise.DatagramChannelFactory;

public class DatagramChannelFactoryImpl
implements DatagramChannelFactory {
    private final Logger log = Logger.getLogger(this.getClass());
    boolean canBindToMulticastAddress;

    public DatagramChannelFactoryImpl() {
        String value = this.getSystemProperty("os.name");
        this.canBindToMulticastAddress = value != null && (value.toLowerCase(Locale.ENGLISH).startsWith("linux") || value.toLowerCase(Locale.ENGLISH).startsWith("mac") || value.toLowerCase(Locale.ENGLISH).startsWith("hp"));
    }

    private String getSystemProperty(final String key) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty(key);
                }
                catch (SecurityException e) {
                    DatagramChannelFactoryImpl.this.log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    return null;
                }
            }
        };
        return AccessController.doPrivileged(action);
    }

    @Override
    public DatagramChannel createDatagramChannel(InetSocketAddress multicastSocketAddress) throws IOException {
        InetSocketAddress bindToPort;
        InetAddress address = multicastSocketAddress.getAddress();
        int port = multicastSocketAddress.getPort();
        if (address == null) {
            throw ModClusterLogger.LOGGER.createMulticastSocketWithNullMulticastAddress();
        }
        if (!address.isMulticastAddress()) {
            throw ModClusterLogger.LOGGER.createMulticastSocketWithUnicastAddress(address);
        }
        InetSocketAddress inetSocketAddress = bindToPort = address instanceof Inet4Address ? new InetSocketAddress("0.0.0.0", port) : new InetSocketAddress("::", port);
        if (!this.canBindToMulticastAddress) {
            return DatagramChannelFactoryImpl.newChannel(address, bindToPort);
        }
        try {
            return DatagramChannelFactoryImpl.newChannel(address, new InetSocketAddress(address, port));
        }
        catch (IOException e) {
            ModClusterLogger.LOGGER.potentialCrossTalking(address, address instanceof Inet4Address ? "IPv4" : "IPv6", e.getLocalizedMessage());
            ModClusterLogger.LOGGER.catchingDebug(e);
            return DatagramChannelFactoryImpl.newChannel(address, bindToPort);
        }
    }

    private static DatagramChannel newChannel(InetAddress multicastAddress, InetSocketAddress bindAddress) throws IOException {
        DatagramChannel channel = multicastAddress == null ? DatagramChannel.open() : DatagramChannel.open(multicastAddress instanceof Inet4Address ? StandardProtocolFamily.INET : StandardProtocolFamily.INET6);
        channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        if (bindAddress != null) {
            channel.bind(bindAddress);
        }
        return channel;
    }
}

