/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.MessageReferenceImpl;
import org.apache.activemq.artemis.core.transaction.Transaction;

public interface MessageReference {
    default public boolean skipDelivery() {
        return false;
    }

    public boolean isPaged();

    public Message getMessage();

    public long getMessageID();

    public boolean isDurable();

    public SimpleString getLastValueProperty();

    public void onDelivery(Consumer<? super MessageReference> var1);

    public int getMessageMemoryEstimate();

    public <T> T getProtocolData(Class<T> var1);

    public <T> void setProtocolData(Class<T> var1, T var2);

    public MessageReference copy(Queue var1);

    public long getScheduledDeliveryTime();

    public void setScheduledDeliveryTime(long var1);

    public int getDeliveryCount();

    public void setDeliveryCount(int var1);

    public void setPersistedCount(int var1);

    public int getPersistedCount();

    public void incrementDeliveryCount();

    public void decrementDeliveryCount();

    public Queue getQueue();

    public void acknowledge() throws Exception;

    public void acknowledge(Transaction var1) throws Exception;

    public void acknowledge(Transaction var1, ServerConsumer var2) throws Exception;

    public void acknowledge(Transaction var1, AckReason var2, ServerConsumer var3) throws Exception;

    public void emptyConsumerID();

    public void setConsumerId(long var1);

    public boolean hasConsumerId();

    public long getConsumerId();

    public void handled();

    public void setInDelivery(boolean var1);

    public boolean isInDelivery();

    public void setAlreadyAcked();

    public boolean isAlreadyAcked();

    public long getPersistentSize() throws ActiveMQException;

    public long getSequence();

    public void setSequence(long var1);

    public static final class Factory {
        public static MessageReference createReference(Message encode, Queue queue) {
            return new MessageReferenceImpl(encode, queue);
        }
    }
}

