/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.CapabilityRegistry;
import org.jboss.as.controller.NotificationDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProvidedResourceDefinition;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.AbstractResourceRegistration;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NodeSubregistry;
import org.jboss.as.controller.registry.NotificationEntry;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.as.version.Stability;
import org.wildfly.common.Assert;

final class ConcreteResourceRegistration
extends AbstractResourceRegistration {
    private Map<String, NodeSubregistry> children;
    private Map<String, OperationEntry> operations;
    private Map<String, NotificationEntry> notifications;
    private final ResourceDefinition resourceDefinition;
    private final List<AccessConstraintDefinition> accessConstraintDefinitions;
    private final Map<String, AttributeAccess> attributes = new HashMap<String, AttributeAccess>();
    private Set<String> orderedChildTypes;
    private final boolean runtimeOnly;
    private final boolean ordered;
    private final AccessConstraintUtilizationRegistry constraintUtilizationRegistry;
    private final CapabilityRegistry capabilityRegistry;
    private Set<RuntimeCapability> capabilities;
    private Set<RuntimeCapability> incorporatingCapabilities;
    private Set<CapabilityReferenceRecorder> requirements;
    private final Lock readLock;
    private final Lock writeLock;
    private Map<String, RuntimePackageDependency> additionalPackages;

    ConcreteResourceRegistration(ResourceDefinition definition, AccessConstraintUtilizationRegistry constraintUtilizationRegistry, CapabilityRegistry capabilityRegistry, ProcessType processType, Stability stability) {
        super(processType, stability);
        this.constraintUtilizationRegistry = constraintUtilizationRegistry;
        this.capabilityRegistry = capabilityRegistry;
        this.resourceDefinition = definition;
        this.runtimeOnly = definition.isRuntime();
        this.accessConstraintDefinitions = this.buildAccessConstraints();
        this.ordered = false;
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.readLock = rwLock.readLock();
        this.writeLock = rwLock.writeLock();
    }

    ConcreteResourceRegistration(String valueString, NodeSubregistry parent, ResourceDefinition definition, AccessConstraintUtilizationRegistry constraintUtilizationRegistry, boolean ordered, CapabilityRegistry capabilityRegistry) {
        super(valueString, parent);
        this.constraintUtilizationRegistry = constraintUtilizationRegistry;
        this.capabilityRegistry = capabilityRegistry;
        this.resourceDefinition = definition;
        this.runtimeOnly = parent.isRuntimeOnly() || definition.isRuntime();
        this.accessConstraintDefinitions = this.buildAccessConstraints();
        this.ordered = ordered;
        this.readLock = this.writeLock = new ReentrantLock();
    }

    void beginInitialization() {
        this.writeLock.lock();
    }

    void initialized() {
        this.writeLock.unlock();
    }

    @Override
    public int getMaxOccurs() {
        return this.resourceDefinition.getMaxOccurs();
    }

    @Override
    public int getMinOccurs() {
        return this.resourceDefinition.getMinOccurs();
    }

    @Override
    public boolean isFeature() {
        return this.resourceDefinition.isFeature();
    }

    @Override
    public boolean isRuntimeOnly() {
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            boolean bl = this.runtimeOnly;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isRemote() {
        ConcreteResourceRegistration.checkPermission();
        return false;
    }

    @Override
    public boolean isOrderedChildResource() {
        return this.ordered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Set<String> getOrderedChildTypes(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.getSubregistry(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getOrderedChildTypes(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            HashSet<String> hashSet = this.orderedChildTypes == null ? Collections.emptySet() : new HashSet<String>(this.orderedChildTypes);
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<AccessConstraintDefinition> getAccessConstraints() {
        ConcreteResourceRegistration.checkPermission();
        return this.accessConstraintDefinitions;
    }

    private List<AccessConstraintDefinition> buildAccessConstraints() {
        AbstractResourceRegistration reg = this;
        ArrayList<AccessConstraintDefinition> list = new ArrayList<AccessConstraintDefinition>();
        while (reg != null) {
            ((AbstractResourceRegistration)reg).addAccessConstraints(list);
            NodeSubregistry parent = reg.getParentSubRegistry();
            reg = parent == null ? null : parent.getParent();
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    void addAccessConstraints(List<AccessConstraintDefinition> list) {
        list.addAll(this.resourceDefinition.getAccessConstraints());
    }

    @Override
    public ManagementResourceRegistration registerSubModel(ResourceDefinition resourceDefinition) {
        Assert.checkNotNullParam((String)"resourceDefinition", (Object)resourceDefinition);
        PathElement address = resourceDefinition.getPathElement();
        if (address == null) {
            throw ControllerLogger.ROOT_LOGGER.cannotRegisterSubmodelWithNullPath();
        }
        if (!this.enables(resourceDefinition)) {
            return null;
        }
        ManagementResourceRegistration existing = this.getSubRegistration(PathAddress.pathAddress(address));
        if (existing != null && existing.getPathAddress().getLastElement().getValue().equals(address.getValue())) {
            throw ControllerLogger.ROOT_LOGGER.nodeAlreadyRegistered(existing.getPathAddress().toCLIStyleString());
        }
        NodeSubregistry child = this.getOrCreateSubregistry(address.getKey());
        Stability childStability = resourceDefinition.getStability();
        final Stability parentStability = this.resourceDefinition.getStability();
        return child.registerChild(address.getValue(), childStability != parentStability && !childStability.enables(parentStability) ? new ProvidedResourceDefinition(resourceDefinition){

            @Override
            public Stability getStability() {
                return parentStability;
            }
        } : resourceDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler, boolean inherited) {
        ConcreteResourceRegistration.checkPermission();
        if (this.enables(definition)) {
            boolean filterReplyParameters;
            String opName = definition.getName();
            OperationEntry entry = new OperationEntry(definition, handler, inherited);
            boolean filterParameters = !Stream.of(definition.getParameters()).allMatch(this::enables);
            boolean bl = filterReplyParameters = !Stream.of(definition.getReplyParameters()).allMatch(this::enables);
            if (filterParameters || filterReplyParameters) {
                SimpleOperationDefinitionBuilder builder = SimpleOperationDefinitionBuilder.of(opName, definition);
                if (filterParameters) {
                    builder.setParameters((AttributeDefinition[])Stream.of(definition.getParameters()).filter(this::enables).toArray(AttributeDefinition[]::new));
                }
                if (filterReplyParameters) {
                    builder.setReplyParameters((AttributeDefinition[])Stream.of(definition.getReplyParameters()).filter(this::enables).toArray(AttributeDefinition[]::new));
                }
                entry = new OperationEntry(builder.build(), handler, inherited);
            }
            this.writeLock.lock();
            try {
                if (this.operations == null) {
                    this.operations = new HashMap<String, OperationEntry>();
                } else if (this.operations.containsKey(opName)) {
                    throw this.alreadyRegistered("operation handler", opName);
                }
                this.operations.put(opName, entry);
                if (this.constraintUtilizationRegistry != null) {
                    for (AccessConstraintDefinition acd : definition.getAccessConstraints()) {
                        this.constraintUtilizationRegistry.registerAccessConstraintOperationUtilization(acd.getKey(), this.getPathAddress(), opName);
                    }
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterSubModel(PathElement address) throws IllegalArgumentException {
        this.writeLock.lock();
        try {
            NodeSubregistry subregistry = this.getSubregistry(address.getKey());
            if (subregistry != null) {
                ManagementResourceRegistration registration;
                Set<PathElement> childAddresses = this.getChildAddresses((ListIterator<PathElement>)PathAddress.pathAddress(address).iterator());
                if (childAddresses != null && !(registration = subregistry.getResourceRegistration((ListIterator<PathElement>)PathAddress.EMPTY_ADDRESS.iterator(), address.getValue())).isAlias()) {
                    for (PathElement a : childAddresses) {
                        registration.unregisterSubModel(a);
                    }
                }
                subregistry.unregisterSubModel(address.getValue());
            }
            if (this.constraintUtilizationRegistry != null) {
                this.constraintUtilizationRegistry.unregisterAccessConstraintUtilizations(this.getPathAddress().append(address));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OperationEntry getOperationEntry(ListIterator<PathElement> iterator, String operationName, OperationEntry inherited) {
        OperationEntry entry;
        if (iterator.hasNext()) {
            OperationEntry inheritance;
            NodeSubregistry subregistry;
            PathElement next = iterator.next();
            this.readLock.lock();
            try {
                NodeSubregistry nodeSubregistry = subregistry = this.children == null ? null : this.children.get(next.getKey());
                if (subregistry == null) {
                    OperationEntry operationEntry = null;
                    return operationEntry;
                }
                OperationEntry ourInherited = this.getInheritableOperationEntryLocked(operationName);
                inheritance = ourInherited == null ? inherited : ourInherited;
            }
            finally {
                this.readLock.unlock();
            }
            return subregistry.getOperationEntry(iterator, next.getValue(), operationName, inheritance);
        }
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            entry = this.operations == null ? null : this.operations.get(operationName);
        }
        finally {
            this.readLock.unlock();
        }
        return entry == null ? inherited : entry;
    }

    @Override
    OperationEntry getInheritableOperationEntry(String operationName) {
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            OperationEntry operationEntry = this.getInheritableOperationEntryLocked(operationName);
            return operationEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private OperationEntry getInheritableOperationEntryLocked(String operationName) {
        OperationEntry entry;
        OperationEntry operationEntry = entry = this.operations == null ? null : this.operations.get(operationName);
        if (entry != null && entry.isInherited()) {
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void getOperationDescriptions(ListIterator<PathElement> iterator, Map<String, OperationEntry> providers, boolean inherited) {
        if (!iterator.hasNext()) {
            ConcreteResourceRegistration.checkPermission();
            this.readLock.lock();
            try {
                if (this.operations != null) {
                    providers.putAll(this.operations);
                }
            }
            finally {
                this.readLock.unlock();
            }
            if (inherited) {
                this.getInheritedOperations(providers, true);
            }
            return;
        }
        PathElement next = iterator.next();
        try {
            String key = next.getKey();
            NodeSubregistry subregistry = this.getSubregistry(key);
            if (subregistry != null) {
                subregistry.getHandlers(iterator, next.getValue(), providers, inherited);
            }
        }
        finally {
            iterator.previous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void getInheritedOperationEntries(Map<String, OperationEntry> providers) {
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            if (this.operations != null) {
                for (Map.Entry<String, OperationEntry> entry : this.operations.entrySet()) {
                    if (!entry.getValue().isInherited() || providers.containsKey(entry.getKey())) continue;
                    providers.put(entry.getKey(), entry.getValue());
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void unregisterOperationHandler(String operationName) {
        ConcreteResourceRegistration.checkPermission();
        this.writeLock.lock();
        try {
            if (this.operations == null || this.operations.remove(operationName) == null) {
                throw this.operationNotRegisteredException(operationName, this.resourceDefinition.getPathElement());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void registerReadWriteAttribute(AttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
        assert (definition.getUndefinedMetricValue() == null) : "Attributes cannot have undefined metric value set";
        ConcreteResourceRegistration.checkPermission();
        if (this.isAttributeRegistrationAllowed(definition) && this.enables(definition)) {
            AttributeAccess.Storage storage = definition.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME) ? AttributeAccess.Storage.RUNTIME : AttributeAccess.Storage.CONFIGURATION;
            AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.READ_WRITE, storage, readHandler, writeHandler, definition);
            this.storeAttribute(definition, aa);
        }
    }

    @Override
    public void registerReadOnlyAttribute(AttributeDefinition definition, OperationStepHandler readHandler) {
        assert (definition.getUndefinedMetricValue() == null) : "Attributes cannot have undefined metric value set";
        ConcreteResourceRegistration.checkPermission();
        if (this.isAttributeRegistrationAllowed(definition) && this.enables(definition)) {
            AttributeAccess.Storage storage = definition.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME) ? AttributeAccess.Storage.RUNTIME : AttributeAccess.Storage.CONFIGURATION;
            AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.READ_ONLY, storage, readHandler, null, definition);
            this.storeAttribute(definition, aa);
        }
    }

    @Override
    public void unregisterAttribute(String attributeName) {
        ConcreteResourceRegistration.checkPermission();
        this.writeLock.lock();
        try {
            this.attributes.remove(attributeName);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNotification(NotificationDefinition notification, boolean inherited) {
        ConcreteResourceRegistration.checkPermission();
        if (this.enables(notification)) {
            String type = notification.getType();
            NotificationEntry entry = new NotificationEntry(notification.getDescriptionProvider(), inherited);
            this.writeLock.lock();
            try {
                if (this.notifications == null) {
                    this.notifications = Collections.singletonMap(type, entry);
                } else {
                    if (this.notifications.containsKey(type)) {
                        throw this.alreadyRegistered("notification", type);
                    }
                    if (this.notifications.size() == 1) {
                        this.notifications = new HashMap<String, NotificationEntry>(this.notifications);
                    }
                    this.notifications.put(type, entry);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public void registerNotification(NotificationDefinition notification) {
        this.registerNotification(notification, false);
    }

    @Override
    public void unregisterNotification(String notificationType) {
        ConcreteResourceRegistration.checkPermission();
        this.writeLock.lock();
        try {
            if (this.notifications != null) {
                this.notifications.remove(notificationType);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void registerMetric(AttributeDefinition definition, OperationStepHandler metricHandler) {
        assert (this.assertMetricValues(definition));
        ConcreteResourceRegistration.checkPermission();
        if (this.isAttributeRegistrationAllowed(definition) && !this.isProfileResource() && this.enables(definition)) {
            AttributeAccess aa = new AttributeAccess(AttributeAccess.AccessType.METRIC, AttributeAccess.Storage.RUNTIME, metricHandler, null, definition);
            this.storeAttribute(definition, aa);
        }
    }

    private boolean isAttributeRegistrationAllowed(AttributeDefinition definition) {
        boolean runtime = definition.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME);
        if (!runtime) {
            return true;
        }
        boolean runtimeServiceNotRequired = definition.getFlags().contains(AttributeAccess.Flag.RUNTIME_SERVICE_NOT_REQUIRED);
        if (runtimeServiceNotRequired) {
            return true;
        }
        return this.getProcessType().isServer();
    }

    private boolean isProfileResource() {
        return !this.getProcessType().isServer() && this.getPathAddress().size() > 1 && "profile".equals(this.getPathAddress().getElement(0).getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAttribute(AttributeDefinition definition, AttributeAccess aa) {
        String attributeName = definition.getName();
        this.writeLock.lock();
        try {
            if (this.attributes.containsKey(attributeName)) {
                throw this.alreadyRegistered("attribute", attributeName);
            }
            this.attributes.put(attributeName, aa);
            this.registerAttributeAccessConstraints(definition);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean assertMetricValues(AttributeDefinition definition) {
        if (!definition.isRequired() && definition.getUndefinedMetricValue() != null) assert (false) : "Nillable metric has an undefined metric value for '" + definition.getName() + "'";
        if (definition.getDefaultValue() != null) assert (false) : "Metrics cannot have a default value for '" + definition.getName() + "'";
        return true;
    }

    private void registerAttributeAccessConstraints(AttributeDefinition ad) {
        if (this.constraintUtilizationRegistry != null) {
            for (AccessConstraintDefinition acd : ad.getAccessConstraints()) {
                this.constraintUtilizationRegistry.registerAccessConstraintAttributeUtilization(acd.getKey(), this.getPathAddress(), ad.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void getNotificationDescriptions(ListIterator<PathElement> iterator, Map<String, NotificationEntry> providers, boolean inherited) {
        if (!iterator.hasNext()) {
            ConcreteResourceRegistration.checkPermission();
            this.readLock.lock();
            try {
                if (this.notifications != null) {
                    providers.putAll(this.notifications);
                }
            }
            finally {
                this.readLock.unlock();
            }
            if (inherited) {
                this.getInheritedNotifications(providers, true);
            }
            return;
        }
        PathElement next = iterator.next();
        try {
            String key = next.getKey();
            NodeSubregistry subregistry = this.getSubregistry(key);
            if (subregistry != null) {
                subregistry.getNotificationDescriptions(iterator, next.getValue(), providers, inherited);
            }
        }
        finally {
            iterator.previous();
        }
    }

    private NodeSubregistry getSubregistry(String key) {
        this.readLock.lock();
        try {
            NodeSubregistry nodeSubregistry = this.children == null ? null : this.children.get(key);
            return nodeSubregistry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void getInheritedNotificationEntries(Map<String, NotificationEntry> providers) {
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            if (this.notifications != null) {
                for (Map.Entry<String, NotificationEntry> entry : this.notifications.entrySet()) {
                    if (!entry.getValue().isInherited() || providers.containsKey(entry.getKey())) continue;
                    providers.put(entry.getKey(), entry.getValue());
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Set<RuntimeCapability> getCapabilities(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.getSubregistry(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getCapabilities(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            Set<RuntimeCapability> set = this.capabilities == null ? Collections.emptySet() : Collections.unmodifiableSet(this.capabilities);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Set<RuntimeCapability> getIncorporatingCapabilities(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.getSubregistry(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getIncorporatingCapabilities(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            Set<Object> result = this.incorporatingCapabilities != null ? this.incorporatingCapabilities : (this.capabilities != null && !this.capabilities.isEmpty() ? Collections.emptySet() : null);
            Set<RuntimeCapability> set = result;
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void registerProxyController(PathElement address, ProxyController controller) throws IllegalArgumentException {
        ManagementResourceRegistration existing = this.getSubRegistration(PathAddress.pathAddress(address));
        if (existing != null && existing.getPathAddress().getLastElement().getValue().equals(address.getValue())) {
            throw ControllerLogger.ROOT_LOGGER.nodeAlreadyRegistered(existing.getPathAddress().toCLIStyleString());
        }
        this.getOrCreateSubregistry(address.getKey()).registerProxyController(address.getValue(), controller);
    }

    @Override
    public void unregisterProxyController(PathElement address) throws IllegalArgumentException {
        NodeSubregistry subregistry = this.getSubregistry(address.getKey());
        if (subregistry != null) {
            subregistry.unregisterProxyController(address.getValue());
        }
    }

    @Override
    public void registerAlias(PathElement address, AliasEntry alias, AbstractResourceRegistration target) {
        this.getOrCreateSubregistry(address.getKey()).registerAlias(address.getValue(), alias, target);
    }

    @Override
    public void unregisterAlias(PathElement address) {
        NodeSubregistry subregistry = this.getSubregistry(address.getKey());
        if (subregistry != null) {
            subregistry.unregisterAlias(address.getValue());
        }
    }

    @Override
    public void registerCapability(RuntimeCapability capability) {
        if (this.enables(capability)) {
            this.writeLock.lock();
            try {
                if (this.capabilities == null) {
                    this.capabilities = new HashSet<RuntimeCapability>();
                }
                this.capabilities.add(capability);
                if (this.capabilityRegistry != null) {
                    this.capabilityRegistry.registerPossibleCapability(capability, this.getPathAddress());
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public void registerIncorporatingCapabilities(Set<RuntimeCapability> capabilities) {
        this.writeLock.lock();
        try {
            this.incorporatingCapabilities = capabilities == null ? null : (capabilities.isEmpty() ? Collections.emptySet() : capabilities.stream().filter(this::enables).collect(Collectors.toUnmodifiableSet()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void registerRequirements(Set<? extends CapabilityReferenceRecorder> requirements) {
        this.writeLock.lock();
        try {
            this.requirements = requirements == null || requirements.isEmpty() ? Collections.emptySet() : requirements.stream().filter(this::enables).collect(Collectors.toUnmodifiableSet());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Set<CapabilityReferenceRecorder> getRequirements(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.getSubregistry(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getRequirements(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            Set<CapabilityReferenceRecorder> set = this.requirements == null ? Collections.emptySet() : Collections.unmodifiableSet(this.requirements);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeSubregistry getOrCreateSubregistry(String key) {
        this.writeLock.lock();
        try {
            NodeSubregistry subregistry;
            NodeSubregistry nodeSubregistry = subregistry = this.children == null ? null : this.children.get(key);
            if (subregistry != null) {
                NodeSubregistry nodeSubregistry2 = subregistry;
                return nodeSubregistry2;
            }
            ConcreteResourceRegistration.checkPermission();
            NodeSubregistry newRegistry = new NodeSubregistry(key, this, this.constraintUtilizationRegistry, this.capabilityRegistry);
            if (this.children == null) {
                this.children = Collections.singletonMap(key, newRegistry);
            } else {
                if (this.children.size() == 1) {
                    this.children = new HashMap<String, NodeSubregistry>(this.children);
                }
                this.children.put(key, newRegistry);
            }
            NodeSubregistry nodeSubregistry3 = newRegistry;
            return nodeSubregistry3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    DescriptionProvider getModelDescription(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.getSubregistry(next.getKey());
            if (subregistry == null) {
                return null;
            }
            return subregistry.getModelDescription(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        return this.resourceDefinition.getDescriptionProvider(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Set<String> getAttributeNames(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.getSubregistry(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getAttributeNames(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.attributes.keySet());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    AttributeAccess getAttributeAccess(ListIterator<PathElement> iterator, String attributeName) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.getSubregistry(next.getKey());
            if (subregistry == null) {
                return null;
            }
            return subregistry.getAttributeAccess(iterator, next.getValue(), attributeName);
        }
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            AttributeAccess attributeAccess = this.attributes.get(attributeName);
            return attributeAccess;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Map<String, AttributeAccess> getAttributes(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.getSubregistry(next.getKey());
            if (subregistry == null) {
                return Collections.emptyMap();
            }
            return subregistry.getAttributes(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            HashMap<String, AttributeAccess> hashMap = new HashMap<String, AttributeAccess>(this.attributes);
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Set<String> getChildNames(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.getSubregistry(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getChildNames(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            if (this.children != null) {
                Set<String> set = Collections.unmodifiableSet(this.children.keySet());
                return set;
            }
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Set<PathElement> getChildAddresses(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.getSubregistry(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getChildAddresses(iterator, next.getValue());
        }
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            if (this.children != null) {
                HashSet<PathElement> elements = new HashSet<PathElement>();
                for (Map.Entry<String, NodeSubregistry> entry : this.children.entrySet()) {
                    for (String entryChild : entry.getValue().getChildNames()) {
                        elements.add(PathElement.pathElement(entry.getKey(), entryChild));
                    }
                }
                HashSet<PathElement> hashSet = elements;
                return hashSet;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Collections.emptySet();
    }

    @Override
    ProxyController getProxyController(ListIterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.getSubregistry(next.getKey());
            if (subregistry == null) {
                return null;
            }
            return subregistry.getProxyController(iterator, next.getValue());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void getProxyControllers(ListIterator<PathElement> iterator, Set<ProxyController> controllers) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.getSubregistry(next.getKey());
            if (subregistry == null) {
                return;
            }
            if (next.isWildcard()) {
                subregistry.getProxyControllers(iterator, null, controllers);
                return;
            } else if (next.isMultiTarget()) {
                for (String value : next.getSegments()) {
                    subregistry.getProxyControllers(iterator, value, controllers);
                }
                return;
            } else {
                subregistry.getProxyControllers(iterator, next.getValue(), controllers);
            }
            return;
        } else {
            this.readLock.lock();
            try {
                if (this.children == null) return;
                for (NodeSubregistry subregistry : this.children.values()) {
                    subregistry.getProxyControllers(iterator, null, controllers);
                }
                return;
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    @Override
    ManagementResourceRegistration getResourceRegistration(ListIterator<PathElement> iterator) {
        if (!iterator.hasNext()) {
            ConcreteResourceRegistration.checkPermission();
            return this;
        }
        PathElement address = iterator.next();
        NodeSubregistry subregistry = this.getSubregistry(address.getKey());
        if (subregistry != null) {
            return subregistry.getResourceRegistration(iterator, address.getValue());
        }
        return null;
    }

    private IllegalArgumentException alreadyRegistered(String type, String name) {
        return ControllerLogger.ROOT_LOGGER.alreadyRegistered(type, name, this.getLocationString());
    }

    private IllegalArgumentException operationNotRegisteredException(String op, PathElement address) {
        return ControllerLogger.ROOT_LOGGER.operationNotRegisteredException(op, PathAddress.pathAddress(address));
    }

    @Override
    public AliasEntry getAliasEntry() {
        ConcreteResourceRegistration.checkPermission();
        return null;
    }

    @Override
    protected void setOrderedChild(String type) {
        this.writeLock.lock();
        try {
            if (this.orderedChildTypes == null) {
                this.orderedChildTypes = Collections.singleton(type);
            } else {
                if (this.orderedChildTypes.size() == 1) {
                    this.orderedChildTypes = new HashSet<String>(this.orderedChildTypes);
                }
                this.orderedChildTypes.add(type);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAdditionalRuntimePackages(RuntimePackageDependency ... pkgs) {
        if (pkgs.length > 0) {
            this.writeLock.lock();
            try {
                if (this.additionalPackages == null) {
                    this.additionalPackages = new HashMap<String, RuntimePackageDependency>();
                }
                for (RuntimePackageDependency pkg : pkgs) {
                    if (this.additionalPackages.containsKey(pkg.getName())) {
                        ControllerLogger.ROOT_LOGGER.runtimePackageDependencyAlreadyRegistered(pkg.getName(), this.getLocationString());
                        continue;
                    }
                    this.additionalPackages.put(pkg.getName(), pkg);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public Set<RuntimePackageDependency> getAdditionalRuntimePackages() {
        ConcreteResourceRegistration.checkPermission();
        this.readLock.lock();
        try {
            Set<RuntimePackageDependency> set = this.additionalPackages == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<RuntimePackageDependency>(this.additionalPackages.values()));
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Stability getStability() {
        return this.resourceDefinition.getStability();
    }
}

