/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation;

import java.util.Set;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingConfigurationContext;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.jboss.jandex.IndexView;

@Incubating
public abstract class AnnotatedTypeSource {
    public static AnnotatedTypeSource fromClasses(Class<?> clazz, Class<?> ... otherClasses) {
        return AnnotatedTypeSource.fromClasses(Set.copyOf(CollectionHelper.asList(clazz, (Object[])otherClasses)));
    }

    public static AnnotatedTypeSource fromClasses(final Set<Class<?>> annotatedClasses) {
        return new AnnotatedTypeSource(){

            @Override
            public void apply(AnnotationMappingConfigurationContext context) {
                context.add(annotatedClasses);
            }
        };
    }

    public static AnnotatedTypeSource empty() {
        return new AnnotatedTypeSource(){

            @Override
            public void apply(AnnotationMappingConfigurationContext context) {
            }
        };
    }

    public static AnnotatedTypeSource fromJandexIndex(final IndexView jandexIndex) {
        return new AnnotatedTypeSource(){

            @Override
            public void apply(AnnotationMappingConfigurationContext context) {
                context.addJandexIndex(jandexIndex);
            }
        };
    }

    private AnnotatedTypeSource() {
    }

    public abstract void apply(AnnotationMappingConfigurationContext var1);
}

