/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.logging;

import java.security.Permission;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.as.naming.subsystem.BindingType;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYNAM", length=4)
public interface NamingLogger
extends BasicLogger {
    public static final NamingLogger ROOT_LOGGER = (NamingLogger)Logger.getMessageLogger(NamingLogger.class, (String)"org.jboss.as.naming");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating Naming Subsystem")
    public void activatingSubsystem();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Failed to set %s")
    public void failedToSet(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Starting Naming Service")
    public void startingService();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12, value="Failed to release binder service, used for a runtime made JNDI binding")
    public void failedToReleaseBinderService(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=13, value="Failed to obtain jndi view value for entry %s.")
    public void failedToLookupJndiViewValue(String var1, @Cause Throwable var2);

    @Message(id=14, value="Attempt to add a Permission to a readonly PermissionCollection")
    public SecurityException cannotAddToReadOnlyPermissionCollection();

    @Message(id=15, value="%s cannot be null.")
    public String cannotBeNull(String var1);

    @Message(id=16, value="Could not dereference object")
    public NamingException cannotDeferenceObject(@Cause Throwable var1);

    @Message(id=17, value="Unable to list a non Context binding.")
    public NamingException cannotListNonContextBinding();

    @Message(id=18, value="Could not lookup link")
    public String cannotLookupLink();

    @Message(id=20, value="Could not resolve service %s")
    public NamingException cannotResolveService(ServiceName var1);

    @Message(id=21, value="Could not resolve service reference to %s in factory %s. Service was in state %s.")
    public NamingException cannotResolveService(ServiceName var1, String var2, String var3);

    @Message(id=22, value="Could not resolve service reference to %s in factory %s. This is a bug in ServiceReferenceObjectFactory. State was %s.")
    public NamingException cannotResolveServiceBug(ServiceName var1, String var2, String var3);

    @Message(id=23, value="Duplicate JNDI bindings for '%s' are not compatible.  [%s] != [%s]")
    public String duplicateBinding(JndiName var1, Object var2, Object var3);

    @Message(id=24, value="An empty name is not allowed")
    public InvalidNameException emptyNameNotAllowed();

    @Message(id=25, value="Jndi entry '%s' is not yet registered in context '%s'")
    public IllegalStateException entryNotRegistered(@Cause Throwable var1, String var2, Context var3);

    @Message(id=26, value="Failed to destroy root context")
    public IllegalStateException failedToDestroyRootContext(@Cause Throwable var1);

    @Message(id=27, value="Failed instantiate %s %s from classloader %s")
    public NamingException failedToInstantiate(@Cause Throwable var1, String var2, String var3, ClassLoader var4);

    @Message(id=28, value="Failed to read %s context entries.")
    public String failedToReadContextEntries(String var1);

    @Message(id=29, value="Failed to start %s")
    public String failedToStart(String var1);

    @Message(id=30, value="Illegal context in name: %s")
    public RuntimeException illegalContextInName(String var1);

    @Message(id=32, value="Invalid context reference.  Not a '%s' reference.")
    public NamingException invalidContextReference(String var1);

    @Message(id=33, value="A valid JNDI name must be provided: %s")
    public IllegalArgumentException invalidJndiName(String var1);

    @Message(id=34, value="Load factor must be greater than 0 and less than or equal to 1")
    public IllegalArgumentException invalidLoadFactor();

    @Message(id=35, value="invalid permission, unknown action: %s")
    public IllegalArgumentException invalidPermission(Permission var1);

    @Message(id=36, value="invalid permission, unknown action: %s")
    public IllegalArgumentException invalidPermissionAction(String var1);

    @Message(id=37, value="Can not have a negative size table!")
    public IllegalArgumentException invalidTableSize();

    @Message(id=38, value="Jndi view is only available in runtime mode.")
    public String jndiViewNotAvailable();

    @Message(id=39, value="Name '%s' not found in context '%s'")
    public NameNotFoundException nameNotFoundInContext(String var1, Name var2);

    @Message(id=41, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=42, value="Failed to create object factory from classloader.")
    public NamingException objectFactoryCreationFailure(@Cause Throwable var1);

    @Message(id=43, value="Naming context is read-only")
    public OperationNotSupportedException readOnlyNamingContext();

    @Message(id=44, value="Service with name [%s] already bound.")
    public IllegalArgumentException serviceAlreadyBound(ServiceName var1);

    @Message(id=45, value="Table is full!")
    public IllegalStateException tableIsFull();

    @Message(id=46, value="Thread interrupted while retrieving service reference for service %s")
    public NamingException threadInterrupt(ServiceName var1);

    @Message(id=47, value="Invalid name for context binding %s")
    public DeploymentUnitProcessingException invalidNameForContextBinding(String var1);

    @Message(id=48, value="Invalid binding name %s, name must start with one of %s")
    public OperationFailedException invalidNamespaceForBinding(String var1, String var2);

    @Message(id=49, value="Unknown binding type %s")
    public OperationFailedException unknownBindingType(String var1);

    @Message(id=50, value="Unsupported simple binding type %s")
    public OperationFailedException unsupportedSimpleBindingType(String var1);

    @Message(id=51, value="Unable to transform URL binding value %s")
    public OperationFailedException unableToTransformURLBindingValue(String var1, @Cause Throwable var2);

    @Message(id=52, value="Could not load module %s")
    public OperationFailedException couldNotLoadModule(ModuleIdentifier var1);

    @Message(id=53, value="Could not load class %s from module %s")
    public OperationFailedException couldNotLoadClassFromModule(String var1, ModuleIdentifier var2);

    @Message(id=54, value="Could not instantiate instance of class %s from module %s")
    public OperationFailedException couldNotInstantiateClassInstanceFromModule(String var1, ModuleIdentifier var2);

    @Message(id=55, value="Class %s from module %s is not an instance of ObjectFactory")
    public OperationFailedException notAnInstanceOfObjectFactory(String var1, ModuleIdentifier var2);

    @Message(id=59, value="Resource lookup for injection failed: %s")
    public RuntimeException resourceLookupForInjectionFailed(String var1, @Cause Throwable var2);

    @Message(id=60, value="Binding type %s requires attribute named %s defined")
    public OperationFailedException bindingTypeRequiresAttributeDefined(BindingType var1, String var2);

    @Message(id=61, value="Binding type %s can not take a 'cache' attribute")
    public OperationFailedException cacheNotValidForBindingType(BindingType var1);

    @Message(id=62, value="Failed to lookup %s")
    public NamingException lookupError(@Cause Throwable var1, String var2);

    @Message(id=63, value="%s service not started")
    public IllegalStateException serviceNotStarted(ServiceName var1);

    @Message(id=64, value="Cannot rebind external context lookup")
    public OperationFailedException cannotRebindExternalContext();

    @Message(id=65, value="Could not load module %s - the module or one of its dependencies is missing [%s]")
    public OperationFailedException moduleNotFound(ModuleIdentifier var1, String var2);

    @Message(id=66, value="Failed to start remote naming service")
    public StartException failedToStartRemoteNamingService(@Cause Throwable var1);

    @Message(id=67, value="Failed to stop remote naming service")
    public IllegalStateException failedToStopRemoteNamingService(@Cause Throwable var1);
}

