/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.sql.SQLException;
import org.jboss.jca.adapters.jdbc.CachedPreparedStatement;
import org.jboss.jca.adapters.jdbc.statistics.JdbcStatisticsPlugin;
import org.jboss.jca.adapters.jdbc.util.Cache;
import org.jboss.jca.adapters.jdbc.util.CacheListener;
import org.jboss.jca.adapters.jdbc.util.LRUCache;
import org.jboss.logging.Logger;

public class PreparedStatementCache
implements CacheListener<CachedPreparedStatement> {
    private final Logger log = Logger.getLogger(this.getClass());
    private Cache<Key, CachedPreparedStatement> cache;
    private JdbcStatisticsPlugin statistics;

    public PreparedStatementCache(int max, JdbcStatisticsPlugin stats) {
        this.cache = new LRUCache<Key, CachedPreparedStatement>(max);
        this.cache.setListener(this);
        this.statistics = stats;
    }

    public CachedPreparedStatement get(Key key) {
        return this.cache.get(key);
    }

    public void put(Key key, CachedPreparedStatement value) {
        this.cache.insert(key, value);
    }

    public int size() {
        return this.cache.size();
    }

    @Override
    public void onEviction(CachedPreparedStatement evicted) {
        if (evicted != null) {
            try {
                evicted.agedOut();
            }
            catch (SQLException e) {
                this.log.debug((Object)"Failed closing cached statement", (Throwable)e);
            }
            finally {
                this.statistics.deltaPreparedStatementCacheDeleteCount();
            }
        }
    }

    void flush() {
        this.cache.flush();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PreparedStatementCache size: ").append(this.size()).append(" ");
        sb.append(this.cache);
        return sb.toString();
    }

    public static class Key {
        public static final int PREPARED_STATEMENT = 1;
        public static final int CALLABLE_STATEMENT = 2;
        private final String sql;
        private final int type;
        private final int resultSetType;
        private final int resultSetConcurrency;

        public Key(String sql, int type, int resultSetType, int resultSetConcurrency) {
            this.sql = sql;
            this.type = type;
            this.resultSetType = resultSetType;
            this.resultSetConcurrency = resultSetConcurrency;
        }

        public String getSql() {
            return this.sql;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.resultSetConcurrency != key.resultSetConcurrency) {
                return false;
            }
            if (this.resultSetType != key.resultSetType) {
                return false;
            }
            if (this.type != key.type) {
                return false;
            }
            return !(this.sql == null ? key.sql != null : !this.sql.equals(key.sql));
        }

        public int hashCode() {
            int result = this.sql != null ? this.sql.hashCode() : 0;
            result = 29 * result + this.type;
            result = 29 * result + this.resultSetType;
            result = 29 * result + this.resultSetConcurrency;
            return result;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer(super.toString());
            tmp.append('[');
            tmp.append("sql=");
            tmp.append(this.sql);
            tmp.append(" type=");
            tmp.append(this.type == 1 ? "PS" : "CS");
            tmp.append(" resultSetType=");
            switch (this.resultSetType) {
                case 1003: {
                    tmp.append("TYPE_FORWARD_ONLY");
                    break;
                }
                case 1004: {
                    tmp.append("TYPE_SCROLL_INSENSITIVE");
                    break;
                }
                case 1005: {
                    tmp.append("TYPE_SCROLL_SENSITIVE");
                    break;
                }
                default: {
                    tmp.append(this.resultSetType);
                }
            }
            tmp.append(" resultSetConcurrency=");
            switch (this.resultSetConcurrency) {
                case 1007: {
                    tmp.append("CONCUR_READ_ONLY");
                    break;
                }
                case 1008: {
                    tmp.append("CONCUR_UPDATABLE");
                    break;
                }
                default: {
                    tmp.append(this.resultSetConcurrency);
                }
            }
            tmp.append(']');
            return tmp.toString();
        }
    }
}

