/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.ActiveMQLargeMessageInterruptedException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.LargeMessageController;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.UTF8Util;

public class LargeMessageControllerImpl
implements LargeMessageController {
    private static final String READ_ONLY_ERROR_MESSAGE = "This is a read-only buffer, setOperations are not supported";
    private final ClientConsumerInternal consumerInternal;
    private final LinkedBlockingQueue<LargeData> largeMessageData = new LinkedBlockingQueue();
    private volatile LargeData currentPacket = null;
    private final long totalSize;
    private final int bufferSize;
    private boolean streamEnded = false;
    private boolean streamClosed = false;
    private final long readTimeout;
    private long readerIndex = 0L;
    private boolean packetAdded = false;
    private long packetPosition = -1L;
    private long lastIndex = 0L;
    private long packetLastPosition = -1L;
    private long bytesTaken = 0L;
    private OutputStream outStream;
    private volatile Exception handledException;
    private final FileCache fileCache;
    private boolean local = false;

    public LargeMessageControllerImpl(ClientConsumerInternal consumerInternal, long totalSize, long readTimeout) {
        this(consumerInternal, totalSize, readTimeout, null);
    }

    public LargeMessageControllerImpl(ClientConsumerInternal consumerInternal, long totalSize, long readTimeout, File cachedFile) {
        this(consumerInternal, totalSize, readTimeout, cachedFile, 10240);
    }

    public LargeMessageControllerImpl(ClientConsumerInternal consumerInternal, long totalSize, long readTimeout, File cachedFile, int bufferSize) {
        this.consumerInternal = consumerInternal;
        this.readTimeout = readTimeout;
        this.totalSize = totalSize;
        this.fileCache = cachedFile == null ? null : new FileCache(cachedFile);
        this.bufferSize = bufferSize;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    @Override
    public void discardUnusedPackets() {
        if (this.outStream == null) {
            if (this.local) {
                return;
            }
            try {
                this.checkForPacket(this.totalSize - 1L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void addPacket(byte[] chunk, int flowControlSize, boolean isContinues) {
        flowControlCredit = 0;
        var5_5 = this;
        synchronized (var5_5) {
            this.packetAdded = true;
            if (this.outStream != null) {
                try {
                    if (!isContinues) {
                        this.streamEnded = true;
                    }
                    if (this.fileCache != null) {
                        this.fileCache.cachePackage(chunk);
                    }
                    this.outStream.write(chunk);
                    flowControlCredit = flowControlSize;
                    if (!this.streamEnded) ** GOTO lbl36
                    this.outStream.close();
                }
                catch (Exception e) {
                    ActiveMQClientLogger.LOGGER.errorAddingPacket(e);
                    this.handledException = e;
                }
                finally {
                    this.notifyAll();
                }
            } else {
                if (this.fileCache != null) {
                    try {
                        this.fileCache.cachePackage(chunk);
                    }
                    catch (Exception e) {
                        ActiveMQClientLogger.LOGGER.errorAddingPacket(e);
                        this.handledException = e;
                    }
                }
                this.largeMessageData.offer(new LargeData(chunk, flowControlSize, isContinues));
            }
        }
lbl36:
        // 4 sources

        if (flowControlCredit != 0) {
            try {
                this.consumerInternal.flowControl(flowControlCredit, isContinues == false);
            }
            catch (Exception e) {
                ActiveMQClientLogger.LOGGER.errorAddingPacket(e);
                this.handledException = e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.handledException = ActiveMQClientMessageBundle.BUNDLE.largeMessageInterrupted();
        LargeMessageControllerImpl largeMessageControllerImpl = this;
        synchronized (largeMessageControllerImpl) {
            int totalSize = 0;
            LargeData polledPacket = null;
            while ((polledPacket = this.largeMessageData.poll()) != null) {
                totalSize += polledPacket.getFlowControlSize();
            }
            try {
                this.consumerInternal.flowControl(totalSize, false);
            }
            catch (Exception ignored) {
                ActiveMQClientLogger.LOGGER.errorCallingCancel(ignored);
            }
            this.largeMessageData.offer(new LargeData());
            this.streamEnded = true;
            this.streamClosed = true;
            this.notifyAll();
        }
    }

    @Override
    public synchronized void close() {
        if (this.fileCache != null) {
            this.fileCache.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputStream(OutputStream output) throws ActiveMQException {
        int totalFlowControl = 0;
        boolean continues = false;
        LargeMessageControllerImpl largeMessageControllerImpl = this;
        synchronized (largeMessageControllerImpl) {
            LargeData packet;
            if (this.currentPacket != null) {
                this.sendPacketToOutput(output, this.currentPacket);
                this.currentPacket = null;
            }
            while (this.handledException == null && (packet = this.largeMessageData.poll()) != null) {
                totalFlowControl += packet.getFlowControlSize();
                continues = packet.isContinues();
                this.sendPacketToOutput(output, packet);
            }
            this.checkException();
            this.outStream = output;
        }
        if (totalFlowControl > 0) {
            this.consumerInternal.flowControl(totalFlowControl, !continues);
        }
    }

    @Override
    public synchronized void saveBuffer(OutputStream output) throws ActiveMQException {
        if (this.streamClosed) {
            throw ActiveMQClientMessageBundle.BUNDLE.largeMessageLostSession();
        }
        this.setOutputStream(output);
        this.waitCompletion(0L);
    }

    @Override
    public synchronized boolean waitCompletion(long timeWait) throws ActiveMQException {
        if (this.outStream == null) {
            return false;
        }
        long timeOut = timeWait != 0L ? System.currentTimeMillis() + timeWait : System.currentTimeMillis() + this.readTimeout;
        while (!this.streamEnded && this.handledException == null) {
            try {
                this.wait(timeWait == 0L ? this.readTimeout : timeWait);
            }
            catch (InterruptedException e) {
                throw new ActiveMQInterruptedException(e);
            }
            if (!this.streamEnded && this.handledException == null) {
                if (timeWait != 0L && System.currentTimeMillis() > timeOut) {
                    throw ActiveMQClientMessageBundle.BUNDLE.timeoutOnLargeMessage();
                }
                if (System.currentTimeMillis() > timeOut && !this.packetAdded) {
                    throw ActiveMQClientMessageBundle.BUNDLE.timeoutOnLargeMessage();
                }
            }
            this.packetAdded = false;
        }
        this.checkException();
        return this.streamEnded;
    }

    @Override
    public LargeData take() throws InterruptedException {
        LargeData largeData = this.largeMessageData.take();
        if (largeData == null) {
            return null;
        }
        this.bytesTaken += (long)largeData.getChunk().length;
        return largeData;
    }

    private void checkException() throws ActiveMQException {
        if (this.handledException != null) {
            if (this.handledException instanceof ActiveMQException) {
                ActiveMQException nestedException = this.handledException instanceof ActiveMQLargeMessageInterruptedException ? new ActiveMQLargeMessageInterruptedException(this.handledException.getMessage()) : new ActiveMQException(((ActiveMQException)this.handledException).getType(), this.handledException.getMessage());
                nestedException.initCause(this.handledException);
                throw nestedException;
            }
            throw new ActiveMQException(ActiveMQExceptionType.LARGE_MESSAGE_ERROR_BODY, "Error on saving LargeMessageBufferImpl", this.handledException);
        }
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    public byte readByte() {
        return this.getByte(this.readerIndex++);
    }

    @Override
    public byte getByte(int index) {
        return this.getByte((long)index);
    }

    private byte getByte(long index) {
        this.checkForPacket(index);
        if (this.fileCache != null && index < this.packetPosition) {
            return this.fileCache.getByteFromCache(index);
        }
        return this.currentPacket.getChunk()[(int)(index - this.packetPosition)];
    }

    @Override
    public void getBytes(int index, ActiveMQBuffer dst, int dstIndex, int length) {
        byte[] destBytes = new byte[length];
        this.getBytes(index, destBytes);
        dst.setBytes(dstIndex, destBytes);
    }

    private void getBytes(long index, ActiveMQBuffer dst, int dstIndex, int length) {
        byte[] destBytes = new byte[length];
        this.getBytes(index, destBytes);
        dst.setBytes(dstIndex, destBytes);
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        byte[] bytesToGet = new byte[length];
        this.getBytes(index, bytesToGet);
        System.arraycopy(bytesToGet, 0, dst, dstIndex, length);
    }

    public void getBytes(long index, byte[] dst, int dstIndex, int length) {
        byte[] bytesToGet = new byte[length];
        this.getBytes(index, bytesToGet);
        System.arraycopy(bytesToGet, 0, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        byte[] bytesToGet = new byte[dst.remaining()];
        this.getBytes(index, bytesToGet);
        dst.put(bytesToGet);
    }

    public void getBytes(long index, ByteBuffer dst) {
        byte[] bytesToGet = new byte[dst.remaining()];
        this.getBytes(index, bytesToGet);
        dst.put(bytesToGet);
    }

    public void getBytes(int index, OutputStream out, int length) throws IOException {
        byte[] bytesToGet = new byte[length];
        this.getBytes(index, bytesToGet);
        out.write(bytesToGet);
    }

    public void getBytes(long index, OutputStream out, int length) throws IOException {
        byte[] bytesToGet = new byte[length];
        this.getBytes(index, bytesToGet);
        out.write(bytesToGet);
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        byte[] bytesToGet = new byte[length];
        this.getBytes(index, bytesToGet);
        return out.write(ByteBuffer.wrap(bytesToGet));
    }

    @Override
    public int getInt(int index) {
        return (this.getByte(index) & 0xFF) << 24 | (this.getByte(index + 1) & 0xFF) << 16 | (this.getByte(index + 2) & 0xFF) << 8 | (this.getByte(index + 3) & 0xFF) << 0;
    }

    public int getInt(long index) {
        return (this.getByte(index) & 0xFF) << 24 | (this.getByte(index + 1L) & 0xFF) << 16 | (this.getByte(index + 2L) & 0xFF) << 8 | (this.getByte(index + 3L) & 0xFF) << 0;
    }

    @Override
    public long getLong(int index) {
        return ((long)this.getByte(index) & 0xFFL) << 56 | ((long)this.getByte(index + 1) & 0xFFL) << 48 | ((long)this.getByte(index + 2) & 0xFFL) << 40 | ((long)this.getByte(index + 3) & 0xFFL) << 32 | ((long)this.getByte(index + 4) & 0xFFL) << 24 | ((long)this.getByte(index + 5) & 0xFFL) << 16 | ((long)this.getByte(index + 6) & 0xFFL) << 8 | ((long)this.getByte(index + 7) & 0xFFL) << 0;
    }

    public long getLong(long index) {
        return ((long)this.getByte(index) & 0xFFL) << 56 | ((long)this.getByte(index + 1L) & 0xFFL) << 48 | ((long)this.getByte(index + 2L) & 0xFFL) << 40 | ((long)this.getByte(index + 3L) & 0xFFL) << 32 | ((long)this.getByte(index + 4L) & 0xFFL) << 24 | ((long)this.getByte(index + 5L) & 0xFFL) << 16 | ((long)this.getByte(index + 6L) & 0xFFL) << 8 | ((long)this.getByte(index + 7L) & 0xFFL) << 0;
    }

    @Override
    public short getShort(int index) {
        return (short)(this.getByte(index) << 8 | this.getByte(index + 1) & 0xFF);
    }

    public short getShort(long index) {
        return (short)(this.getByte(index) << 8 | this.getByte(index + 1L) & 0xFF);
    }

    private int getUnsignedMedium(int index) {
        return (this.getByte(index) & 0xFF) << 16 | (this.getByte(index + 1) & 0xFF) << 8 | (this.getByte(index + 2) & 0xFF) << 0;
    }

    public int getUnsignedMedium(long index) {
        return (this.getByte(index) & 0xFF) << 16 | (this.getByte(index + 1L) & 0xFF) << 8 | (this.getByte(index + 2L) & 0xFF) << 0;
    }

    @Override
    public void setByte(int index, byte value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void setBytes(int index, ActiveMQBuffer src, int srcIndex, int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void setInt(int index, int value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void setLong(int index, long value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void setShort(int index, short value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void release() {
    }

    @Override
    public int readerIndex() {
        return (int)this.readerIndex;
    }

    @Override
    public void readerIndex(int readerIndex) {
        try {
            this.checkForPacket(readerIndex);
        }
        catch (Exception e) {
            ActiveMQClientLogger.LOGGER.errorReadingIndex(e);
            throw new RuntimeException(e.getMessage(), e);
        }
        this.readerIndex = readerIndex;
    }

    @Override
    public int writerIndex() {
        return (int)this.totalSize;
    }

    @Override
    public long getSize() {
        return this.totalSize;
    }

    @Override
    public void writerIndex(int writerIndex) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void setIndex(int readerIndex, int writerIndex) {
        try {
            this.checkForPacket(readerIndex);
        }
        catch (Exception e) {
            ActiveMQClientLogger.LOGGER.errorSettingIndex(e);
            throw new RuntimeException(e.getMessage(), e);
        }
        this.readerIndex = readerIndex;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean readable() {
        return true;
    }

    @Override
    public boolean writable() {
        return false;
    }

    @Override
    public int readableBytes() {
        long readableBytes = this.totalSize - this.readerIndex;
        if (readableBytes > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(this.totalSize - this.readerIndex);
    }

    @Override
    public int writableBytes() {
        return 0;
    }

    @Override
    public void markReaderIndex() {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void resetReaderIndex() {
        try {
            this.checkForPacket(0L);
        }
        catch (Exception e) {
            ActiveMQClientLogger.LOGGER.errorReSettingIndex(e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void markWriterIndex() {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void resetWriterIndex() {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void discardReadBytes() {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public short getUnsignedByte(int index) {
        return (short)(this.getByte(index) & 0xFF);
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    public int getMedium(int index) {
        int value = this.getUnsignedMedium(index);
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return value;
    }

    @Override
    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = this.getByte(index++);
        }
    }

    public void getBytes(long index, byte[] dst) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = this.getByte(index++);
        }
    }

    @Override
    public void getBytes(int index, ActiveMQBuffer dst) {
        this.getBytes(index, dst, dst.writableBytes());
    }

    @Override
    public void getBytes(int index, ActiveMQBuffer dst, int length) {
        if (length > dst.writableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.getBytes(index, dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
    }

    @Override
    public void setBytes(int index, byte[] src) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void setBytes(int index, ActiveMQBuffer src) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void setBytes(int index, ActiveMQBuffer src, int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    public void setZero(int index, int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public int readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    @Override
    public short readShort() {
        short v = this.getShort(this.readerIndex);
        this.readerIndex += 2L;
        return v;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public int readMedium() {
        int value = this.readUnsignedMedium();
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return value;
    }

    public int readUnsignedMedium() {
        int v = this.getUnsignedMedium(this.readerIndex);
        this.readerIndex += 3L;
        return v;
    }

    @Override
    public int readInt() {
        int v = this.getInt(this.readerIndex);
        this.readerIndex += 4L;
        return v;
    }

    public int readInt(int pos) {
        return this.getInt(pos);
    }

    @Override
    public Integer readNullableInt() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readInt();
    }

    @Override
    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        long v = this.getLong(this.readerIndex);
        this.readerIndex += 8L;
        return v;
    }

    @Override
    public Long readNullableLong() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readLong();
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.getBytes(this.readerIndex, dst, dstIndex, length);
        this.readerIndex += (long)length;
    }

    @Override
    public void readBytes(byte[] dst) {
        this.readBytes(dst, 0, dst.length);
    }

    @Override
    public void readBytes(ActiveMQBuffer dst) {
        this.readBytes(dst, dst.writableBytes());
    }

    @Override
    public void readBytes(ActiveMQBuffer dst, int length) {
        if (length > dst.writableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.readBytes(dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
    }

    @Override
    public void readBytes(ActiveMQBuffer dst, int dstIndex, int length) {
        this.getBytes(this.readerIndex, dst, dstIndex, length);
        this.readerIndex += (long)length;
    }

    @Override
    public void readBytes(ByteBuffer dst) {
        int length = dst.remaining();
        this.getBytes(this.readerIndex, dst);
        this.readerIndex += (long)length;
    }

    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        int readBytes = this.getBytes((int)this.readerIndex, out, length);
        this.readerIndex += (long)readBytes;
        return readBytes;
    }

    public void readBytes(OutputStream out, int length) throws IOException {
        this.getBytes(this.readerIndex, out, length);
        this.readerIndex += (long)length;
    }

    @Override
    public int skipBytes(int length) {
        long newReaderIndex = this.readerIndex + (long)length;
        this.checkForPacket(newReaderIndex);
        this.readerIndex = newReaderIndex;
        return length;
    }

    @Override
    public void writeByte(byte value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeShort(short value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    public void writeMedium(int value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeInt(int value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeNullableInt(Integer value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeLong(long value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeNullableLong(Long value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeBytes(byte[] src, int srcIndex, int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeBytes(byte[] src) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    public void writeBytes(ActiveMQBuffer src) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeBytes(ActiveMQBuffer src, int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeBytes(ByteBuffer src) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeBytes(ByteBuf src, int srcIndex, int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    public void writeZero(int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public ByteBuffer toByteBuffer() {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    public ByteBuffer[] toByteBuffers() {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    public ByteBuffer[] toByteBuffers(int index, int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    public String toString(String charsetName) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    public Object getUnderlyingBuffer() {
        return this;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public Boolean readNullableBoolean() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readBoolean();
    }

    @Override
    public char readChar() {
        return (char)this.readShort();
    }

    @Override
    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public SimpleString readNullableSimpleString() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readSimpleString();
    }

    @Override
    public String readNullableString() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readString();
    }

    @Override
    public SimpleString readSimpleString() {
        int len = this.readInt();
        byte[] data = new byte[len];
        this.readBytes(data);
        return new SimpleString(data);
    }

    @Override
    public String readString() {
        int len = this.readInt();
        if (len < 9) {
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)this.readShort();
            }
            return new String(chars);
        }
        if (len < 4095) {
            return this.readUTF();
        }
        return this.readSimpleString().toString();
    }

    @Override
    public String readUTF() {
        return UTF8Util.readUTF(this);
    }

    @Override
    public void writeBoolean(boolean val) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeNullableBoolean(Boolean val) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeChar(char val) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeDouble(double val) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeFloat(float val) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeNullableSimpleString(SimpleString val) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeNullableString(String val) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeSimpleString(SimpleString val) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeString(String val) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeUTF(String utf) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public ActiveMQBuffer copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActiveMQBuffer slice(int index, int length) {
        throw new UnsupportedOperationException();
    }

    private void sendPacketToOutput(OutputStream output, LargeData packet) throws ActiveMQException {
        try {
            output.write(packet.getChunk());
            if (!packet.isContinues()) {
                this.streamEnded = true;
                output.close();
            }
        }
        catch (IOException e) {
            throw ActiveMQClientMessageBundle.BUNDLE.errorWritingLargeMessage(e);
        }
    }

    private void popPacket() {
        try {
            if (this.streamEnded) {
                throw new IndexOutOfBoundsException();
            }
            int sizeToAdd = this.currentPacket != null ? this.currentPacket.chunk.length : 1;
            this.currentPacket = this.largeMessageData.poll(this.readTimeout, TimeUnit.MILLISECONDS);
            if (this.currentPacket == null) {
                throw new IndexOutOfBoundsException();
            }
            if (this.currentPacket.chunk == null) {
                this.currentPacket = null;
                this.streamEnded = true;
                throw new IndexOutOfBoundsException();
            }
            this.consumerInternal.flowControl(this.currentPacket.getFlowControlSize(), !this.currentPacket.isContinues());
            this.packetPosition += (long)sizeToAdd;
            this.packetLastPosition = this.packetPosition + (long)this.currentPacket.getChunk().length;
        }
        catch (IndexOutOfBoundsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkForPacket(long index) {
        if (this.totalSize == this.bytesTaken) {
            return;
        }
        if (this.outStream != null) {
            throw new IllegalAccessError("Can't read the messageBody after setting outputStream");
        }
        if (index >= this.totalSize) {
            throw new IndexOutOfBoundsException();
        }
        if (this.streamClosed) {
            throw new IllegalAccessError("The consumer associated with this large message was closed before the body was read");
        }
        if (this.fileCache == null) {
            if (index < this.lastIndex) {
                throw new IllegalAccessError("LargeMessage have read-only and one-way buffers");
            }
            this.lastIndex = index;
        }
        while (index >= this.packetLastPosition && !this.streamEnded) {
            this.popPacket();
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readBytes(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.readBytes(b, off, len);
    }

    @Override
    public String readLine() throws IOException {
        return ByteUtil.readLine(this);
    }

    @Override
    public ByteBuf byteBuf() {
        return null;
    }

    @Override
    public ActiveMQBuffer copy(int index, int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public ActiveMQBuffer duplicate() {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public ActiveMQBuffer readSlice(int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void setChar(int index, char value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void setDouble(int index, double value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void setFloat(int index, float value) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public ActiveMQBuffer slice() {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    @Override
    public void writeBytes(ActiveMQBuffer src, int srcIndex, int length) {
        throw new IllegalAccessError(READ_ONLY_ERROR_MESSAGE);
    }

    public static class LargeData {
        final byte[] chunk;
        final int flowControlSize;
        final boolean continues;

        private LargeData() {
            this.continues = false;
            this.flowControlSize = 0;
            this.chunk = null;
        }

        private LargeData(byte[] chunk, int flowControlSize, boolean continues) {
            this.chunk = chunk;
            this.flowControlSize = flowControlSize;
            this.continues = continues;
        }

        public byte[] getChunk() {
            return this.chunk;
        }

        public int getFlowControlSize() {
            return this.flowControlSize;
        }

        public boolean isContinues() {
            return this.continues;
        }
    }

    private final class FileCache {
        ByteBuffer readCache;
        long readCachePositionStart = Integer.MAX_VALUE;
        long readCachePositionEnd = -1L;
        private final File cachedFile;
        private volatile FileChannel cachedChannel;

        private FileCache(File cachedFile) {
            this.cachedFile = cachedFile;
        }

        private synchronized void readCache(long position) {
            try {
                if (position < this.readCachePositionStart || position > this.readCachePositionEnd) {
                    FileChannel cachedChannel = this.checkOpen();
                    if (position > cachedChannel.size()) {
                        throw new ArrayIndexOutOfBoundsException("position > " + cachedChannel.size());
                    }
                    this.readCachePositionStart = position / (long)LargeMessageControllerImpl.this.bufferSize * (long)LargeMessageControllerImpl.this.bufferSize;
                    cachedChannel.position(this.readCachePositionStart);
                    if (this.readCache == null) {
                        this.readCache = ByteBuffer.allocate(LargeMessageControllerImpl.this.bufferSize);
                    }
                    this.readCache.clear();
                    this.readCachePositionEnd = this.readCachePositionStart + (long)cachedChannel.read(this.readCache) - 1L;
                }
            }
            catch (Exception e) {
                ActiveMQClientLogger.LOGGER.errorReadingCache(e);
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                this.close();
            }
        }

        public synchronized byte getByteFromCache(long position) {
            this.readCache(position);
            return this.readCache.get((int)(position - this.readCachePositionStart));
        }

        public void cachePackage(byte[] body) throws Exception {
            FileChannel cachedChannel = this.checkOpen();
            cachedChannel.position(cachedChannel.size());
            cachedChannel.write(ByteBuffer.wrap(body));
            this.close();
        }

        private FileChannel checkOpen() throws IOException {
            FileChannel channel = this.cachedChannel;
            if (this.cachedFile != null || !channel.isOpen()) {
                this.cachedChannel = channel = FileChannel.open(this.cachedFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            }
            return channel;
        }

        public void close() {
            FileChannel cachedChannel = this.cachedChannel;
            if (cachedChannel != null && cachedChannel.isOpen()) {
                this.cachedChannel = null;
                try {
                    cachedChannel.close();
                }
                catch (Exception e) {
                    ActiveMQClientLogger.LOGGER.errorClosingCache(e);
                }
            }
        }
    }
}

