/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.attributes.coarse;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.clustering.web.cache.session.attributes.coarse.ImmutableSessionAttributesFilter;
import org.wildfly.clustering.web.cache.session.attributes.coarse.SessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.attributes.coarse.SessionAttributesFilter;
import org.wildfly.clustering.web.session.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.web.session.ImmutableSession;

public class ImmutableSessionActivationNotifier<S, C, L>
implements SessionActivationNotifier {
    private final HttpSessionActivationListenerProvider<S, C, L> provider;
    private final ImmutableSession session;
    private final C context;
    private final SessionAttributesFilter filter;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final Function<L, Consumer<S>> prePassivateNotifier;
    private final Function<L, Consumer<S>> postActivateNotifier;

    public ImmutableSessionActivationNotifier(HttpSessionActivationListenerProvider<S, C, L> provider, ImmutableSession session, C context) {
        this(provider, session, context, new ImmutableSessionAttributesFilter(session));
    }

    ImmutableSessionActivationNotifier(HttpSessionActivationListenerProvider<S, C, L> provider, ImmutableSession session, C context, SessionAttributesFilter filter) {
        this.provider = provider;
        this.session = session;
        this.context = context;
        this.filter = filter;
        this.prePassivateNotifier = arg_0 -> this.provider.prePassivateNotifier(arg_0);
        this.postActivateNotifier = arg_0 -> this.provider.postActivateNotifier(arg_0);
    }

    @Override
    public void prePassivate() {
        if (this.active.compareAndSet(true, false)) {
            this.notify(this.prePassivateNotifier);
        }
    }

    @Override
    public void postActivate() {
        if (this.active.compareAndSet(false, true)) {
            this.notify(this.postActivateNotifier);
        }
    }

    private void notify(Function<L, Consumer<S>> notifierFactory) {
        Map listeners = this.filter.getAttributes(this.provider.getHttpSessionActivationListenerClass());
        if (!listeners.isEmpty()) {
            Object session = this.provider.createHttpSession(this.session, this.context);
            for (Object listener : listeners.values()) {
                notifierFactory.apply(listener).accept(session);
            }
        }
    }
}

