/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orb;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orb.ParserActionBase;
import com.sun.corba.se.spi.orb.Operation;
import com.sun.corba.se.spi.orb.StringPair;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class PrefixParserAction
extends ParserActionBase {
    private Class componentType;
    private ORBUtilSystemException wrapper;

    public PrefixParserAction(String propertyName, Operation operation, String fieldName, Class componentType) {
        super(propertyName, true, operation, fieldName);
        this.componentType = componentType;
        this.wrapper = ORBUtilSystemException.get("orb.lifecycle");
    }

    @Override
    public Object apply(Properties props) {
        int prefixLength;
        Object prefix = this.getPropertyName();
        if (((String)prefix).charAt((prefixLength = ((String)prefix).length()) - 1) != '.') {
            prefix = (String)prefix + ".";
            ++prefixLength;
        }
        LinkedList<Object> matches = new LinkedList<Object>();
        for (String string : props.keySet()) {
            if (!string.startsWith((String)prefix)) continue;
            String suffix = string.substring(prefixLength);
            String value = props.getProperty(string);
            StringPair data = new StringPair(suffix, value);
            Object result = this.getOperation().operate(data);
            matches.add(result);
        }
        int n = matches.size();
        if (n > 0) {
            Object result = null;
            try {
                result = Array.newInstance(this.componentType, n);
            }
            catch (Throwable thr) {
                throw this.wrapper.couldNotCreateArray(thr, (Object)this.getPropertyName(), (Object)this.componentType, (Object)new Integer(n));
            }
            Iterator iter2 = matches.iterator();
            int ctr = 0;
            while (iter2.hasNext()) {
                Object obj = iter2.next();
                try {
                    Array.set(result, ctr, obj);
                }
                catch (Throwable thr) {
                    throw this.wrapper.couldNotSetArray(thr, (Object)this.getPropertyName(), (Object)new Integer(ctr), (Object)this.componentType, (Object)new Integer(n), (Object)obj.toString());
                }
                ++ctr;
            }
            return result;
        }
        return null;
    }
}

