/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HANASqlAstTranslator;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.IntegralTimestampaddFunction;
import org.hibernate.dialect.identity.HANAIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.sequence.HANASequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.BlobImplementer;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.ClobImplementer;
import org.hibernate.engine.jdbc.NClobImplementer;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.mapping.Table;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorHANADatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.DoubleJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.DecimalJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.NCharJdbcType;
import org.hibernate.type.descriptor.jdbc.NClobJdbcType;
import org.hibernate.type.descriptor.jdbc.NVarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.NumericJdbcType;
import org.hibernate.type.descriptor.jdbc.TinyIntAsSmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractHANADialect
extends Dialect {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AbstractHANADialect.class);
    private static final String MAX_LOB_PREFETCH_SIZE_PARAMETER_NAME = "hibernate.dialect.hana.max_lob_prefetch_size";
    private static final String USE_LEGACY_BOOLEAN_TYPE_PARAMETER_NAME = "hibernate.dialect.hana.use_legacy_boolean_type";
    private static final String USE_UNICODE_STRING_TYPES_PARAMETER_NAME = "hibernate.dialect.hana.use_unicode_string_types";
    private static final String TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_PARAMETER_NAME = "hibernate.dialect.hana.treat_double_typed_fields_as_decimal";
    private static final int MAX_LOB_PREFETCH_SIZE_DEFAULT_VALUE = 1024;
    private static final Boolean USE_LEGACY_BOOLEAN_TYPE_DEFAULT_VALUE = Boolean.FALSE;
    private static final Boolean TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_DEFAULT_VALUE = Boolean.FALSE;
    private HANANClobJdbcType nClobTypeDescriptor = new HANANClobJdbcType(1024);
    private HANABlobType blobTypeDescriptor = new HANABlobType(1024);
    private HANAClobJdbcType clobTypeDescriptor;
    private boolean useLegacyBooleanType = USE_LEGACY_BOOLEAN_TYPE_DEFAULT_VALUE;
    private boolean useUnicodeStringTypes;
    private final StandardTableExporter hanaTableExporter = new StandardTableExporter(this){

        @Override
        public String[] getSqlCreateStrings(Table table, Metadata metadata, SqlStringGenerationContext context) {
            String[] sqlCreateStrings = super.getSqlCreateStrings(table, metadata, context);
            return this.quoteTypeIfNecessary(table, sqlCreateStrings, AbstractHANADialect.this.getCreateTableString());
        }

        @Override
        public String[] getSqlDropStrings(Table table, Metadata metadata, SqlStringGenerationContext context) {
            String[] sqlDropStrings = super.getSqlDropStrings(table, metadata, context);
            return this.quoteTypeIfNecessary(table, sqlDropStrings, "drop table");
        }

        private String[] quoteTypeIfNecessary(Table table, String[] strings, String prefix) {
            if (table.getNameIdentifier() == null || table.getNameIdentifier().isQuoted() || !"type".equalsIgnoreCase(table.getNameIdentifier().getText())) {
                return strings;
            }
            Pattern createTableTypePattern = Pattern.compile("(" + prefix + "\\s+)(" + table.getNameIdentifier().getText() + ")(.+)");
            Pattern commentOnTableTypePattern = Pattern.compile("(comment\\s+on\\s+table\\s+)(" + table.getNameIdentifier().getText() + ")(.+)");
            for (int i = 0; i < strings.length; ++i) {
                Matcher createTableTypeMatcher = createTableTypePattern.matcher(strings[i]);
                Matcher commentOnTableTypeMatcher = commentOnTableTypePattern.matcher(strings[i]);
                if (createTableTypeMatcher.matches()) {
                    strings[i] = createTableTypeMatcher.group(1) + "\"TYPE\"" + createTableTypeMatcher.group(3);
                }
                if (!commentOnTableTypeMatcher.matches()) continue;
                strings[i] = commentOnTableTypeMatcher.group(1) + "\"TYPE\"" + commentOnTableTypeMatcher.group(3);
            }
            return strings;
        }
    };

    public AbstractHANADialect(DatabaseVersion version) {
        super(version);
        this.useUnicodeStringTypes = this.useUnicodeStringTypesDefault();
        this.clobTypeDescriptor = new HANAClobJdbcType(1024, this.useUnicodeStringTypesDefault());
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return this.useLegacyBooleanType ? "tinyint" : super.columnType(sqlTypeCode);
            }
            case 2: {
                return this.columnType(3);
            }
            case 8: {
                return "double";
            }
            case 92: 
            case 2013: {
                return "time";
            }
            case 93: 
            case 2014: {
                return "timestamp";
            }
            case 1: 
            case 12: {
                return this.isUseUnicodeStringTypes() ? this.columnType(-9) : super.columnType(12);
            }
            case -15: {
                return this.columnType(-9);
            }
            case 4001: {
                return this.isUseUnicodeStringTypes() ? this.columnType(4002) : super.columnType(4001);
            }
            case 2005: {
                return this.isUseUnicodeStringTypes() ? this.columnType(2011) : super.columnType(2005);
            }
            case -6: {
                return "smallint";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        ConfigurationService configurationService = serviceRegistry.getService(ConfigurationService.class);
        if (this.supportsAsciiStringTypes()) {
            this.useUnicodeStringTypes = configurationService.getSetting(USE_UNICODE_STRING_TYPES_PARAMETER_NAME, StandardConverters.BOOLEAN, this.useUnicodeStringTypesDefault());
        }
        this.useLegacyBooleanType = configurationService.getSetting(USE_LEGACY_BOOLEAN_TYPE_PARAMETER_NAME, StandardConverters.BOOLEAN, USE_LEGACY_BOOLEAN_TYPE_DEFAULT_VALUE);
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(-2, CapacityDependentDdlType.LobKind.BIGGEST_LOB, "blob", (Dialect)this).withTypeCapacity(this.getMaxVarbinaryLength(), "varbinary($l)").build());
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "st_geometry", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3201, "st_point", this));
    }

    @Override
    public boolean getDefaultNonContextualLobCreation() {
        return true;
    }

    @Override
    public boolean getDefaultUseGetGeneratedKeys() {
        return false;
    }

    protected static DatabaseVersion createVersion(DialectResolutionInfo info) {
        String versionString = info.getDatabaseVersion();
        int majorVersion = 1;
        int minorVersion = 0;
        int patchLevel = 0;
        String[] components = versionString.split("\\.");
        if (components.length >= 3) {
            try {
                majorVersion = Integer.parseInt(components[0]);
                minorVersion = Integer.parseInt(components[1]);
                patchLevel = Integer.parseInt(components[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return DatabaseVersion.make(majorVersion, minorVersion, patchLevel);
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (to == CastType.BOOLEAN) {
            switch (from) {
                case INTEGER_BOOLEAN: 
                case INTEGER: 
                case LONG: {
                    return "case ?1 when 1 then true when 0 then false else null end";
                }
                case YN_BOOLEAN: {
                    return "case ?1 when 'Y' then true when 'N' then false else null end";
                }
                case TF_BOOLEAN: {
                    return "case ?1 when 'T' then true when 'F' then false else null end";
                }
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 34;
    }

    @Override
    public int getMaxVarcharLength() {
        return 5000;
    }

    @Override
    public int getMaxNVarcharLength() {
        return 5000;
    }

    @Override
    public int getMaxVarbinaryLength() {
        return 5000;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("locate", typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER), "locate(?2,?1)", "locate(?2,?1,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, typeConfiguration).setArgumentListSignature("(pattern, string[, start])");
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.ceiling_ceil();
        functionFactory.concat_pipeOperator();
        functionFactory.trim2();
        functionFactory.cot();
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.trunc_roundMode();
        functionFactory.log10_log();
        functionFactory.log();
        functionFactory.bitand();
        functionFactory.hourMinuteSecond();
        functionFactory.yearMonthDay();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.characterLength_length(SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.ascii();
        functionFactory.chr_char();
        functionFactory.addYearsMonthsDaysHoursMinutesSeconds();
        functionFactory.daysBetween();
        functionFactory.secondsBetween();
        functionFactory.format_toVarchar();
        functionFactory.currentUtcdatetimetimestamp();
        functionFactory.everyAny_minMaxCase();
        functionFactory.octetLength_pattern("length(to_binary(?1))");
        functionFactory.bitLength_pattern("length(to_binary(?1))*8");
        functionFactory.repeat_rpad();
        functionFactory.median();
        functionFactory.windowFunctions();
        functionFactory.listagg_stringAgg("varchar");
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        functionFactory.radians_acos();
        functionFactory.degrees_acos();
        functionContributions.getFunctionRegistry().register("timestampadd", new IntegralTimestampaddFunction(this, typeConfiguration));
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, org.hibernate.sql.ast.tree.Statement statement) {
                return new HANASqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "(mod(weekday(?2)+1,7)+1)";
            }
            case DAY: 
            case DAY_OF_MONTH: {
                return "dayofmonth(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
            case QUARTER: {
                return "((month(?2)+2)/3)";
            }
            case EPOCH: {
                return "seconds_between('1970-01-01', ?2)";
            }
        }
        return "?1(?2)";
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            if (errorCode == 131) {
                return new LockTimeoutException(message, sqlException, sql);
            }
            if (errorCode == 146) {
                return new LockTimeoutException(message, sqlException, sql);
            }
            if (errorCode == 132) {
                return new LockAcquisitionException(message, sqlException, sql);
            }
            if (errorCode == 133) {
                return new LockAcquisitionException(message, sqlException, sql);
            }
            if (errorCode == 257 || errorCode >= 259 && errorCode <= 263) {
                throw new SQLGrammarException(message, sqlException, sql);
            }
            if (errorCode == 287 || errorCode == 301 || errorCode == 461 || errorCode == 462) {
                String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                return new ConstraintViolationException(message, sqlException, sql, constraintName);
            }
            return null;
        };
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.COLUMN;
    }

    @Override
    public String getAddColumnString() {
        return "add (";
    }

    @Override
    public String getAddColumnSuffixString() {
        return ")";
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp from sys.dummy";
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode = lockOptions.findGreatestLockMode();
        lockOptions.setLockMode(lockMode);
        if (aliases == null || aliases.isEmpty()) {
            return this.getForUpdateString(lockOptions);
        }
        return this.getForUpdateString(aliases, lockMode, lockOptions.getTimeOut());
    }

    private String getForUpdateString(String aliases, LockMode lockMode, int timeout) {
        switch (lockMode) {
            case PESSIMISTIC_READ: {
                return this.getReadLockString(aliases, timeout);
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(aliases, timeout);
            }
            case UPGRADE_NOWAIT: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                return this.getForUpdateNowaitString(aliases);
            }
            case UPGRADE_SKIPLOCKED: {
                return this.getForUpdateSkipLockedString(aliases);
            }
        }
        return "";
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.getForUpdateString() + " nowait";
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from sys.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorHANADatabaseImpl.INSTANCE;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("all");
        this.registerKeyword("alter");
        this.registerKeyword("as");
        this.registerKeyword("before");
        this.registerKeyword("begin");
        this.registerKeyword("both");
        this.registerKeyword("case");
        this.registerKeyword("char");
        this.registerKeyword("condition");
        this.registerKeyword("connect");
        this.registerKeyword("cross");
        this.registerKeyword("cube");
        this.registerKeyword("current_connection");
        this.registerKeyword("current_date");
        this.registerKeyword("current_schema");
        this.registerKeyword("current_time");
        this.registerKeyword("current_timestamp");
        this.registerKeyword("current_transaction_isolation_level");
        this.registerKeyword("current_user");
        this.registerKeyword("current_utcdate");
        this.registerKeyword("current_utctime");
        this.registerKeyword("current_utctimestamp");
        this.registerKeyword("currval");
        this.registerKeyword("cursor");
        this.registerKeyword("declare");
        this.registerKeyword("deferred");
        this.registerKeyword("distinct");
        this.registerKeyword("else");
        this.registerKeyword("elseif");
        this.registerKeyword("end");
        this.registerKeyword("except");
        this.registerKeyword("exception");
        this.registerKeyword("exec");
        this.registerKeyword("false");
        this.registerKeyword("for");
        this.registerKeyword("from");
        this.registerKeyword("full");
        this.registerKeyword("group");
        this.registerKeyword("having");
        this.registerKeyword("if");
        this.registerKeyword("in");
        this.registerKeyword("inner");
        this.registerKeyword("inout");
        this.registerKeyword("intersect");
        this.registerKeyword("into");
        this.registerKeyword("is");
        this.registerKeyword("join");
        this.registerKeyword("leading");
        this.registerKeyword("left");
        this.registerKeyword("limit");
        this.registerKeyword("loop");
        this.registerKeyword("minus");
        this.registerKeyword("natural");
        this.registerKeyword("nchar");
        this.registerKeyword("nextval");
        this.registerKeyword("null");
        this.registerKeyword("on");
        this.registerKeyword("order");
        this.registerKeyword("out");
        this.registerKeyword("prior");
        this.registerKeyword("return");
        this.registerKeyword("returns");
        this.registerKeyword("reverse");
        this.registerKeyword("right");
        this.registerKeyword("rollup");
        this.registerKeyword("rowid");
        this.registerKeyword("select");
        this.registerKeyword("session_user");
        this.registerKeyword("set");
        this.registerKeyword("sql");
        this.registerKeyword("start");
        this.registerKeyword("sysuuid");
        this.registerKeyword("tablesample");
        this.registerKeyword("top");
        this.registerKeyword("trailing");
        this.registerKeyword("true");
        this.registerKeyword("union");
        this.registerKeyword("unknown");
        this.registerKeyword("using");
        this.registerKeyword("utctimestamp");
        this.registerKeyword("values");
        this.registerKeyword("when");
        this.registerKeyword("where");
        this.registerKeyword("while");
        this.registerKeyword("with");
    }

    @Override
    public ScrollMode defaultScrollMode() {
        return ScrollMode.FORWARD_ONLY;
    }

    @Override
    public boolean supportsColumnCheck() {
        return false;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean supportsExpectedLobUsagePattern() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return HANASequenceSupport.INSTANCE;
    }

    @Override
    public boolean supportsTableCheck() {
        return true;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return true;
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public int getMaxAliasLength() {
        return 128;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 127;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LimitOffsetLimitHandler.INSTANCE;
    }

    @Override
    public String getSelectGUIDString() {
        return "select sysuuid from sys.dummy";
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.UPPER);
        final IdentifierHelper identifierHelper = super.buildIdentifierHelper(builder, dbMetaData);
        return new IdentifierHelper(){
            private final IdentifierHelper helper;
            {
                this.helper = identifierHelper;
            }

            @Override
            public String toMetaDataSchemaName(Identifier schemaIdentifier) {
                return this.helper.toMetaDataSchemaName(schemaIdentifier);
            }

            @Override
            public String toMetaDataObjectName(Identifier identifier) {
                return this.helper.toMetaDataObjectName(identifier);
            }

            @Override
            public String toMetaDataCatalogName(Identifier catalogIdentifier) {
                return this.helper.toMetaDataCatalogName(catalogIdentifier);
            }

            @Override
            public Identifier toIdentifier(String text) {
                return this.normalizeQuoting(Identifier.toIdentifier(text));
            }

            @Override
            public Identifier toIdentifier(String text, boolean quoted) {
                return this.normalizeQuoting(Identifier.toIdentifier(text, quoted));
            }

            @Override
            public Identifier normalizeQuoting(Identifier identifier) {
                Identifier normalizedIdentifier = this.helper.normalizeQuoting(identifier);
                if (normalizedIdentifier == null) {
                    return null;
                }
                if (!normalizedIdentifier.isQuoted() && !normalizedIdentifier.getText().matches("\\w+")) {
                    normalizedIdentifier = Identifier.quote(normalizedIdentifier);
                }
                return normalizedIdentifier;
            }

            @Override
            public boolean isReservedWord(String word) {
                return this.helper.isReservedWord(word);
            }

            @Override
            public Identifier applyGlobalQuoting(String text) {
                return this.helper.applyGlobalQuoting(text);
            }
        };
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select current_schema from sys.dummy";
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString(aliases) + " nowait";
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.getWriteLockString(timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        return this.getWriteLockString(aliases, timeout);
    }

    @Override
    public String getWriteLockString(int timeout) {
        if (timeout > 0) {
            return this.getForUpdateString() + " wait " + this.getTimeoutInSeconds(timeout);
        }
        if (timeout == 0) {
            return this.getForUpdateNowaitString();
        }
        return this.getForUpdateString();
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        if (timeout > 0) {
            return this.getForUpdateString(aliases) + " wait " + this.getTimeoutInSeconds(timeout);
        }
        if (timeout == 0) {
            return this.getForUpdateNowaitString(aliases);
        }
        return this.getForUpdateString(aliases);
    }

    @Override
    public String getQueryHintString(String query, List<String> hints) {
        return query + " with hint (" + String.join((CharSequence)",", hints) + ")";
    }

    @Override
    public String getTableComment(String comment) {
        return " comment '" + comment + "'";
    }

    @Override
    public String getColumnComment(String comment) {
        return " comment '" + comment + "'";
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        ConnectionProvider connectionProvider = serviceRegistry.getService(ConnectionProvider.class);
        int maxLobPrefetchSizeDefault = 1024;
        if (connectionProvider != null) {
            Connection conn = null;
            try {
                conn = connectionProvider.getConnection();
                try (Statement statement = conn.createStatement();
                     ResultSet rs = statement.executeQuery("SELECT TOP 1 VALUE,MAP(LAYER_NAME,'DEFAULT',1,'SYSTEM',2,'DATABASE',3,4) AS LAYER FROM SYS.M_INIFILE_CONTENTS WHERE FILE_NAME='indexserver.ini' AND SECTION='session' AND KEY='max_lob_prefetch_size' ORDER BY LAYER DESC");){
                    if (rs.next()) {
                        maxLobPrefetchSizeDefault = rs.getInt(1);
                    }
                }
            }
            catch (Exception e) {
                LOG.debug("An error occurred while trying to determine the value of the HANA parameter indexserver.ini / session / max_lob_prefetch_size. Using the default value " + maxLobPrefetchSizeDefault, e);
            }
            finally {
                if (conn != null) {
                    try {
                        connectionProvider.closeConnection(conn);
                    }
                    catch (SQLException e) {}
                }
            }
        }
        ConfigurationService configurationService = serviceRegistry.getService(ConfigurationService.class);
        int maxLobPrefetchSize = configurationService.getSetting(MAX_LOB_PREFETCH_SIZE_PARAMETER_NAME, value -> Integer.valueOf(value.toString()), Integer.valueOf(maxLobPrefetchSizeDefault));
        if (this.nClobTypeDescriptor.getMaxLobPrefetchSize() != maxLobPrefetchSize) {
            this.nClobTypeDescriptor = new HANANClobJdbcType(maxLobPrefetchSize);
        }
        if (this.blobTypeDescriptor.getMaxLobPrefetchSize() != maxLobPrefetchSize) {
            this.blobTypeDescriptor = new HANABlobType(maxLobPrefetchSize);
        }
        if (this.supportsAsciiStringTypes() && (this.clobTypeDescriptor.getMaxLobPrefetchSize() != maxLobPrefetchSize || this.clobTypeDescriptor.isUseUnicodeStringTypes() != this.useUnicodeStringTypes)) {
            this.clobTypeDescriptor = new HANAClobJdbcType(maxLobPrefetchSize, this.useUnicodeStringTypes);
        }
        boolean treatDoubleTypedFieldsAsDecimal = configurationService.getSetting(TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_PARAMETER_NAME, StandardConverters.BOOLEAN, TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_DEFAULT_VALUE);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (treatDoubleTypedFieldsAsDecimal) {
            typeContributions.getTypeConfiguration().getBasicTypeRegistry().register((BasicType<?>)new BasicTypeImpl<Double>(DoubleJavaType.INSTANCE, NumericJdbcType.INSTANCE), Double.class.getName());
            typeContributions.getTypeConfiguration().getJdbcToHibernateTypeContributionMap().computeIfAbsent(6, code -> new HashSet()).clear();
            typeContributions.getTypeConfiguration().getJdbcToHibernateTypeContributionMap().computeIfAbsent(7, code -> new HashSet()).clear();
            typeContributions.getTypeConfiguration().getJdbcToHibernateTypeContributionMap().computeIfAbsent(8, code -> new HashSet()).clear();
            typeContributions.getTypeConfiguration().getJdbcToHibernateTypeContributionMap().get(6).add(StandardBasicTypes.BIG_DECIMAL.getName());
            typeContributions.getTypeConfiguration().getJdbcToHibernateTypeContributionMap().get(7).add(StandardBasicTypes.BIG_DECIMAL.getName());
            typeContributions.getTypeConfiguration().getJdbcToHibernateTypeContributionMap().get(8).add(StandardBasicTypes.BIG_DECIMAL.getName());
            jdbcTypeRegistry.addDescriptor(6, NumericJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(7, NumericJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(8, NumericJdbcType.INSTANCE);
        }
        jdbcTypeRegistry.addDescriptor(2005, this.clobTypeDescriptor);
        jdbcTypeRegistry.addDescriptor(2011, this.nClobTypeDescriptor);
        jdbcTypeRegistry.addDescriptor(2004, this.blobTypeDescriptor);
        jdbcTypeRegistry.addDescriptor(-6, TinyIntAsSmallIntJdbcType.INSTANCE);
        if (this.isUseUnicodeStringTypes()) {
            jdbcTypeRegistry.addDescriptor(12, NVarcharJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(1, NCharJdbcType.INSTANCE);
        }
        if (treatDoubleTypedFieldsAsDecimal) {
            jdbcTypeRegistry.addDescriptor(8, DecimalJdbcType.INSTANCE);
        }
    }

    public JdbcType getBlobTypeDescriptor() {
        return this.blobTypeDescriptor;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        if (this.useLegacyBooleanType) {
            appender.appendSql(bool ? (char)'1' : '0');
        } else {
            appender.appendSql(bool);
        }
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return HANAIdentityColumnSupport.INSTANCE;
    }

    @Override
    public Exporter<Table> getTableExporter() {
        return this.hanaTableExporter;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.REF_CURSOR_INSTANCE;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int position) throws SQLException {
        return position;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(2, 0, 40);
    }

    @Override
    public boolean supportsNoWait() {
        return true;
    }

    @Override
    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }

    @Override
    public boolean supportsNoColumnsInsert() {
        return false;
    }

    @Override
    public boolean supportsOrderByInSubquery() {
        return true;
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat(format, false, false).result());
    }

    @Override
    public boolean supportsFractionalTimestampArithmetic() {
        return false;
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 100L;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: {
                if (temporalType == TemporalType.TIME) {
                    return "cast(add_nano100('1970-01-01 '||(?3),?2/100) as time)";
                }
                return "add_nano100(?3,?2/100)";
            }
            case NATIVE: {
                if (temporalType == TemporalType.TIME) {
                    return "cast(add_nano100('1970-01-01 '||(?3),?2) as time)";
                }
                return "add_nano100(?3,?2)";
            }
            case QUARTER: {
                return "add_months(?3,3*?2)";
            }
            case WEEK: {
                return "add_days(?3,7*?2)";
            }
            case MINUTE: {
                return "add_seconds(?3,60*?2)";
            }
            case HOUR: {
                return "add_seconds(?3,3600*?2)";
            }
        }
        return "add_?1s(?3,?2)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NANOSECOND: {
                if (fromTemporalType == TemporalType.TIME && toTemporalType == TemporalType.TIME) {
                    return "seconds_between(?2,?3)*1000000000";
                }
                return "nano100_between(?2,?3)*100";
            }
            case NATIVE: {
                if (fromTemporalType == TemporalType.TIME && toTemporalType == TemporalType.TIME) {
                    return "seconds_between(?2,?3)*10000000";
                }
                return "nano100_between(?2,?3)";
            }
            case QUARTER: {
                return "months_between(?2,?3)/3";
            }
            case WEEK: {
                return "days_between(?2,?3)/7";
            }
            case MINUTE: {
                return "seconds_between(?2,?3)/60";
            }
            case HOUR: {
                return "seconds_between(?2,?3)/3600";
            }
        }
        return "?1s_between(?2,?3)";
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsTime(appender, date);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    public boolean isUseUnicodeStringTypes() {
        return this.useUnicodeStringTypes;
    }

    protected abstract boolean supportsAsciiStringTypes();

    protected abstract Boolean useUnicodeStringTypesDefault();

    public static class HANABlobType
    implements JdbcType {
        private static final long serialVersionUID = 5874441715643764323L;
        final int maxLobPrefetchSize;
        final HANAStreamBlobType hanaStreamBlobTypeDescriptor;

        public HANABlobType(int maxLobPrefetchSize) {
            this.maxLobPrefetchSize = maxLobPrefetchSize;
            this.hanaStreamBlobTypeDescriptor = new HANAStreamBlobType(maxLobPrefetchSize);
        }

        @Override
        public int getJdbcTypeCode() {
            return 2004;
        }

        @Override
        public String getFriendlyName() {
            return "BLOB (hana)";
        }

        public String toString() {
            return "HANABlobType";
        }

        @Override
        public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
            return new BasicExtractor<X>(javaType, this){

                @Override
                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    Blob rsBlob = rs.getBlob(paramIndex);
                    if (rsBlob == null || rsBlob.length() < (long)maxLobPrefetchSize) {
                        return javaType.wrap(rsBlob, options);
                    }
                    MaterializedBlob blob = new MaterializedBlob(DataHelper.extractBytes(rsBlob.getBinaryStream()));
                    return javaType.wrap(blob, options);
                }

                @Override
                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return javaType.wrap(statement.getBlob(index), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return javaType.wrap(statement.getBlob(name), options);
                }
            };
        }

        public <X> BasicBinder<X> getBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    JdbcType descriptor = BlobJdbcType.BLOB_BINDING;
                    if (value instanceof byte[]) {
                        descriptor = BlobJdbcType.PRIMITIVE_ARRAY_BINDING;
                    } else if (options.useStreamForLobBinding()) {
                        descriptor = hanaStreamBlobTypeDescriptor;
                    }
                    descriptor.getBinder(javaType).bind(st, value, index, options);
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    JdbcType descriptor = BlobJdbcType.BLOB_BINDING;
                    if (value instanceof byte[]) {
                        descriptor = BlobJdbcType.PRIMITIVE_ARRAY_BINDING;
                    } else if (options.useStreamForLobBinding()) {
                        descriptor = hanaStreamBlobTypeDescriptor;
                    }
                    descriptor.getBinder(javaType).bind(st, value, name, options);
                }
            };
        }

        public int getMaxLobPrefetchSize() {
            return this.maxLobPrefetchSize;
        }
    }

    private static class HANANClobJdbcType
    extends NClobJdbcType {
        private static final long serialVersionUID = 5651116091681647859L;
        final int maxLobPrefetchSize;

        public HANANClobJdbcType(int maxLobPrefetchSize) {
            this.maxLobPrefetchSize = maxLobPrefetchSize;
        }

        @Override
        public String toString() {
            return "HANANClobTypeDescriptor";
        }

        @Override
        public <X> BasicBinder<X> getNClobBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaType.unwrap(value, CharacterStream.class, options);
                    if (value instanceof NClobImplementer) {
                        try (CloseSuppressingReader r = new CloseSuppressingReader(characterStream.asReader());){
                            st.setCharacterStream(index, (Reader)r, characterStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setCharacterStream(index, characterStream.asReader(), characterStream.getLength());
                    }
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaType.unwrap(value, CharacterStream.class, options);
                    if (value instanceof NClobImplementer) {
                        try (CloseSuppressingReader r = new CloseSuppressingReader(characterStream.asReader());){
                            st.setCharacterStream(name, (Reader)r, characterStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setCharacterStream(name, characterStream.asReader(), characterStream.getLength());
                    }
                }
            };
        }

        @Override
        public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
            return new BasicExtractor<X>(javaType, this){

                @Override
                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    NClob rsNClob = rs.getNClob(paramIndex);
                    if (rsNClob == null || rsNClob.length() < (long)maxLobPrefetchSize) {
                        return javaType.wrap(rsNClob, options);
                    }
                    MaterializedNClob nClob = new MaterializedNClob(DataHelper.extractString(rsNClob));
                    return javaType.wrap(nClob, options);
                }

                @Override
                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return javaType.wrap(statement.getNClob(index), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return javaType.wrap(statement.getNClob(name), options);
                }
            };
        }

        public int getMaxLobPrefetchSize() {
            return this.maxLobPrefetchSize;
        }
    }

    private static class HANAClobJdbcType
    extends ClobJdbcType {
        private static final long serialVersionUID = -379042275442752102L;
        final int maxLobPrefetchSize;
        final boolean useUnicodeStringTypes;

        @Override
        public String toString() {
            return "HANAClobTypeDescriptor";
        }

        public HANAClobJdbcType(int maxLobPrefetchSize, boolean useUnicodeStringTypes) {
            this.maxLobPrefetchSize = maxLobPrefetchSize;
            this.useUnicodeStringTypes = useUnicodeStringTypes;
        }

        @Override
        public <X> BasicBinder<X> getClobBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaType.unwrap(value, CharacterStream.class, options);
                    if (value instanceof ClobImplementer) {
                        try (CloseSuppressingReader r = new CloseSuppressingReader(characterStream.asReader());){
                            st.setCharacterStream(index, (Reader)r, characterStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setCharacterStream(index, characterStream.asReader(), characterStream.getLength());
                    }
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaType.unwrap(value, CharacterStream.class, options);
                    if (value instanceof ClobImplementer) {
                        try (CloseSuppressingReader r = new CloseSuppressingReader(characterStream.asReader());){
                            st.setCharacterStream(name, (Reader)r, characterStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setCharacterStream(name, characterStream.asReader(), characterStream.getLength());
                    }
                }
            };
        }

        @Override
        public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
            return new BasicExtractor<X>(javaType, this){

                @Override
                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    Clob rsClob = useUnicodeStringTypes ? rs.getNClob(paramIndex) : rs.getClob(paramIndex);
                    if (rsClob == null || rsClob.length() < (long)maxLobPrefetchSize) {
                        return javaType.wrap(rsClob, options);
                    }
                    MaterializedNClob clob = new MaterializedNClob(DataHelper.extractString(rsClob));
                    return javaType.wrap(clob, options);
                }

                @Override
                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return javaType.wrap(statement.getClob(index), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return javaType.wrap(statement.getClob(name), options);
                }
            };
        }

        public int getMaxLobPrefetchSize() {
            return this.maxLobPrefetchSize;
        }

        public boolean isUseUnicodeStringTypes() {
            return this.useUnicodeStringTypes;
        }
    }

    private static class HANAStreamBlobType
    implements JdbcType {
        private static final long serialVersionUID = -2476600722093442047L;
        final int maxLobPrefetchSize;

        public HANAStreamBlobType(int maxLobPrefetchSize) {
            this.maxLobPrefetchSize = maxLobPrefetchSize;
        }

        @Override
        public String getFriendlyName() {
            return "BLOB (hana-stream)";
        }

        public String toString() {
            return "HANAStreamBlobType";
        }

        @Override
        public int getJdbcTypeCode() {
            return 2004;
        }

        @Override
        public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    BinaryStream binaryStream = javaType.unwrap(value, BinaryStream.class, options);
                    if (value instanceof BlobImplementer) {
                        try (CloseSuppressingInputStream is = new CloseSuppressingInputStream(binaryStream.getInputStream());){
                            st.setBinaryStream(index, (InputStream)is, binaryStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setBinaryStream(index, binaryStream.getInputStream(), binaryStream.getLength());
                    }
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    BinaryStream binaryStream = javaType.unwrap(value, BinaryStream.class, options);
                    if (value instanceof BlobImplementer) {
                        try (CloseSuppressingInputStream is = new CloseSuppressingInputStream(binaryStream.getInputStream());){
                            st.setBinaryStream(name, (InputStream)is, binaryStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setBinaryStream(name, binaryStream.getInputStream(), binaryStream.getLength());
                    }
                }
            };
        }

        @Override
        public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
            return new BasicExtractor<X>(javaType, this){

                @Override
                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    Blob rsBlob = rs.getBlob(paramIndex);
                    if (rsBlob == null || rsBlob.length() < (long)maxLobPrefetchSize) {
                        return javaType.wrap(rsBlob, options);
                    }
                    MaterializedBlob blob = new MaterializedBlob(DataHelper.extractBytes(rsBlob.getBinaryStream()));
                    return javaType.wrap(blob, options);
                }

                @Override
                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return javaType.wrap(statement.getBlob(index), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return javaType.wrap(statement.getBlob(name), options);
                }
            };
        }
    }

    private static class MaterializedNClob
    implements NClob {
        private String data;

        public MaterializedNClob(String data) {
            this.data = data;
        }

        @Override
        public void truncate(long len) throws SQLException {
            this.data = "";
        }

        @Override
        public int setString(long pos, String str, int offset, int len) throws SQLException {
            this.data = this.data.substring(0, (int)(pos - 1L)) + str.substring(offset, offset + len) + this.data.substring((int)(pos - 1L + (long)len));
            return len;
        }

        @Override
        public int setString(long pos, String str) throws SQLException {
            this.data = this.data.substring(0, (int)(pos - 1L)) + str + this.data.substring((int)(pos - 1L + (long)str.length()));
            return str.length();
        }

        @Override
        public Writer setCharacterStream(long pos) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public OutputStream setAsciiStream(long pos) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public long position(Clob searchstr, long start) throws SQLException {
            return this.data.indexOf(DataHelper.extractString(searchstr), (int)(start - 1L));
        }

        @Override
        public long position(String searchstr, long start) throws SQLException {
            return this.data.indexOf(searchstr, (int)(start - 1L));
        }

        @Override
        public long length() throws SQLException {
            return this.data.length();
        }

        @Override
        public String getSubString(long pos, int length) throws SQLException {
            return this.data.substring((int)(pos - 1L), (int)(pos - 1L + (long)length));
        }

        @Override
        public Reader getCharacterStream(long pos, long length) throws SQLException {
            return new StringReader(this.data.substring((int)(pos - 1L), (int)(pos - 1L + length)));
        }

        @Override
        public Reader getCharacterStream() throws SQLException {
            return new StringReader(this.data);
        }

        @Override
        public InputStream getAsciiStream() {
            return new ByteArrayInputStream(this.data.getBytes(StandardCharsets.ISO_8859_1));
        }

        @Override
        public void free() throws SQLException {
            this.data = null;
        }
    }

    private static class MaterializedBlob
    implements Blob {
        private byte[] bytes = null;

        public MaterializedBlob(byte[] bytes) {
            this.setBytes(bytes);
        }

        @Override
        public long length() throws SQLException {
            return this.getBytes().length;
        }

        @Override
        public byte[] getBytes(long pos, int length) throws SQLException {
            return Arrays.copyOfRange(this.bytes, (int)(pos - 1L), (int)(pos - 1L + (long)length));
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            return new ByteArrayInputStream(this.getBytes());
        }

        @Override
        public long position(byte[] pattern, long start) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public long position(Blob pattern, long start) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public int setBytes(long pos, byte[] bytes) throws SQLException {
            int bytesSet = 0;
            if ((long)this.bytes.length < pos - 1L + (long)bytes.length) {
                this.bytes = Arrays.copyOf(this.bytes, (int)(pos - 1L + (long)bytes.length));
            }
            int i = 0;
            while (i < bytes.length && i < this.bytes.length) {
                this.bytes[(int)((long)i + pos - 1L)] = bytes[i];
                ++i;
                ++bytesSet;
            }
            return bytesSet;
        }

        @Override
        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            int bytesSet = 0;
            if ((long)this.bytes.length < pos - 1L + (long)len) {
                this.bytes = Arrays.copyOf(this.bytes, (int)(pos - 1L + (long)len));
            }
            int i = offset;
            while (i < len && i < this.bytes.length) {
                this.bytes[(int)((long)i + pos - 1L)] = bytes[i];
                ++i;
                ++bytesSet;
            }
            return bytesSet;
        }

        @Override
        public OutputStream setBinaryStream(long pos) {
            return new ByteArrayOutputStream(){
                {
                    this.buf = this.getBytes();
                }
            };
        }

        @Override
        public void truncate(long len) throws SQLException {
            this.setBytes(Arrays.copyOf(this.getBytes(), (int)len));
        }

        @Override
        public void free() throws SQLException {
            this.setBytes(null);
        }

        @Override
        public InputStream getBinaryStream(long pos, long length) throws SQLException {
            return new ByteArrayInputStream(this.getBytes(), (int)(pos - 1L), (int)length);
        }

        byte[] getBytes() {
            return this.bytes;
        }

        void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    private static class CloseSuppressingInputStream
    extends FilterInputStream {
        protected CloseSuppressingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }

    private static class CloseSuppressingReader
    extends FilterReader {
        protected CloseSuppressingReader(Reader in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

