/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.common.pool;

import java.util.List;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.msc.service.ServiceController;

public abstract class PoolMetrics
implements OperationStepHandler {
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String jndiName = address.getLastElement().getValue();
                    String attributeName = operation.require("name").asString();
                    ServiceController managementRepoService = context.getServiceRegistry(false).getService(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE);
                    if (managementRepoService != null) {
                        try {
                            ManagementRepository repository = (ManagementRepository)managementRepoService.getValue();
                            ModelNode result = context.getResult();
                            List<StatisticsPlugin> stats = PoolMetrics.this.getMatchingStats(jndiName, repository);
                            for (StatisticsPlugin stat : stats) {
                                result.set("" + stat.getValue(attributeName));
                            }
                        }
                        catch (Exception e) {
                            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToGetMetrics(e.getLocalizedMessage()));
                        }
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected abstract List<StatisticsPlugin> getMatchingStats(String var1, ManagementRepository var2);

    public static class ParametrizedPoolMetricsHandler
    implements OperationStepHandler {
        private final StatisticsPlugin stats;

        public ParametrizedPoolMetricsHandler(StatisticsPlugin stats) {
            this.stats = stats;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer()) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        String attributeName = operation.require("name").asString();
                        ServiceController managementRepoService = context.getServiceRegistry(false).getService(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE);
                        if (managementRepoService != null) {
                            try {
                                this.setModelValue(context.getResult(), attributeName);
                            }
                            catch (Exception e) {
                                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToGetMetrics(e.getLocalizedMessage()));
                            }
                        }
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        private void setModelValue(ModelNode result, String attributeName) {
            if (this.stats.getType(attributeName) == Integer.TYPE) {
                result.set(((Integer)this.stats.getValue(attributeName)).intValue());
            } else if (this.stats.getType(attributeName) == Long.TYPE) {
                result.set(((Long)this.stats.getValue(attributeName)).longValue());
            } else {
                result.set("" + this.stats.getValue(attributeName));
            }
        }
    }
}

